import { _decorator, Component, Node, Animation, Sprite, AnimationClip,SpriteAtlas,math } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
    @property(SpriteAtlas)
    private frames: SpriteAtlas;

    start() {
        let node = new Node();
        node.setScale(new math.Vec3(2, 2, 1))
        let sp = node.addComponent(Sprite)
        sp.spriteFrame = this.frames.getSpriteFrame("buff_arrow_7");

        let animation = node.addComponent(Animation);
        let animationClip = AnimationClip.createWithSpriteFrames(this.frames.getSpriteFrames(), 5);
        // animation.clips.push(animationClip);
        animation.addClip(animationClip);
        // animation.playOnLoad = true;
        animationClip.wrapMode = AnimationClip.WrapMode.Loop;
        // animationClip.speed = 1
        // animation.defaultClip = animationClip
        // animationClip.name = "test"
        animation.play();
        this.node.addChild(node);
    }

    update(deltaTime: number) {
        
    }
}


