"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPluginConfigs = getPluginConfigs;
exports.getI18nConfig = getI18nConfig;
const fs_extra_1 = require("fs-extra");
const exclude = ["plugin-bridge", "plugin-editor", "plugin-test"];
function isExclude(name) {
    return exclude.includes(name);
}
function getPluginConfigs() {
    const files = (0, fs_extra_1.readdirSync)(Editor.Project.path + "/extensions");
    let pluginConfigs = {};
    for (let i = 0; i < files.length; i++) {
        const file = files[i];
        const stats = (0, fs_extra_1.statSync)(Editor.Project.path + "/extensions/" + file);
        if (stats.isDirectory() && (0, fs_extra_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/package.json") && !isExclude(file)) {
            let configFile = (0, fs_extra_1.readFileSync)(Editor.Project.path + "/extensions/" + file + "/package.json", "utf-8");
            let config = JSON.parse(configFile);
            // config.path = Editor.Project.path + "/extensions/" + file;
            pluginConfigs[config.name] = config;
        }
    }
    return pluginConfigs;
}
function getI18nConfig() {
    let pluginsi18n = {};
    const files = (0, fs_extra_1.readdirSync)(Editor.Project.path + "/extensions");
    for (let i = 0; i < files.length; i++) {
        const file = files[i];
        const stats = (0, fs_extra_1.statSync)(Editor.Project.path + "/extensions/" + file);
        if (stats.isDirectory() && !isExclude(file) && (0, fs_extra_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/package.json")) {
            // let config = require(Editor.Project.path + "/extensions/" + file + "/package.json");
            let configFile = (0, fs_extra_1.readFileSync)(Editor.Project.path + "/extensions/" + file + "/package.json", "utf-8");
            let config = JSON.parse(configFile);
            pluginsi18n[config.name] = {};
            if ((0, fs_extra_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/i18n/en.js")) {
                let en = require(Editor.Project.path + "/extensions/" + file + "/i18n/" + "en.js");
                let parseJson = {};
                parseI18n(en, parseJson, "i18n:" + config.name);
                pluginsi18n[config.name].en = parseJson;
            }
            if ((0, fs_extra_1.existsSync)(Editor.Project.path + "/extensions/" + file + "/i18n/zh.js")) {
                let zh = require(Editor.Project.path + "/extensions/" + file + "/i18n/" + "zh.js");
                let parseJson = {};
                parseI18n(zh, parseJson, "i18n:" + config.name);
                pluginsi18n[config.name].zh = parseJson;
            }
        }
    }
    return pluginsi18n;
}
function parseI18n(obj, parsedConfig, key) {
    for (const k in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, k)) {
            let preKey = key ? key + "." + k : k;
            if (typeof obj[k] == "string") {
                parsedConfig[preKey] = obj[k];
            }
            else if (typeof obj[k] == "object") {
                parseI18n(obj[k], parsedConfig, preKey);
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zb3VyY2UvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFNQSw0Q0FjQztBQUVELHNDQTJCQztBQWpERCx1Q0FBMkU7QUFDM0UsTUFBTSxPQUFPLEdBQUcsQ0FBQyxlQUFlLEVBQUUsZUFBZSxFQUFFLGFBQWEsQ0FBQyxDQUFDO0FBRWxFLFNBQVMsU0FBUyxDQUFDLElBQVk7SUFDM0IsT0FBTyxPQUFPLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQ2xDLENBQUM7QUFDRCxTQUFnQixnQkFBZ0I7SUFDNUIsTUFBTSxLQUFLLEdBQUcsSUFBQSxzQkFBVyxFQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLGFBQWEsQ0FBQyxDQUFDO0lBQy9ELElBQUksYUFBYSxHQUFRLEVBQUUsQ0FBQztJQUM1QixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDO1FBQ3BDLE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUN0QixNQUFNLEtBQUssR0FBRyxJQUFBLG1CQUFRLEVBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsY0FBYyxHQUFHLElBQUksQ0FBQyxDQUFDO1FBQ3BFLElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRSxJQUFJLElBQUEscUJBQVUsRUFBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxjQUFjLEdBQUcsSUFBSSxHQUFHLGVBQWUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7WUFDdkgsSUFBSSxVQUFVLEdBQUcsSUFBQSx1QkFBWSxFQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLGNBQWMsR0FBRyxJQUFJLEdBQUcsZUFBZSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1lBQ3RHLElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUM7WUFDcEMsNkRBQTZEO1lBQzdELGFBQWEsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsTUFBTSxDQUFDO1FBQ3hDLENBQUM7SUFDTCxDQUFDO0lBQ0QsT0FBTyxhQUFhLENBQUM7QUFDekIsQ0FBQztBQUVELFNBQWdCLGFBQWE7SUFDekIsSUFBSSxXQUFXLEdBQVEsRUFBRSxDQUFDO0lBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUEsc0JBQVcsRUFBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxhQUFhLENBQUMsQ0FBQztJQUMvRCxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDO1FBQ3BDLE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUN0QixNQUFNLEtBQUssR0FBRyxJQUFBLG1CQUFRLEVBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsY0FBYyxHQUFHLElBQUksQ0FBQyxDQUFDO1FBQ3BFLElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLElBQUEscUJBQVUsRUFBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxjQUFjLEdBQUcsSUFBSSxHQUFHLGVBQWUsQ0FBQyxFQUFFLENBQUM7WUFDdkgsdUZBQXVGO1lBQ3ZGLElBQUksVUFBVSxHQUFHLElBQUEsdUJBQVksRUFBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxjQUFjLEdBQUcsSUFBSSxHQUFHLGVBQWUsRUFBRSxPQUFPLENBQUMsQ0FBQztZQUN0RyxJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ3BDLFdBQVcsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQzlCLElBQUksSUFBQSxxQkFBVSxFQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLGNBQWMsR0FBRyxJQUFJLEdBQUcsYUFBYSxDQUFDLEVBQUUsQ0FBQztnQkFDMUUsSUFBSSxFQUFFLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLGNBQWMsR0FBRyxJQUFJLEdBQUcsUUFBUSxHQUFHLE9BQU8sQ0FBQyxDQUFDO2dCQUNuRixJQUFJLFNBQVMsR0FBTyxFQUFFLENBQUM7Z0JBQ3ZCLFNBQVMsQ0FBQyxFQUFFLEVBQUUsU0FBUyxFQUFFLE9BQU8sR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7Z0JBQ2hELFdBQVcsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRSxHQUFHLFNBQVMsQ0FBQztZQUM1QyxDQUFDO1lBRUQsSUFBSSxJQUFBLHFCQUFVLEVBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsY0FBYyxHQUFHLElBQUksR0FBRyxhQUFhLENBQUMsRUFBRSxDQUFDO2dCQUMxRSxJQUFJLEVBQUUsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsY0FBYyxHQUFHLElBQUksR0FBRyxRQUFRLEdBQUcsT0FBTyxDQUFDLENBQUM7Z0JBQ25GLElBQUksU0FBUyxHQUFPLEVBQUUsQ0FBQztnQkFDdkIsU0FBUyxDQUFDLEVBQUUsRUFBRSxTQUFTLEVBQUUsT0FBTyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDaEQsV0FBVyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLEdBQUcsU0FBUyxDQUFDO1lBQzVDLENBQUM7UUFDTCxDQUFDO0lBQ0wsQ0FBQztJQUNELE9BQU8sV0FBVyxDQUFDO0FBQ3ZCLENBQUM7QUFFRCxTQUFTLFNBQVMsQ0FBQyxHQUEwQixFQUFFLFlBQW1DLEVBQUUsR0FBUTtJQUN4RixLQUFLLE1BQU0sQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDO1FBQ2xCLElBQUksTUFBTSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDO1lBQy9DLElBQUksTUFBTSxHQUFHLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLEdBQUcsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNyQyxJQUFJLE9BQU8sR0FBRyxDQUFDLENBQUMsQ0FBQyxJQUFJLFFBQVEsRUFBRSxDQUFDO2dCQUM1QixZQUFZLENBQUMsTUFBTSxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2xDLENBQUM7aUJBQU0sSUFBSSxPQUFPLEdBQUcsQ0FBQyxDQUFDLENBQUMsSUFBSSxRQUFRLEVBQUUsQ0FBQztnQkFDbkMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxZQUFZLEVBQUUsTUFBTSxDQUFDLENBQUM7WUFDNUMsQ0FBQztRQUNMLENBQUM7SUFDTCxDQUFDO0FBQ0wsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGV4aXN0c1N5bmMsIHJlYWRGaWxlU3luYywgcmVhZGRpclN5bmMsIHN0YXRTeW5jIH0gZnJvbSBcImZzLWV4dHJhXCI7XHJcbmNvbnN0IGV4Y2x1ZGUgPSBbXCJwbHVnaW4tYnJpZGdlXCIsIFwicGx1Z2luLWVkaXRvclwiLCBcInBsdWdpbi10ZXN0XCJdO1xyXG5cclxuZnVuY3Rpb24gaXNFeGNsdWRlKG5hbWU6IHN0cmluZykge1xyXG4gICAgcmV0dXJuIGV4Y2x1ZGUuaW5jbHVkZXMobmFtZSk7XHJcbn1cclxuZXhwb3J0IGZ1bmN0aW9uIGdldFBsdWdpbkNvbmZpZ3MoKSB7XHJcbiAgICBjb25zdCBmaWxlcyA9IHJlYWRkaXJTeW5jKEVkaXRvci5Qcm9qZWN0LnBhdGggKyBcIi9leHRlbnNpb25zXCIpO1xyXG4gICAgbGV0IHBsdWdpbkNvbmZpZ3M6IGFueSA9IHt9O1xyXG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCBmaWxlcy5sZW5ndGg7IGkrKykge1xyXG4gICAgICAgIGNvbnN0IGZpbGUgPSBmaWxlc1tpXTtcclxuICAgICAgICBjb25zdCBzdGF0cyA9IHN0YXRTeW5jKEVkaXRvci5Qcm9qZWN0LnBhdGggKyBcIi9leHRlbnNpb25zL1wiICsgZmlsZSk7XHJcbiAgICAgICAgaWYgKHN0YXRzLmlzRGlyZWN0b3J5KCkgJiYgZXhpc3RzU3luYyhFZGl0b3IuUHJvamVjdC5wYXRoICsgXCIvZXh0ZW5zaW9ucy9cIiArIGZpbGUgKyBcIi9wYWNrYWdlLmpzb25cIikgJiYgIWlzRXhjbHVkZShmaWxlKSkge1xyXG4gICAgICAgICAgICBsZXQgY29uZmlnRmlsZSA9IHJlYWRGaWxlU3luYyhFZGl0b3IuUHJvamVjdC5wYXRoICsgXCIvZXh0ZW5zaW9ucy9cIiArIGZpbGUgKyBcIi9wYWNrYWdlLmpzb25cIiwgXCJ1dGYtOFwiKTtcclxuICAgICAgICAgICAgbGV0IGNvbmZpZyA9IEpTT04ucGFyc2UoY29uZmlnRmlsZSk7XHJcbiAgICAgICAgICAgIC8vIGNvbmZpZy5wYXRoID0gRWRpdG9yLlByb2plY3QucGF0aCArIFwiL2V4dGVuc2lvbnMvXCIgKyBmaWxlO1xyXG4gICAgICAgICAgICBwbHVnaW5Db25maWdzW2NvbmZpZy5uYW1lXSA9IGNvbmZpZztcclxuICAgICAgICB9XHJcbiAgICB9XHJcbiAgICByZXR1cm4gcGx1Z2luQ29uZmlncztcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIGdldEkxOG5Db25maWcoKSB7XHJcbiAgICBsZXQgcGx1Z2luc2kxOG46IGFueSA9IHt9O1xyXG4gICAgY29uc3QgZmlsZXMgPSByZWFkZGlyU3luYyhFZGl0b3IuUHJvamVjdC5wYXRoICsgXCIvZXh0ZW5zaW9uc1wiKTtcclxuICAgIGZvciAobGV0IGkgPSAwOyBpIDwgZmlsZXMubGVuZ3RoOyBpKyspIHtcclxuICAgICAgICBjb25zdCBmaWxlID0gZmlsZXNbaV07XHJcbiAgICAgICAgY29uc3Qgc3RhdHMgPSBzdGF0U3luYyhFZGl0b3IuUHJvamVjdC5wYXRoICsgXCIvZXh0ZW5zaW9ucy9cIiArIGZpbGUpO1xyXG4gICAgICAgIGlmIChzdGF0cy5pc0RpcmVjdG9yeSgpICYmICFpc0V4Y2x1ZGUoZmlsZSkgJiYgZXhpc3RzU3luYyhFZGl0b3IuUHJvamVjdC5wYXRoICsgXCIvZXh0ZW5zaW9ucy9cIiArIGZpbGUgKyBcIi9wYWNrYWdlLmpzb25cIikpIHtcclxuICAgICAgICAgICAgLy8gbGV0IGNvbmZpZyA9IHJlcXVpcmUoRWRpdG9yLlByb2plY3QucGF0aCArIFwiL2V4dGVuc2lvbnMvXCIgKyBmaWxlICsgXCIvcGFja2FnZS5qc29uXCIpO1xyXG4gICAgICAgICAgICBsZXQgY29uZmlnRmlsZSA9IHJlYWRGaWxlU3luYyhFZGl0b3IuUHJvamVjdC5wYXRoICsgXCIvZXh0ZW5zaW9ucy9cIiArIGZpbGUgKyBcIi9wYWNrYWdlLmpzb25cIiwgXCJ1dGYtOFwiKTtcclxuICAgICAgICAgICAgbGV0IGNvbmZpZyA9IEpTT04ucGFyc2UoY29uZmlnRmlsZSk7XHJcbiAgICAgICAgICAgIHBsdWdpbnNpMThuW2NvbmZpZy5uYW1lXSA9IHt9O1xyXG4gICAgICAgICAgICBpZiAoZXhpc3RzU3luYyhFZGl0b3IuUHJvamVjdC5wYXRoICsgXCIvZXh0ZW5zaW9ucy9cIiArIGZpbGUgKyBcIi9pMThuL2VuLmpzXCIpKSB7XHJcbiAgICAgICAgICAgICAgICBsZXQgZW4gPSByZXF1aXJlKEVkaXRvci5Qcm9qZWN0LnBhdGggKyBcIi9leHRlbnNpb25zL1wiICsgZmlsZSArIFwiL2kxOG4vXCIgKyBcImVuLmpzXCIpO1xyXG4gICAgICAgICAgICAgICAgbGV0IHBhcnNlSnNvbjphbnkgPSB7fTtcclxuICAgICAgICAgICAgICAgIHBhcnNlSTE4bihlbiwgcGFyc2VKc29uLCBcImkxOG46XCIgKyBjb25maWcubmFtZSk7XHJcbiAgICAgICAgICAgICAgICBwbHVnaW5zaTE4bltjb25maWcubmFtZV0uZW4gPSBwYXJzZUpzb247XHJcbiAgICAgICAgICAgIH1cclxuXHJcbiAgICAgICAgICAgIGlmIChleGlzdHNTeW5jKEVkaXRvci5Qcm9qZWN0LnBhdGggKyBcIi9leHRlbnNpb25zL1wiICsgZmlsZSArIFwiL2kxOG4vemguanNcIikpIHtcclxuICAgICAgICAgICAgICAgIGxldCB6aCA9IHJlcXVpcmUoRWRpdG9yLlByb2plY3QucGF0aCArIFwiL2V4dGVuc2lvbnMvXCIgKyBmaWxlICsgXCIvaTE4bi9cIiArIFwiemguanNcIik7XHJcbiAgICAgICAgICAgICAgICBsZXQgcGFyc2VKc29uOmFueSA9IHt9O1xyXG4gICAgICAgICAgICAgICAgcGFyc2VJMThuKHpoLCBwYXJzZUpzb24sIFwiaTE4bjpcIiArIGNvbmZpZy5uYW1lKTtcclxuICAgICAgICAgICAgICAgIHBsdWdpbnNpMThuW2NvbmZpZy5uYW1lXS56aCA9IHBhcnNlSnNvbjtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgIH1cclxuICAgIH1cclxuICAgIHJldHVybiBwbHVnaW5zaTE4bjtcclxufVxyXG5cclxuZnVuY3Rpb24gcGFyc2VJMThuKG9iajogeyBbeDogc3RyaW5nXTogYW55OyB9LCBwYXJzZWRDb25maWc6IHsgW3g6IHN0cmluZ106IGFueTsgfSwga2V5OiBhbnkpIHtcclxuICAgIGZvciAoY29uc3QgayBpbiBvYmopIHtcclxuICAgICAgICBpZiAoT2JqZWN0LnByb3RvdHlwZS5oYXNPd25Qcm9wZXJ0eS5jYWxsKG9iaiwgaykpIHtcclxuICAgICAgICAgICAgbGV0IHByZUtleSA9IGtleSA/IGtleSArIFwiLlwiICsgayA6IGs7XHJcbiAgICAgICAgICAgIGlmICh0eXBlb2Ygb2JqW2tdID09IFwic3RyaW5nXCIpIHtcclxuICAgICAgICAgICAgICAgIHBhcnNlZENvbmZpZ1twcmVLZXldID0gb2JqW2tdO1xyXG4gICAgICAgICAgICB9IGVsc2UgaWYgKHR5cGVvZiBvYmpba10gPT0gXCJvYmplY3RcIikge1xyXG4gICAgICAgICAgICAgICAgcGFyc2VJMThuKG9ialtrXSwgcGFyc2VkQ29uZmlnLCBwcmVLZXkpO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG59Il19