import { readFileSync } from 'fs-extra';
import { join } from 'path';
import { createApp, App } from 'vue';
import { getI18nConfig, getPluginConfigs } from '../../utils';
const panelDataMap = new WeakMap<any, App>();
/**
 * @zh 如果希望兼容 3.3 之前的版本可以使用下方的代码
 * @en You can add the code below if you want compatibility with versions prior to 3.3
 */
// Editor.Panel.define = Editor.Panel.define || function(options: any) { return options }
module.exports = Editor.Panel.define({
    listeners: {
        show() { console.log('show'); },
        hide() { console.log('hide'); },
    },
    template: readFileSync(join(__dirname, '../../../static/template/default/index.html'), 'utf-8'),
    style: readFileSync(join(__dirname, '../../../static/style/default/index.css'), 'utf-8'),
    $: {
        app: '#app',
        text: '#text',
    },
    methods: {
        hello() {
            if (this.$.text) {
                this.$.text.innerHTML = 'hello';
                console.log('[cocos-panel-html.default]: hello');
            }
        },
    },
    ready() {
        if (this.$.text) {
            this.$.text.innerHTML = 'Hello Cocos.';
        }
        if (this.$.app) {
            const app = createApp({});
            app.config.compilerOptions.isCustomElement = (tag) => tag.startsWith('ui-');
            app.component('MyCounter', {
                template: readFileSync(join(__dirname, '../../../static/template/vue/counter.html'), 'utf-8'),
                data() {
                    let pluginConfigs: any = getPluginConfigs();
                    let i18nConfig = getI18nConfig();
                    return {
                        pluginConfigs: pluginConfigs,
                        currentPluginConfig: pluginConfigs[Object.keys(pluginConfigs)[0]],
                        currentPluginName: pluginConfigs[Object.keys(pluginConfigs)[0]].name,
                        i18nConfig: i18nConfig,
                        currentI18nConfig: i18nConfig[pluginConfigs[Object.keys(pluginConfigs)[0]].name][Editor.I18n.getLanguage()],
                    };
                }, methods: {
                    getI18nFromConfig(key: string) {
                        return this.currentI18nConfig[key] || "无翻译：" + key;
                    },
                    onPluginSelect(pluginName: string) {
                        this.currentPluginName = pluginName;
                        this.currentPluginConfig = this.pluginConfigs[pluginName];
                        this.currentI18nConfig = this.i18nConfig[pluginName][Editor.I18n.getLanguage()];
                        // console.log(this.currentPluginName, this.currentPluginConfig, this.currentI18nConfig);
                    },
                },
            });
            app.mount(this.$.app);
            panelDataMap.set(this, app);
        }
    },
    beforeClose() { },
    close() {
        const app = panelDataMap.get(this);
        if (app) {
            app.unmount();
        }
    },
});
