System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, Component, Node, RigidBody2D, PolygonCollider2D, CircleCollider2D, HingeJoint2D, Vec2, PhysicsSystem2D, ERigidBody2DType, _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2, _crd, ccclass, property, ScrewBoardDemo;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      RigidBody2D = _cc.RigidBody2D;
      PolygonCollider2D = _cc.PolygonCollider2D;
      CircleCollider2D = _cc.CircleCollider2D;
      HingeJoint2D = _cc.HingeJoint2D;
      Vec2 = _cc.Vec2;
      PhysicsSystem2D = _cc.PhysicsSystem2D;
      ERigidBody2DType = _cc.ERigidBody2DType;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "106fdg8SlJBjJ3efP+27M9+", "test", undefined);

      __checkObsolete__(['_decorator', 'Component', 'Node', 'RigidBody2D', 'PolygonCollider2D', 'CircleCollider2D', 'HingeJoint2D', 'Vec2', 'PhysicsSystem2D', 'ERigidBody2DType']);

      ({
        ccclass,
        property
      } = _decorator);

      _export("ScrewBoardDemo", ScrewBoardDemo = (_dec = ccclass('ScrewBoardDemo'), _dec2 = property(Node), _dec3 = property(Node), _dec(_class = (_class2 = class ScrewBoardDemo extends Component {
        constructor() {
          super(...arguments);

          _initializerDefineProperty(this, "boardNode", _descriptor, this);

          _initializerDefineProperty(this, "screwNode", _descriptor2, this);
        }

        start() {
          // 启用物理系统
          PhysicsSystem2D.instance.enable = true; // 设置物理组件

          this.setupPhysicsComponents(); // 启用物理调试（仅开发阶段）

          this.enablePhysicsDebug();
        }

        setupPhysicsComponents() {
          // 设置螺丝（静态刚体）
          var screwRB = this.screwNode.addComponent(RigidBody2D);
          screwRB.type = ERigidBody2DType.Static; // 设置板子（动态刚体）

          var boardRB = this.boardNode.addComponent(RigidBody2D);
          boardRB.type = ERigidBody2DType.Dynamic;
          boardRB.angularDamping = 0; // 旋转阻尼
          // 设置板子碰撞器

          var boardCollider = this.boardNode.addComponent(PolygonCollider2D);
          boardCollider.points = [new Vec2(-180, -180), new Vec2(180, -180), new Vec2(180, 180), new Vec2(-180, 180)]; // 设置螺丝碰撞器

          var screwCollider = this.screwNode.addComponent(CircleCollider2D);
          screwCollider.radius = 5; // 设置旋转关节

          this.setupHingeJoint();
        }

        setupHingeJoint() {
          var hingeJoint = this.boardNode.addComponent(HingeJoint2D);
          hingeJoint.connectedBody = this.screwNode.getComponent(RigidBody2D); // 计算螺丝在板子本地坐标系中的位置

          var boardWorldPos = this.boardNode.worldPosition;
          var screwWorldPos = this.screwNode.worldPosition; // 设置锚点（螺丝相对于板子中心的位置）

          hingeJoint.anchor = new Vec2(screwWorldPos.x - boardWorldPos.x, screwWorldPos.y - boardWorldPos.y); // 连接锚点（螺丝自身的中心点）

          hingeJoint.connectedAnchor = new Vec2(0, 0); // 可选：限制旋转角度（示例：-90° 到 +90°）

          hingeJoint.enableLimit = false;
          hingeJoint.lowerAngle = -Math.PI / 2;
          hingeJoint.upperAngle = Math.PI / 2; // 禁用连接刚体之间的碰撞

          hingeJoint.collideConnected = false;
        }

        enablePhysicsDebug() {//    PhysicsSystem2D.instance.debugDrawFlags = 
          //        physics2d.DrawFlags.e_jointBit | 
          //        physics2d.DrawFlags.e_shapeBit;
        }

      }, (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "boardNode", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "screwNode", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=618981eef3bd5d0d2dd584bd53df5a0493fde0f1.js.map