import { _decorator, Node, Component, Material, Camera, SpriteFrame, Sprite, view, UITransform, game } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('EffectBlurMask')
export class EffectBlurMask extends Component {
    @property(Material)
    material!:Material;

    @property(Camera)
    rendCamera!:Camera;

    @property(Sprite)
    effectSprite!: Sprite;

    _time = 0;
    _spriteFrame = new SpriteFrame();
    size:any = null;

    onLoad () {
        game.setFrameRate(60)
        this.size = view.getVisibleSize()
        this._snapshot()
    }

    start () {
        
    }

    _snapshot () {
        let rt = this.rendCamera.targetTexture;
        if (rt) {
            rt.reset(view.getVisibleSize());
            this._spriteFrame.texture = rt;
        }

        this.effectSprite.node.getComponent(UITransform)!.contentSize = view.getVisibleSize();
        this.effectSprite.spriteFrame = this._spriteFrame;
        this.effectSprite.customMaterial = this.material
        this.effectSprite.node.setScale(1, -1, 1)
    }

    update (dt: any) {
    }
}
