import { _decorator, Component, Node, Layers, UITransform, size, Label, tween, Vec3 } from 'cc';
import { MaskEx } from '../../scripts/MaskEx';
const { ccclass, property } = _decorator;

@ccclass('ClipNodeTest')
export class ClipNodeTest extends Component {
    private _clipNode: Node;

    onLoad() {
        this.createClipingNode();
        this.createLabel();
    }

    createClipingNode() {
        this._clipNode = new Node("ClipingNode");
        this._clipNode.layer = Layers.Enum.UI_2D;
        let maskCom = this._clipNode.addComponent(MaskEx);
        maskCom.type = MaskEx.Type.GRAPHICS_RECT;
        this.node.addChild(this._clipNode);

        let stencilLayer = new Node("StencilLayer");
        stencilLayer.layer = Layers.Enum.UI_2D;
        stencilLayer.addComponent(UITransform).setContentSize(size(300, 300));
        this._clipNode.addChild(stencilLayer);  //注意：必须先addChild() 再setStencil()
        maskCom.setStencil(stencilLayer);
    }

    createLabel() {
        let node = new Node("Hello");
        node.layer = Layers.Enum.UI_2D;
        node.addComponent(UITransform);
        let lab = node.addComponent(Label);
        lab.fontSize = 40;
        lab.string = "HelloWorld";
        this._clipNode.addChild(node);
        tween(node)
            .repeatForever(
                tween()
                    .to(1, { position: new Vec3(200, 0) })
                    .to(2, { position: new Vec3(-200, 0) })
                    .to(1, { position: new Vec3(0, 0) })
                    .to(1, { position: new Vec3(0, 200) })
                    .to(2, { position: new Vec3(0, -200) })
                    .to(1, { position: new Vec3(0, 0) })
            )
            .start();
    }
}

