import { _decorator, Component, Node, Layers } from 'cc';
import { MaskEx } from '../../scripts/MaskEx';
const { ccclass, property } = _decorator;

const GuideStep = {
    1:{
        nodeName:"BtnGuide1",
        nextGuideId:2,
    },
    2:{
        nodeName:"BtnGuide2",
        nextGuideId:3,
    },
    3:{
        nodeName:"BtnGuide3",
    },
}

@ccclass('GuideLayer')
export class GuideLayer extends Component {
    @property(Node)
    m_btnStart:Node = null;

    @property(Node)
    m_stepNode:Node = null;

    private _maskCom:MaskEx = null;
    private _curStep:number = 0;

    private _clipNode:Node = null;

    onLoad(){
        this._maskCom = this.node.getComponent(MaskEx);
    }

    nextStep(){
        this._curStep++;
        if( !GuideStep[this._curStep] ){
            this.guideOver();
            return;    
        }

        let btnStep = this.m_stepNode.getChildByName(GuideStep[this._curStep].nodeName);
        if( btnStep ){
            this._maskCom.setStencil(btnStep);
        }
    }

    guideOver(){
        this.m_btnStart.active = true;
        this.m_stepNode.active = false;
        this.node.active = false;
    }

    onClickStart(){
        this._curStep = 0;
        this.m_btnStart.active = false;
        this.m_stepNode.active = true;
        this.node.active = true;
        this.nextStep();
    }

    onClickBtn(){
        this.nextStep();
    }
}

