
import { _decorator, Component, Node,systemEvent,SystemEvent } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = TestController
 * DateTime = Mon Dec 06 2021 17:20:10 GMT+0800 (中国标准时间)
 * Author = riyueming184
 * FileBasename = TestController.ts
 * FileBasenameNoExtension = TestController
 * URL = db://assets/scripts/TestController.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('TestController')
export class TestController extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    private mouseDownCount:number = 0;
    private mouseUpCount:number = 0;

    onLoad(){
        systemEvent.on(SystemEvent.EventType.MOUSE_DOWN,this.onMouseDown,this);
        systemEvent.on(SystemEvent.EventType.MOUSE_UP,this.onMouseUp,this);
    }


    start () {
        // [3]
    }

    onMouseUp(){
        this.mouseUpCount++;
        console.log('mouseUpCount ' + this.mouseUpCount);
    }

    onMouseDown(){
        this.mouseDownCount++;
        console.log('mouseDownCount ' + this.mouseDownCount);
    }

    onDestroy(){
        systemEvent.off(SystemEvent.EventType.MOUSE_DOWN,this.onMouseDown,this);
        systemEvent.off(SystemEvent.EventType.MOUSE_UP,this.onMouseUp,this);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
