import { _decorator, Component, Node, sp } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('SpineTest')
export class SpineTest extends Component {
    private _spine: sp.Skeleton;
    protected onLoad(): void {
        this._spine = this.getComponent(sp.Skeleton)!
    }
    start() {
        this._spine.setCompleteListener(() => {
            console.log("setCompleteListener called")
        })
        this._spine.setEventListener(() => {
            console.log("setEventListener called")
        })
        let tr = this._spine.setAnimation(0, "animation", false)
        this._spine.setTrackCompleteListener(tr, () => {
            console.log("setTrackCompleteListener called")

        })
        this._spine.setTrackEventListener(tr, () => {
            console.log("setTrackEventListener called")
        })
    }

    update(deltaTime: number) {

    }
}

