import { _decorator, assetManager, Component, instantiate, Node, Prefab, random, resources } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
    @property(Node)
    public father: Node;
    @property(Node)
    public click: Node;
    
    protected onEnable(): void {
        assetManager.loadBundle("dome", (err, bundle) => {
            this.click.active = true;
        });
    }

    /**测试函数 */
    public async getResToUrl(url: string): Promise<Node> {
        let node = null;
        let s = this;
        return new Promise((resolve, reject) => {
            try {
                const index = url.indexOf('/');
                let bundleName: string = url.slice(0, index);
                let path: string = url.slice(index + 1);

                const loadEnd = function (err, asset) {
                    if (err) {
                        reject();
                        return;
                    }
                    node = instantiate(asset);
                    resolve(node);
                }
                if (bundleName == "resources") {
                    resources.load(path, Prefab, loadEnd)
                } else {
                    assetManager.loadBundle(bundleName, (err, bundle) => {
                        if (err) {
                            reject();
                            return;
                        }
                        bundle.load(path, Prefab, loadEnd)
                    });
                }

            } catch (error) {
                reject();
                return;
            }
        })
    }



    public async onClick() {
        let s = this;
        let node = await s.getResToUrl("dome/filePre");

        if (node) {
            s.father.addChild(node);
            let x = Math.random() * 600 - 320;;
            let y = Math.random() * 1000 - 600;
            node.setPosition(x, y);
        }
    }



}


