const fs = require("fs");
const sharp = require("sharp");//npm install sharp
//console.log(process.argv);

doo("D:/wamp/www/qimiaosenlin/PixelHit/demo/assets/碰撞信息s.json", [
  "D:/wamp/www/qimiaosenlin/PixelHit/demo/assets/Texture/test/",
  "D:/wamp/www/qimiaosenlin/PixelHit/demo/assets/Texture/HelloWorld.png"
]);

function stat(path) {
  try {
    return fs.statSync(path);
  } catch (e) {
    console.error(e);
  }
}
function isFile(path) {
  return stat(path)?.isFile();
}
function isDirectory(path) {
  return stat(path)?.isDirectory();
}
async function doo(jsonPath, paths) {
  const 碰撞信息s = {};
  for (const path of paths) {
    if (isDirectory(path)) {
      for (const filePath of fs.readdirSync(path, { recursive: true })) {
        if (filePath.endsWith(".png")) {
          await 像素级碰撞区域(碰撞信息s, path + filePath);
        }
      }
    } else if (isFile(path)) {
      await 像素级碰撞区域(碰撞信息s, path);
    }
  }
  fs.writeFileSync(jsonPath, JSON.stringify(碰撞信息s).replace(/\],/g, "],\n"));
}
async function 像素级碰撞区域(碰撞信息s, pngPath) {
  console.log("解析：" + pngPath);
  const metaPath = pngPath + ".meta";
  if (isFile(metaPath)) { } else {
    console.error("无 " + metaPath);
    return;
  }
  let meta;
  try {
    meta = JSON.parse(fs.readFileSync(metaPath, "utf8"));
  } catch (e) {
    console.error(e);
    meta = null;
  }
  if (meta) { } else {
    console.error("解析 meta 失败！");
    return;
  }
  if (meta.subMetas) { } else {
    console.error("不是 Sprite！");
    return;
  }
  let uuid = null;
  for (const key in meta.subMetas) {
    uuid = meta.subMetas[key].uuid;
    break;
  }
  if (uuid) { } else {
    console.error("获取 uuid 失败！");
    return;
  }
  const resolution = 4;//分辨率，越小越精确（同时信息文件越大）
  const img = await sharp(pngPath);
  const metadata = await img.metadata();
  const width = Math.ceil(metadata.width / resolution);
  const height = Math.ceil(metadata.height / resolution);
  await img.resize(width, height);
  img.ensureAlpha();
  img.toColourspace("srgb");
  const rgbas = await img.raw().toBuffer();
  img.destroy();
  const 碰撞信息 = [];
  let i = Math.ceil(width * height / 32);
  while (i--) {
    碰撞信息[i] = 0;
  }
  let shift = 0;
  let index = 0;
  i = 0;
  for (let y = 0; y < height; y++) {
    for (let x = 0; x < width; x++) {
      if (rgbas[i + 3] > 100) {//透明度 0~255，这里大于 100 算能碰到
        碰撞信息[index] |= 1 << shift;
      }
      i += 4;
      if (++shift < 32) { } else {
        shift = 0;
        index++;
      }
    }
  }
  碰撞信息s[uuid] = 碰撞信息;
}