import { _decorator, Component, geometry, log, math, Node, PhysicsSystem, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CamControl')
export class CamControl extends Component {

    @property(Node)
    public targetnode: Node = null;
    public followDist: number = 15;
    private _tmpV3: Vec3 = math.v3();
    public spped: number = 2;
    start() {
        this.node.setWorldPosition(this.targetnode.worldPosition.x, this.targetnode.worldPosition.y + 3, this.targetnode.worldPosition.z + 15);
    }

    protected onLoad(): void {

    }

    update(deltaTime: number) {
        const dist = this.node.worldPosition.z - this.targetnode.worldPosition.z;
        if (dist > this.followDist) {
            Vec3.add(this._tmpV3, this.targetnode.worldPosition, math.v3(0, 3, 15));
            Vec3.slerp(this._tmpV3, this.node.worldPosition, this._tmpV3, deltaTime);
            this.node.setWorldPosition(this._tmpV3);
        }
        this.node.lookAt(this.targetnode.worldPosition);
        this.rayTest();
    }

    public rayTest() {
        let dir=Vec3.subtract(this._tmpV3,this.targetnode.worldPosition,this.node.worldPosition);
        dir=dir.normalize();
        let ray = new geometry.Ray(this.node.worldPosition.x,this.node.worldPosition.y,this.node.worldPosition.z,dir.x,dir.y,dir.z);
        // 以下参数可选
        const mask = 0xffffffff;
        const maxDistance = 10000000;
        const queryTrigger = true;

        if (PhysicsSystem.instance.raycastClosest(ray, mask, maxDistance, queryTrigger)) {
            const raycastClosestResult = PhysicsSystem.instance.raycastClosestResult;
            const hitPoint = raycastClosestResult.hitPoint
            const hitNormal = raycastClosestResult.hitNormal;
            const collider = raycastClosestResult.collider;
            const distance = raycastClosestResult.distance;
            log(collider);
        }
    }
}


