import { _decorator, CapsuleCharacterController, Component, EventKeyboard, Input, input, KeyCode, math, Node, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('PlayerControl')
export class PlayerControl extends Component {
    private _selfControl:CapsuleCharacterController=null;
    private _speed:Vec3=math.v3(0,-10,0);
    start() {
        input.on(Input.EventType.KEY_DOWN,(evt:EventKeyboard)=>{
            if(evt.keyCode==KeyCode.KEY_W){
                this._speed.z=-5;
            }else if(evt.keyCode==KeyCode.KEY_S){
                this._speed.z=5;
            }else if(evt.keyCode==KeyCode.KEY_A){
                this._speed.x=-5;
            }else if(evt.keyCode==KeyCode.KEY_D){
                this._speed.x=5;
            }
        },this);
        input.on(Input.EventType.KEY_UP,(evt:EventKeyboard)=>{
            this._speed.set(0,-10,0);
        },this);
    }

    protected onLoad(): void {
        this._selfControl=this.node.getComponent(CapsuleCharacterController);
    }

    update(deltaTime: number) {
        this._selfControl.move(this._speed.clone().multiplyScalar(deltaTime));
    }
}


