System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, Component, geometry, log, math, Node, PhysicsSystem, Vec3, _dec, _dec2, _class, _class2, _descriptor, _crd, ccclass, property, CamControl;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      geometry = _cc.geometry;
      log = _cc.log;
      math = _cc.math;
      Node = _cc.Node;
      PhysicsSystem = _cc.PhysicsSystem;
      Vec3 = _cc.Vec3;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "9e2e4KJ7fdMbolyur7EQ/9F", "CamControl", undefined);

      __checkObsolete__(['_decorator', 'Component', 'geometry', 'log', 'math', 'Node', 'PhysicsSystem', 'Vec3']);

      ({
        ccclass,
        property
      } = _decorator);

      _export("CamControl", CamControl = (_dec = ccclass('CamControl'), _dec2 = property(Node), _dec(_class = (_class2 = class CamControl extends Component {
        constructor(...args) {
          super(...args);

          _initializerDefineProperty(this, "targetnode", _descriptor, this);

          this.followDist = 15;
          this._tmpV3 = math.v3();
          this.spped = 2;
        }

        start() {
          this.node.setWorldPosition(this.targetnode.worldPosition.x, this.targetnode.worldPosition.y + 3, this.targetnode.worldPosition.z + 15);
        }

        onLoad() {}

        update(deltaTime) {
          const dist = this.node.worldPosition.z - this.targetnode.worldPosition.z;

          if (dist > this.followDist) {
            Vec3.add(this._tmpV3, this.targetnode.worldPosition, math.v3(0, 3, 15));
            Vec3.slerp(this._tmpV3, this.node.worldPosition, this._tmpV3, deltaTime);
            this.node.setWorldPosition(this._tmpV3);
          }

          this.node.lookAt(this.targetnode.worldPosition);
          this.rayTest();
        }

        rayTest() {
          let dir = Vec3.subtract(this._tmpV3, this.targetnode.worldPosition, this.node.worldPosition);
          dir = dir.normalize();
          let ray = new geometry.Ray(this.node.worldPosition.x, this.node.worldPosition.y, this.node.worldPosition.z, dir.x, dir.y, dir.z); // 以下参数可选

          const mask = 0xffffffff;
          const maxDistance = 10000000;
          const queryTrigger = true;

          if (PhysicsSystem.instance.raycastClosest(ray, mask, maxDistance, queryTrigger)) {
            const raycastClosestResult = PhysicsSystem.instance.raycastClosestResult;
            const hitPoint = raycastClosestResult.hitPoint;
            const hitNormal = raycastClosestResult.hitNormal;
            const collider = raycastClosestResult.collider;
            const distance = raycastClosestResult.distance;
            log(collider);
          }
        }

      }, (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "targetnode", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return null;
        }
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=4bd805a48700786339e296438196371999d9caba.js.map