

import { _decorator,Component, Node,EPhysics2DDrawFlags,input,BoxCollider2D,Vec2,Input,KeyCode, Vec3,Contact2DType, PhysicsSystem2D, TiledMap, math} from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = NewComponent
 * DateTime = Mon Mar 14 2022 00:39:52 GMT+0800 (中国标准时间)
 * Author = A_B_C
 * FileBasename = NewComponent.ts
 * FileBasenameNoExtension = NewComponent
 * URL = db://assets/NewComponent.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */
 
@ccclass('NewComponent')
export class NewComponent extends Component {

    @property({type:Node})
        private n1:Node|null=null;  //节点当前挂载的地图
    @property({type:Node})
        private n2:Node|null=null;  //节点当前挂载的地图
    @property({type:Node})
        private map:Node|null=null;  //节点当前挂载的地图
        v:Vec3=new Vec3(0,0,0);
    
    start () {

        var fog=this.map.getComponent(TiledMap).getLayer('layer');


        for(var i=0;i<fog.getLayerSize().width;i++) {
            for(var j=0;j<fog.getLayerSize().height;j++) {
                var gid=fog.getTileGIDAt(i,j);
                if(gid!=0){
                    var tile=fog.getTiledTileAt(i,j,true);
                    tile.node.layer=1;
                    tile.node.addComponent(BoxCollider2D)
                    tile.node.getComponent(BoxCollider2D).group=1;
                   tile.node.getComponent(BoxCollider2D).offset=new Vec2(0,0);
                   tile.node.getComponent(BoxCollider2D).size=math.size(60,60);
                }
            }
        }

        input.on(Input.EventType.KEY_DOWN,this.onKerdown,this);
        input.on(Input.EventType.KEY_UP,this.onKerup,this);


        PhysicsSystem2D.instance.enable = true;

       /* let collider = this.getComponent(Collider2D);
        if (collider) {
            collider.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
            collider.on(Contact2DType.END_CONTACT, this.onEndContact, this);
            collider.on(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
            collider.on(Contact2DType.POST_SOLVE, this.onPostSolve, this);
        }*/


        if (PhysicsSystem2D.instance) {
            PhysicsSystem2D.instance.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
            //PhysicsSystem2D.instance.on(Contact2DType.END_CONTACT, this.onEndContact, this);
        }

        PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Aabb
         |
            EPhysics2DDrawFlags.Pair |
            EPhysics2DDrawFlags.CenterOfMass |
            EPhysics2DDrawFlags.Joint |
            EPhysics2DDrawFlags.Shape;

    }

    onBeginContact(selfCollider, otherCollider, contact){
        console.log(selfCollider.group,otherCollider.group,contact);
    }

    onEndContact (selfCollider, otherCollider, contact) {
        console.log(selfCollider.group,otherCollider.group,contact);
    }

    onKerdown(e){

        this.n2.getPosition(this.v)

        if(e.keyCode == KeyCode.KEY_W || e.keyCode ==KeyCode.ARROW_UP){
            this.v.y+=5;
            this.n2.setPosition(this.v)

        }else if(e.keyCode==KeyCode.KEY_S || e.keyCode==KeyCode.ARROW_DOWN){
            this.v.y-=5;
            this.n2.setPosition(this.v)
        }

        if(e.keyCode==KeyCode.KEY_A ||e.keyCode==KeyCode.ARROW_LEFT){
            this.v.x-=5;
            this.n2.setPosition(this.v)

        }else if(e.keyCode==KeyCode.KEY_D || e.keyCode==KeyCode.ARROW_RIGHT){
            this.v.x+=5;
            this.n2.setPosition(this.v)
        }

    }

    onKerup(e){
        
    }

   
}


