import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('DragStuff')
export class DragStuff extends Component {

  private _isTouched = false;

  start() {
    console.log()
    this.node.on('touch-start', this._touchStart, this);
    this.node.on('touch-end', this._touchEnd, this);
    this.node.on('touch-move', this._touchMove, this);
  }

  _touchStart() {
    this._isTouched = true;
  }
  _touchEnd() {
    this._isTouched = false;
  }
  _touchMove(e) {
    if (this._isTouched) {
      const position = this.node.getPosition();
      this.node.setPosition(position.x + e.getDeltaX(), position.y + e.getDeltaY());
    }
  }

  update(deltaTime: number) {
      
  }
}

