/** 
 * dUb 游戏框架 
 * http://dUb.cool
*/
const {ccclass, property} = cc._decorator;
@ccclass
export  class dUb extends cc.Component {
    /** 是否初始化 */
    static initstar :boolean = false;
    /** 当前场景所有属性 */
    static MAN : any;
    /** 资源版本号 */
    static ver : string = "0.06";
    /** 通信的网址 */
    static  http : string =  "https://chongchongzhengba.oss-accelerate.aliyuncs.com/";
    /**游戏通信网关 */
    static websocket : string = "ws://192.168.1.13:8889/dUb.cool"; 
    /** cdn 资源前缀 */
    static cdn : string = dUb.http +"images/";
    /** 获取版本号 */
    static banben : number = parseInt( cc.ENGINE_VERSION);
    /** 全局计时 */
    static timejs : number = 0;
    /** 缓存图片资源 */
    static YUANCHENG : any = {}; 
    /** 缓存图集分割参数 */
    static YUANLINE : any = {};
    /** 事件注册 */
    static SHIJIAN : any = {};
    /** 资源列表 */
    static ZIYUAN : any = {};
    /** 字体 */
    static ZITI : any = {};
    /** 模块 */
    static MODClass : any = {};
    /** 漂浮 预制体 */
    static PAONODE : any = null;
    /** 加载预制体 */
    static LOAING : any = null;
    /** 加载数据 */
    static JIAZAINUM : number = 0;
    /** 加载图片锁 */
    static ZISUO : any = {};
    /** websocket链接 */
    static NET : any = {
        ws:null,//通信链接
        jishi: 0, //计数
        yeschushi:false,// 是否初始化
        timeout:8000, //80秒没连接推出
        restart:500,// 2秒重练一次
        run:0.01, //执行间隔
        wsdata:[],//队列数据
        isliank:false//是否连接
    };
    static pack : any = require('msgpack-lite');
    public static $ = cc.find;
    public static p = cc.log;

    /** 音效 音乐系统 */
    static YingLiang : number = 0.5;
    static YingXiao : number = 1;
    static audioSource: any = [];/*音乐资源*/
    static nanaudio: any = [];/*男生音效*/
    static nvaudio: any =[];/*女生音效*/

    public static SYLoad(lxm,i,zhis){
        
        dUb.load( zhis,  function (err, clip) {
            if(err){
                return ;
            }
            if(lxm == 1){
               dUb.nanaudio[i] =clip;
            }else if(lxm == 2){
                dUb.audioSource[i] =clip;
            }else{
                dUb.nvaudio[i] =clip;
            }
        });
    }

    public static SYconfig(data){
        if(data.audioSource){
            for(var i = 0; i < data.audioSource.length ; i++){
                if(data.audioSource[i] != ""){
                    this.SYLoad(2,i,data.audioSource[i]);   
                } 
            }
        }
        if(data.nanaudio){

            for(var i = 0; i < data.nanaudio.length ; i++){
                if(data.nanaudio[i] != ""){
                    this.SYLoad(1,i,data.nanaudio[i]);
                }
            }
        }
        if(data.nvaudio){

            for(var i = 0; i < data.nvaudio.length ; i++){
                if(data.nvaudio[i] != ""){
                    this.SYLoad(0,i,data.nvaudio[i]);
                }
            }
        }

    }
    public static  SYYY(id){
        /*音乐播放 id*/
        if( typeof( this.audioSource[id] ) == "undefined" ){
            setTimeout(function(){
                dUb.SYYY(id);
            },1500);
            return  ;
        }
        cc.audioEngine.playMusic(this.audioSource[id], true);
    }
    public static SYYX(id,sex){
        /*音效播放*/
        if(this.YingXiao <= 0){
           return   ;
        }
        if(sex == '0'){
            if (!this.nvaudio||   typeof( this.nvaudio[id] ) == "undefined" ) return;
            cc.audioEngine.playEffect(this.nvaudio[id], false);
        }else{
            if (!this.nanaudio||  typeof( this.nanaudio[id] ) == "undefined" ) return;
            cc.audioEngine.playEffect(this.nanaudio[id], false);
        }
    }
    public static SYYXU(lujin){
        /*播放音效文件*/
        if(lujin){
            dUb.load(lujin ,  function (err, clip) {
                if(!err){
                    cc.audioEngine.playEffect(clip, false);
                }
            });
        }
    }
    public static SYYYU( lujin ){
        /*播放音乐文件*/
        if(lujin){
            dUb.load(lujin, function (err, clip) {
                if(!err){
                    cc.audioEngine.playMusic(clip, true);
                }
            });
        }
    }
    public static stopAll(){
        /*所有音效停止*/
        cc.audioEngine.stopAll();
    }
    public static pauseAll(){
        /*所有音效暂停*/
        cc.audioEngine.pauseAll();
    }
    public static resumeAll(){
        /*所有音效重放*/
        cc.audioEngine.resumeAll();
    }
    public static SYSYX(num){
        /*音效音量*/
        num = parseFloat(num);
        if(num > 1){
            num = 1;
        }else if(num <=0){
             num = 0.0;
        }
        this.YingXiao = num;
        cc.audioEngine.setEffectsVolume(num);
        cc.sys.localStorage.setItem('yingxiao',num);
    }
    public static SYSYY(num){
        /*音月音量*/
        num = parseFloat(num);
        if(num > 1){
            num = 1;
        }else if(num <=0){
             num = 0.0;
        }
        this.YingLiang = num;
        cc.audioEngine.setMusicVolume(num);
        cc.sys.localStorage.setItem('yingyue',num);
    }
    public static SYGET(){
        /*读取音量*/
        return [this.YingLiang,this.YingXiao]; 
    }


    public static init(){
        
        if(this.initstar ){
            return ;
        }

        console.log("dUb.cool 插件开启");
        this.initstar = true;
        //cc.debug.setDisplayStats(false);
        cc.macro.CLEANUP_IMAGE_CACHE = false;
        cc.dynamicAtlasManager.enabled = true;
        cc.dynamicAtlasManager.maxFrameSize = 2048;
       

        var YingLiang = 1;
        var YingXiao = 1;
        YingLiang = parseFloat( cc.sys.localStorage.getItem('yingyue'));
        YingXiao  =  parseFloat(  cc.sys.localStorage.getItem('yingxiao'));
        if(cc.sys.localStorage.getItem('yingxiao') == null || cc.sys.localStorage.getItem('yingxiao') =="" ){
            YingXiao = 1;
        }
        if(cc.sys.localStorage.getItem('yingyue') == null|| cc.sys.localStorage.getItem('yingyue') == ""){
            YingLiang = 1;
        }
        this.YingLiang = YingLiang;
        this.YingXiao = YingXiao;
        cc.audioEngine.setMusicVolume(this.YingLiang);
        cc.audioEngine.setEffectsVolume(this.YingXiao);
        //加载浮动
        cc.resources.load("piaofu", function (err, prefab) {
            if(!err){
                dUb.PAONODE = prefab;
            }
        });
        //加载loading
        cc.resources.load("loading", function (err, prefab) {
            if(!err){
                dUb.LOAING = prefab;
            }
        });
        //加载字体
        cc.resources.loadDir("ttf", function (err, assets) {
            for(var m in assets){
                if(assets[m] instanceof cc.TTFFont || assets[m] instanceof cc.BitmapFont ){
                    dUb.ZITI[assets[m].name] = assets[m];
                }
            }
        });

        dUb.ON("token",'连接ok发送',function(){
            dUb.NET.send( {E:"fire",L:dUb.MAN.gameini });
        });
        dUb.NET.link = function(){
            dUb.NET.jishi = 0;
            if( dUb.websocket.indexOf("wws://") >-1)  
            {   
                dUb.NET.ws = new WebSocket(dUb.websocket,[]);
            }else{
                dUb.NET.ws = new WebSocket(dUb.websocket);
            }
            dUb.NET.ws.binaryType = "arraybuffer";
            dUb.NET.ws.onopen = dUb.NET.onopen;
            dUb.NET.ws.onmessage = dUb.NET.onmessage; 
            dUb.NET.ws.onclose = dUb.NET.onclose;
        }
        dUb.NET.onopen = function()
        {
            dUb.NET.isliank = true;
            dUb.NET.jishi = 0;
            dUb.NET.send( {ELi:""+cc.sys.localStorage.getItem('ELi') })
        };

        dUb.NET.onmessage =function (evt) 
        {  
            if(evt.data.byteLength == 0){
                return dUb.NET.jishi = 0;
            }
            var DATA =  dUb.pack.decode(new Uint8Array(evt.data));
            if(!DATA){
                return ;
            }
            if( dUb.PAN(DATA['ELi']) ){ //链接成功了
                dUb.NET.yeschushi = true;
                cc.sys.localStorage.setItem('ELi',DATA['ELi']);
                return dUb.FIRE("token","");
            }else if( DATA['E']  == "qiews"){
                dUb.NET.close();
                dUb.websocket = DATA['L'];
                dUb.NET.link();
                return ;
            }
            dUb.NET.wsdata.push(DATA);
        };
        
        dUb.NET.onclose = function()
        {    
            if(dUb.MAN&& dUb.PAN(dUb.MAN.guanbi)){
                dUb.MAN.guanbi();
            }
            dUb.NET.isliank = false;
            dUb.NET.jishi = 0;
            dUb.NET.wsdata = Array();
            dUb.NET.yeschushi = false;
        };
        dUb.NET.send  = function (wenzi){
            if(!dUb.NET.isliank || dUb.NET.ws.readyState != 1){
                return ;
            }
            //.buffer
            dUb.NET.ws.send( dUb.pack.encode(wenzi) );
        }

        dUb.NET.duilie = function(){
            dUb.NET.jishi ++;
            if(dUb.MAN && dUb.MAN.jishiqi){
                dUb.timejs++;
                if(dUb.timejs > 10000000){
                    dUb.timejs = 0;
                }
                dUb.MAN.jishiqi();
            }
            if(dUb.NET.jishi > dUb.NET.timeout && dUb.NET.isliank ){
                dUb.NET.ws.close();
                return  ;
            }
            if(dUb.NET.yeschushi && dUb.NET.wsdata){
                if(dUb.NET.wsdata[0]){
                    dUb.FIRE(dUb.NET.wsdata[0]['E'],dUb.NET.wsdata[0]['L']);
                    dUb.NET.wsdata.shift();
                    if(dUb.NET.wsdata.length > 1000){
                        dUb.NET.wsdata = Array();
                    }
                }
            }
            if(!dUb.NET.isliank  && dUb.NET.jishi > dUb.NET.restart ){
                dUb.NET.jishi = 0;
                dUb.NET.link();
            }
        }

        dUb.ON("MSG",'消息提示',function(wenzi){
            if(wenzi==""){
                return ;
            }
            if(!cc.find("Canvas/msgbox")){
                var xxx = new cc.Node("msgbox");
                xxx.parent = cc.find("Canvas");
            }
            if(cc.find("Canvas/msgbox").childrenCount > 50){
                return ;
            }
            if(typeof(wenzi) == "string"){
                wenzi = {
                    text :wenzi,
                    x:0,y:60,time:0.1
                }
            }
            if(dUb.PAONODE){
                var nodes = cc.instantiate( dUb.PAONODE );
                dUb.wenzi(cc.find("wenzi",nodes),wenzi.text);
                nodes.active = true;
                nodes.parent = cc.find("Canvas/msgbox");
                cc.tween(nodes)
                .by(wenzi.time, { position: cc.v2(wenzi['x'], wenzi['y'])})
                .by(wenzi.time, { position: cc.v2(wenzi['x'], -wenzi['y'])})
                .delay(1)
                .to(0.2, { opacity: 0})
                .call((node_) => { 
                    if(node_){
                        node_.destroy();
                    }
                }).start();
            }
        });

    }

    /** 查询所有路径节点 */
    public static NODEx(lujing){
        if(typeof(lujing) == "undefined"){
            return ;
        }
        dUb.p( lujing );
        var xiabu = dUb.$(lujing).children;
        if(xiabu){
            for(var x in xiabu){
                var xiaji = lujing+'/'+xiabu[x].name;
                dUb.NODEx(xiaji);
            }
        }
    }
    /** 返回角度位置和角度 8访问调用 */
    public static jiaoman(jiaodu :number = 0){
        var fangwei = 1;
        if(jiaodu > 68 && jiaodu <= 113){
            fangwei= 1;
            jiaodu = 90; 
        }else if(jiaodu > 113 && jiaodu <= 158){
            fangwei= 8;
            jiaodu = 135;
        }else if(jiaodu > 158 && jiaodu <= 203){
            fangwei = 7;
            jiaodu = 180;
        }else if(jiaodu > 203 && jiaodu <= 248){
            fangwei = 6;
            jiaodu = 225;
        }else if(jiaodu > 248 && jiaodu <= 293){
            fangwei = 5;
            jiaodu = 270;
        }else if(jiaodu >= -90 && jiaodu <= -78){
            fangwei  = 5;
            jiaodu = -90;
        }else if(jiaodu > -78 && jiaodu <= -23){
            fangwei = 4;
            jiaodu = -45;
        }else if(jiaodu > -23 && jiaodu <= 23){
            fangwei = 3;
            jiaodu = 0;
        }else if(jiaodu > 23 && jiaodu <= 68){
            fangwei = 2;
            jiaodu = 45;
        }
        return [fangwei,jiaodu];
    }
    /** 快捷访问子节点 */
    public static  $K(list:any[],name: string){
        for(var i in list){
            var node = list[i];
            if(node._name == name){
                return node;
            }
        }
        return null;
    }
    /** 判断变量存在不存在 */
    public static  PAN ( canshu :any ){
        if(typeof(canshu) == "undefined"){
            return false;
        }
        if(!canshu && canshu !== "" && canshu !== 0){
            return false;
        }
        return true;
    }

    /** 拷贝对象 */
    public static  copy(data:any[]){
        var temp = {};
        for(var m in data){
            temp[m] = data[m];
        }
        return temp;
    }
    /** get 数组转string*/
    public static get (data:any[]) {
        var str = "?";
        for (var k in data) {
            if (str != "?") {
                str += "&";
            }
            str += k + "=" + data[k];
        }
        str = str.replace(/(^\?*)/g, '');
        return str;
    }
    /** 获取url 参数*/
    public static GET(){
        var url = cc.sys.localStorage.getItem('HREF');
        if(!url || url == ""){
            return {}
        }
        var u = url.split("?");
        if(typeof(u[1]) == "string"){
            u = u[1].split("&");
            var get = {};
            for(var i in u){
                var j = u[i].split("=");
                if(j[0] != "")
                    get[j[0]] = j[1];
            }
            cc.sys.localStorage.removeItem('HREF');
            return get;
        } else {
            cc.sys.localStorage.removeItem('HREF');
            return {};
        }
    };
    /** http请求 */
    public static HTTP(Url:string,data:any,handler:Function){
        if(dUb.http){
            Url = dUb.http + Url;
        }
        var xhr = cc.loader.getXMLHttpRequest();
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if(handler){
                    handler(xhr.responseText,xhr.status);
                }
            }
        }
        xhr.timeout = 10000;
        if(data.ac == "GET"){
            if(data.ac){
                delete data.ac;
            }
            xhr.open("GET", Url+encodeURI(dUb.get(data)) , true);
            if (cc.sys.isNative) {
                xhr.setRequestHeader("Accept-Encoding","gzip,deflate");
                xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
                xhr.setRequestHeader("User-Agent","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36");
            }
            xhr.send();
        }else{
            if(data.ac){
                delete data.ac;
            }
            xhr.open("POST", Url );
            if (cc.sys.isNative) {
                xhr.setRequestHeader("Accept-Encoding","gzip,deflate");
                xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
                xhr.setRequestHeader("User-Agent","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36");
            }
            xhr.send(dUb.get(data));
        }
    }

    /* 资源解析网址 */
    public static  loadurl(url:string ):string{  
        if(url == ""){
            return "";
        }
        var info = cc.resources.getInfoWithPath(cc.path.mainFileName(url));
        if(info){
            return url;
        }
        return dUb.cdn+url+'?ver='+dUb.ver;//远程
    }
    /** 取整数 */
    public static  INT (zhi){
        var num = parseInt( ""+(parseInt(""+parseInt( ""+zhi  )* 1000) /1000) );
        if(isNaN  (num)){
            num = 0;
        }
        return num ;
    }
    /** 获取高度 */
    public static HIH (){
        return dUb.INT(cc.view.getVisibleSize().height );   
    }
    /** 获取宽度 */
    public static WIH (){
        return dUb.INT(cc.view.getVisibleSize().width );   
    }
    /** 颜色 */
    public static yanse(yanse){
        return new cc.Color().fromHEX(yanse);
    }
    /** 节点排序 */
    public static paixu(node,index){
        if(!node){
            return ;
        }
        node.zIndex = dUb.INT(index);
    }
    /* 毫秒*/
    public static haomiao () {
        return new Date().getTime();
    }
    /* uuid */
    public static UUID () {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
            var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);

            return v.toString(16);
        });
    }
    /** 注册事件 事件名字 调用函数名字 调用函数*/
    public static  ON (name:string,zhis:string,functiond:any){
        if(!dUb.SHIJIAN[name]){
            dUb.SHIJIAN[name] = {};
        }
        if(functiond){
            dUb.SHIJIAN[name][zhis] = functiond.bind(dUb.MAN);
        }else{
            dUb.SHIJIAN[name][zhis] = functiond;
        }
    }
    /** 关闭事件 事件名字*/
    public static  OFF (name:string){
        if( dUb.SHIJIAN[name] ){
            delete dUb.SHIJIAN[name];
        }
    }
    /** 发送事件  事件名字 事件参数 */
    public static  FIRE (name:string,zhis:any){
        if( dUb.SHIJIAN[name] ){
            for(var m in dUb.SHIJIAN[name]){
                if(dUb.SHIJIAN[name][m]){
                    dUb.SHIJIAN[name][m](zhis,name);
                }else{
                    dUb.p('错误：'+m+' '+zhis);
                }
            }
        }
    }
    /** 清理事件 */
    public static OFFCLER (name:string){
        if(!dUb.PAN(name) ){
            name = dUb.MAN.jiao;
        }
        for(var zname in dUb.SHIJIAN){
            var yqing = zname.split('.');
            if(yqing.length > 1){
                if(name ==  yqing['0']){
                    delete dUb.SHIJIAN[name];
                }
            }
        }
    }
    /** 随机整数之间 */
    public static sj (begin:number,end:number){
        var num = Math.round(Math.random()*(end-begin)+begin);
        return num;
    }
    /**2点的距离*/
    public static zhixian (x:number,y:number,x1:number,y2:number){
        var dx = x - x1; 
        var dy = y - y2; 
        var dx = Math.sqrt(dx*dx+dy*dy); 
        if(dx < 0){
            dx =-dx;
        }
        return dx;
    }

    /** 时间*/
    public static time(){
        return Date.parse(""+new Date())/1000;
    }
    /** 获取夹角*/
    public static getAngle (px:number,py:number,mx:number,my:number){
        px = px *1;
        py = py *1;
        mx = mx *1;
        my = my *1;
        if(px == mx && py == my){
            return 0;
        }
        var x = Math.abs(px-mx);
        var y = Math.abs(py-my);
        var z = Math.sqrt(Math.pow(x,2)+Math.pow(y,2));
        if(z == 0){
            z = 0.001;
        }
        var cos = y/z;
        var radina = Math.acos(cos);//用反三角函数求弧度
        if(radina == 0){
            radina = 0.001;
        }
        var angle = Math.floor(180/(Math.PI/radina));//将弧度转换成角度
        if(mx>px&&my>py){//鼠标在第四象限
            angle = 180 - angle;
        }
        if(mx==px&&my>py){//鼠标在y轴负方向上
            angle = 180;
        }
        if(mx>px&&my==py){//鼠标在x轴正方向上
            angle = 90;
        }
        if(mx<px&&my>py){//鼠标在第三象限
            angle = 180+angle;
        }
        if(mx<px&&my==py){//鼠标在x轴负方向
            angle = 270;
        }
        if(mx<px&&my<py){//鼠标在第二象限
            angle = 360 - angle;
        }
        return angle;
    };

     /** get字符转[] */
     public static  unget (wenzi){
        var u = wenzi.split("&");
        var get = {};
        for(var i in u){
            var j = u[i].split("=");
            if(j[0] != "")
                get[j[0]] = j[1];
        }
        return get;
    }
    /** 文字 */
    public static wenzi(node, value ) {
        if(!node){
            return ;
        }
        if(!node.getComponent(cc.Label)){
            return "";
        }
        if (!dUb.PAN(value)) {
            return node.getComponent(cc.Label).string;
        } else {
            node.getComponent(cc.Label).string = value;
        }
    }
    /** 输入框*/
    public static  input (node, value) {
        if(!node){
            return ;
        }
        if(!node.getComponent(cc.EditBox)){
            return "";
        }
        if (!dUb.PAN(value)) {
            return node.getComponent(cc.EditBox).string;
        } else {
            node.getComponent(cc.EditBox).string = value;
        }
    }
    /** 设置图片 */
    public static tupian (node, resoures) {
        if(!node){
            return ;
        }
        if(!node.getComponent(cc.Sprite)){
            return null;
        }
        if (!dUb.PAN(resoures)) {
            if(resoures === null){
                node.getComponent(cc.Sprite).spriteFrame =  null;
            }else {
                return node.getComponent(cc.Sprite).spriteFrame;
            }

        } else {
            node.getComponent(cc.Sprite).spriteFrame = resoures;  
        }
    }
    /**  左删除字符*/
    public static LTrim (str:string,zifu) {
        if(!str || str ==""){
            return str;
        }
        for(var i=0; i<str.length; i++) {
            if(str.charAt(i)!=zifu) break;
        } 
        return str.slice(i, str.length);
    };
    /** 右删除字符*/
    public static RTrim (str:string,zifu) {
        if(!str || str == ""){
            return str;
        }
        for(var i=str.length-1; i>=0; i--) {
            if(str.charAt(i)!=zifu) break;
        }
        return str.slice(0, i+1);
    };
    /** 删除字符两边 */
    public static Trim (str:string,zifu) {
        if(!zifu){
          zifu = ",";
        }
        return dUb.LTrim(dUb.RTrim(str,zifu),zifu);
    };
    /** 加载图集*/
    public static loadtuji(body:string,fanhui:any){

        if(dUb.ZISUO[body]){
            return ;
        }
        dUb.ZISUO[body] = true;
        if(!dUb.YUANLINE[body]){
           
            /* 开始加载图片 */
            dUb.load(body+"/config.json", function (err, texx) {
                let body = this.toString();
                if( err ){
                    texx = {'load':{},'frames':{},'sprites':{},'direction':8,zoom:2}
                }
                if(texx instanceof cc.JsonAsset){
                    if(!texx.json.direction){
                        texx.json.direction = 8;
                    }
                    if(!texx.json.zoom){
                        texx.json.zoom = 2;
                    }
                    dUb.YUANLINE[body] = texx.json;
                    dUb.ZIYUAN["config/"+body] = {
                        url:(body+"/config.json") ,
                        atime:dUb.time()
                    };
                }else{
                    dUb.YUANLINE[body] = texx;
                    dUb.ZIYUAN["config/"+body] = {
                        url:dUb.loadurl(body+"/config.json") ,
                        atime:dUb.time()
                    };
                }
                delete(dUb.ZISUO[body]);
                dUb.loadtuji(body,fanhui);


            }.bind(body));
            return ;

        }else{

            if( dUb.PAN(dUb.ZIYUAN[body]) ){
                fanhui();
                return ;
            }
            var loadimg = dUb.YUANLINE[body]['load'];
            if(loadimg){
                var  jishi = 0;
                var  jishi2 = 0;      

                dUb.ZIYUAN[body] = {atime:dUb.time(),url:{},donghua:true};
                let linshi = {};
                for(var m  in loadimg ){
                    jishi++;
                    if(m == "graphics"){
                        dUb.ZIYUAN[body].donghua = false;
                    }
                    var  tupians = loadimg[m];
                    
                    if( !dUb.YUANCHENG[body]){
                        dUb.load( body+"/"+tupians, function (err, texx) {
                            let Body = this.toString();
                            if( err ){
                                texx = " "
                            }else{
                                if(!dUb.ZIYUAN[body] || !dUb.ZIYUAN[body].url){
                                    dUb.ZIYUAN[body] = {atime:dUb.time(),url:{},donghua:true};
                                }
                                dUb.ZIYUAN[body].url[body+"/"+Body]=texx.nativeUrl;
                            }
                            jishi2++;
                            linshi[Body]=(texx);
                            if(jishi2 >= jishi){
                                if(fanhui){
                                    var width =0;
                                    var height= 0;
                                    let baohan = {};
                                    var huo =  dUb.YUANLINE[body].sprites;
                                    for(var hh in huo){
                                        let tu = hh.split("_");
                                        let biao = tu[0]+'.png';
                                        if(!baohan[biao]){
                                            baohan[biao] =[];
                                        }
                                        for(var hh_ in huo[hh]){
                                            baohan[biao].push(huo[hh][hh_]);
                                        }
                                        

                                    }

                                    for(var xx in linshi){
                                        let shuzi = linshi[xx];
                                        if(baohan[xx]){
                                            for(var xxx_ in baohan[xx]){
                                                let keyxxx = baohan[xx][xxx_];
                                                dUb.YUANLINE[body].frames[keyxxx][1]+=height;

                                            }

                                        }
                                        height+=shuzi.height;
                                        if(shuzi.width > width){
                                            width =shuzi.width;
                                        }
                                    }
                                    let RenderTexture = new cc.RenderTexture;
                                    RenderTexture.initWithSize(width,height);
                                    
                                    var width =0;
                                    var height= 0;
                                    for(var xx in linshi){
                                        var shuzi = linshi[xx];
                                        RenderTexture["drawTextureAt"](shuzi,0,height);
                                        height += shuzi.height;
                                    }
                                    dUb.YUANCHENG[body]  =RenderTexture;
                                    delete(dUb.ZISUO[body]);
                                    fanhui();
                                }
                            } 

                        }.bind(tupians ));

                    }else{
                        jishi2++;
                    }
                }

                if(jishi2 >= jishi){
                    if(fanhui){
                        delete(dUb.ZISUO[body]);
                        fanhui();
                    }
                }   
            }
        }
    }
    /** 远程直接贴图资源 */
    public static tietu(node,url){
        dUb.load( url, function (err, tex) {
            if(!err){
                var spriteFrame = new cc.SpriteFrame(tex, new cc.Rect(0, 0, tex.width, tex.height));
                dUb.tupian(node,spriteFrame);
            }
        });
    }
    /** 图集加载 */
    public static  tuji (node:any,body:string ="",$bianhao:string = "",tiaoxy:boolean = false){
        if(!dUb.YUANLINE[body] ){
            dUb.loadtuji( body,function(){
                dUb.tuji(this[0],this[1],this[2],this[3]);
            }.bind([node,body,$bianhao,tiaoxy]));
        }else{
            var images = dUb.YUANLINE[body];
            var sprites = images['frames'];
            var whxy = sprites[$bianhao];
            if(whxy){
                var tex = dUb.YUANCHENG[body];
                var SpriteFrame = new cc.SpriteFrame(
                    tex, 
                    new cc.Rect(whxy[0], whxy[1], whxy[2], whxy[3] ),
                    false,
                    cc.v2(whxy[0], whxy[1]),
                    cc.size(whxy[2], whxy[3] ) 
                );
                dUb.tupian(node,SpriteFrame);
                if(tiaoxy == true){
                    node.x = whxy[0];
                    node.y = whxy[1];
                }
                node.width = whxy[2];
                node.height = whxy[3];
            }   
        }
    }
    /** 传奇序列动画 */
    public static  donghua (node,weizhide){
        if(!node){
            return ;
        }
        if(!node.dub_buchax){
            node.dub_buchax = 20;
        }
        if(!node.dub_buchay){
            node.dub_buchay = 20;
        }
        if(!weizhide){
            weizhide = "body";
        }
        if( ! dUb.PAN(node["dub_js"+weizhide]) ){
            node["dub_js"+weizhide] = 0;
        }
        
        if(!cc.find(weizhide,node)  ){
            return ;
        }
        if(!dUb.PAN(node["dub_fangwei"]) ){
            node["dub_fangwei"] = "5";
        }
        if(!dUb.PAN(node["dub_dongzuo"])){
            node["dub_dongzuo"] = "standing";
        }
        var body = node["dub_"+weizhide];
       
        if(!body || body == "" ){
            if(!node.dub_UI){
                return ;
            }
            body = node.dub_UI;
        }
        if(dUb.ZIYUAN[body]){
            dUb.ZIYUAN[body].atime = dUb.time();
        }
        
        if(node["dub_dh"+weizhide] === false){
            return ;
        }
        if(!dUb.PAN(node["dub_dh"+weizhide])){
            node["dub_dh"+weizhide] = true;
        }
        
        if(!node.donghua ){

            if(node["dub_js"+weizhide]> 0){
                return ;
            }
        }
        
        if(!dUb.YUANLINE[body] ){
            dUb.loadtuji( body,function(){
                dUb.donghua(this[0],this[1]);
            }.bind([node,weizhide]));
            return ;
        }

        if (node["dub_dongzuo"+weizhide]){
            var dongzuo = node["dub_dongzuo"+weizhide];
        }else{
            var dongzuo = node.dub_dongzuo;
        }

        if (node["dub_dongzuo"+weizhide]){
            var dongzuo = node["dub_dongzuo"+weizhide];
        }else{
            var dongzuo = node.dub_dongzuo;
        }
        
        if( weizhide == 'buff'){
            if(dUb.PAN(node.dub_buffcx )){
                dongzuo = node.dub_buffcx;
            }else{
                dongzuo = "landing";
            }
        }
    
        var fangwei = node.dub_fangwei;
        var images = dUb.YUANLINE[body];
        var frames = images['frames'];
        var sprites = images['sprites'];
        var donghu = sprites[dongzuo+'_'+fangwei];
        var  donglen = donghu.length;
        node.setScale(images.zoom);
        if(images.direction == 1){

            if(fangwei < 5){
                fangwei = 1;
                node.setScale(cc.v2(images.zoom, images.zoom)); 
            }else{
                node.setScale(cc.v2(-images.zoom, images.zoom)); 
                fangwei = 1;
            }

        }else if(images.direction == 2){

            if(fangwei < 5){
                fangwei = 1;
            }else{
                fangwei = 2;
            }
            
        }else if(images.direction == 3){
            
        }else if(images.direction == 4){
            
        }else if(images.direction == 5){
            
        }

        //direction
       // console.log(images.zoom);


        if(node.dub_type == "skill"){
            if(dUb.PAN(node.dub_feixing)){
                var x_x = dUb.INT(node.x);
                var x_y = dUb.INT(node.y);
                var xx_x = dUb.INT(node.dub_endx);
                var xx_y = dUb.INT(node.dub_endy);
                if(x_x == xx_x && x_y == xx_y){
                
                    if(node["dub_list"+weizhide] && node["dub_list"+weizhide].length > 1){
                        node["dub_js"+weizhide] = 9999;
                        node.dub_feixing = false;
                        node["dub_list"+weizhide].shift();
                     
                    }else{
                        //这里结束了
                        if(dUb.PAN(node.skillcall)){
                            dUb.MAN.skillcall(node.skillcall);
                        }
                        node.destroy();
                        return ;
                    }
                }
            }                                                                       
            
            
             
                       
            if(dongzuo == "landing"){
                if(!dUb.PAN(node.dub_feilanding)){     
                    node.dub_feilanding = true;    
                    node.x = node.dub_endx;
                    node.y = node.dub_endy;
                }
            }
        }
        
        if(node["dub_js"+weizhide] >= donglen){


            if(!node.dub_enddonghu){
                node.dub_enddonghu = 'death';
            }
            if(node.dub_type == "skill"){
                if(node["dub_list"+weizhide] && node["dub_list"+weizhide].length == 0){
                    if(dUb.PAN(node.skillcall)){
                        dUb.MAN.skillcall(node.skillcall);
                    }
                    node.destroy();
                    return ;
    
                }else if(node["dub_list"+weizhide] && node["dub_list"+weizhide].length == 1){
                    var tadedongzuo =  node["dub_list"+weizhide][0];
    
                    
                    if( tadedongzuo  == dongzuo){
                        if(dUb.PAN(node.skillcall)){
                            dUb.MAN.skillcall(node.skillcall);
                        }
                        node.destroy();
                        return ;
                    }
    
                }
            }
            node["dub_js"+weizhide] = 0;
            if(node["dub_list"+weizhide] && node["dub_list"+weizhide].length > 0){
                
                var tadedongzuo =  node["dub_list"+weizhide][0];
                if( tadedongzuo == "" || !dUb.PAN(tadedongzuo) ){
                    dUb.tupian(TTNODE,null);
                }
               
                if( tadedongzuo  == dongzuo && tadedongzuo != "flight"){
                    node["dub_list"+weizhide].shift();
                    var tadedongzuo =  node["dub_list"+weizhide][0];
                    if (node["dub_dongzuo"+weizhide]){
                        node["dub_dongzuo"+weizhide]=tadedongzuo;
                    }else{
                        node.dub_dongzuo=tadedongzuo;
                    }
                    if(tadedongzuo == "flight"){
                        if(! dUb.PAN(node.dub_feixing) ){
                            node.dub_feixing = true;
                            var zhixina =  dUb.zhixian(node.x,node.y,node.dub_endx,node.dub_endy);
                            cc.tween(node).to(zhixina/1000, { position: cc.v2(node.dub_endx,node.dub_endy) }).start();
                           
                        }
                    }
                    return  ;
                }
                if(!dUb.YUANCHENG[body]){
                    dUb.tupian(TTNODE,null);
                }
                
                if (node["dub_dongzuo"+weizhide]){
                    node["dub_dongzuo"+weizhide]=tadedongzuo;
                }else{
                    node.dub_dongzuo=tadedongzuo;
                }
    
                if(tadedongzuo == "flight"){
                    if(! dUb.PAN(node.dub_feixing) ){
                        node.dub_feixing = true;
                        var zhixina =  dUb.zhixian(node.x,node.y,node.dub_endx,node.dub_endy);
                        cc.tween(node).to(zhixina/1000, { position: cc.v2(node.dub_endx,node.dub_endy) }).start();
                    }
                }
                
                if( tadedongzuo != 'flight'){
                    node["dub_list"+weizhide].shift();
                }
    
                return dUb.donghua(node,weizhide);
            }else if( dongzuo == 'standing' || dongzuo == 'walking' || dongzuo == 'cast'|| dongzuo == 'landing'|| dongzuo == 'flight' || dongzuo.indexOf("YDH")>-1){
                ;
            }else if(dongzuo == node.dub_enddonghu ){
                node["dub_dh"+weizhide] = false;
            }else{
                node.dub_dongzuo= "standing";
            }
        }
        
        if(dUb.YUANCHENG[body]){
           
   

            var TTNODE = dUb.$K(node.children,weizhide);

            if(node["dub_dh"+weizhide]){
                var whxy = frames[donghu[node["dub_js"+weizhide]]];
                if(whxy){
                    var tex = dUb.YUANCHENG[body];
                    //let RenderTexture = new cc.RenderTexture;
                    var SpriteFrame = new cc.SpriteFrame(
                        tex, 
                        new cc.Rect(whxy[0], whxy[1], whxy[2], whxy[3] ),
                        false,
                        cc.v2(whxy[0], whxy[1]),
                        cc.size(whxy[2], whxy[3] ) 
                    );
                    dUb.tupian(TTNODE,SpriteFrame);
                    TTNODE.x = ((whxy[4]?whxy[4]*1:0)+whxy[2]/2)-node.dub_buchax;
                    TTNODE.y= -((whxy[5]?whxy[5]*1:0)+whxy[3]/2)+node.dub_buchay;
                    TTNODE.width= whxy[2];
                    TTNODE.height=whxy[3];
                }
            }
            
        }
        node["dub_js"+weizhide]++;
        
      
         
    }

    /** 按钮事件 */
    public static  anniu (NODE, WENJIAN, HANSHU, ZHI) {
        if (NODE instanceof Array) {
            for (var ms = 0; ms < NODE.length; ms++) {
                if (!NODE[ms]) {
                    continue;
                }
            
                if( typeof(HANSHU) != "string" ){
                    if (ZHI) {
                        var valuex = null;
                        if (ZHI instanceof Array) {
                            if (ZHI[ms]) {
                                valuex = ZHI[ms];
                            }
                        } else {
                            valuex = ZHI;
                        }
                        //NODE[ms].off(cc.Node.EventType.TOUCH_START,HANSHU.bind(valuex) , this);
                        NODE[ms].targetOff(this);
                        NODE[ms].on(cc.Node.EventType.TOUCH_START ,HANSHU.bind(valuex) , this);
                    }else{
                        NODE[ms].targetOff(this);
                        //NODE[ms].off(cc.Node.EventType.TOUCH_START,HANSHU, this);
                        NODE[ms].on(cc.Node.EventType.TOUCH_START ,HANSHU , this);
                    }
                    continue ;
                }
                var clickEventHandler = new cc.Component.EventHandler();
                clickEventHandler.target = dUb.$("Canvas");
                clickEventHandler.component = WENJIAN;
                clickEventHandler.handler = HANSHU;
                if (ZHI) {
                    if (ZHI instanceof Array) {
                        if (ZHI[ms]) {
                            clickEventHandler.customEventData = ZHI[ms];
                        }
                    } else {
                        clickEventHandler.customEventData = ZHI;
                    }
                }
                if (NODE[ms].getComponent(cc.Button)) {
                    NODE[ms].getComponent(cc.Button).clickEvents[0] = (clickEventHandler);
                }
                if (cc.Toggle && NODE[ms].getComponent(cc.Toggle)) {
                    NODE[ms].getComponent(cc.Toggle).clickEvents[0] = (clickEventHandler);
                }
            }

        } else {

            if (!NODE) {
                return;
            }
            if( typeof(HANSHU) != "string" ){
                NODE.targetOff(this);
                //NODE.off(cc.Node.EventType.TOUCH_START,HANSHU.bind(ZHI) , this);
                NODE.on( cc.Node.EventType.TOUCH_START,HANSHU.bind(ZHI) , this);
                return ;
            }

            var clickEventHandler = new cc.Component.EventHandler();
            clickEventHandler.target = dUb.$("Canvas");
            clickEventHandler.component = WENJIAN;
            clickEventHandler.handler = HANSHU;
            if (ZHI) {
                clickEventHandler.customEventData = ZHI;
            }
            if (NODE.getComponent(cc.Button)) {
                NODE.getComponent(cc.Button).clickEvents[0] = (clickEventHandler);
            }
            if (cc.Toggle && NODE.getComponent(cc.Toggle)) {
                NODE.getComponent(cc.Toggle).clickEvents[0] = (clickEventHandler);
            }
        }
    };
    /** 读取mode 数据 */
    public static MOD(name:string){
        if(!dUb.PAN(dUb.MODClass[name])){
            var  fan  = require(name);
            if(fan){
                dUb.MODClass[name]  = fan;
                dUb.MODClass[name].init();
                return dUb.MODClass[name];
            }
            return {};
        }
        return dUb.MODClass[name];
    }

    /** string转二进制 */
    public static stringToUint8Array = function(str){
        var arr = [];
        for (var i = 0, j = str.length; i < j; ++i) {
          arr.push(str.charCodeAt(i));
        }
        var tmpUint8Array = new Uint8Array(arr);
        return tmpUint8Array
    }

    /** 二进制转string */
    public static Uint8ArrayToString = function(fileData){
        var dataString = "";
        for (var i = 0; i < fileData.length; i++) {
          dataString += String.fromCharCode(fileData[i]);
        }
        return dataString
    }
     
    /** 删除存档 */
    public static deldata = function(id:string,name:string){
        var name = 'dUb_'+id+'_'+name;
        return cc.sys.localStorage.removeItem(name);
    }

    /** 获取存档 */
    public static getdata = function(id:string,name:string,moren:any = null){
        var name = 'dUb_'+id+'_'+name;
        var fan = cc.sys.localStorage.getItem(name);
        if(!fan || fan == null ){
            if(dUb.PAN(moren)){
                return moren;
            }
            return {};
        }
        return dUb.pack.decode(fan);
    }

    /** 设置存档 */
    public static setdata = function(id:string,name:string,DATA:any){
        var fan = dUb.getdata(id,name);
        if(typeof(DATA) == 'object'){
            for(var i in DATA){
                fan[i] = DATA[i];
            }
        }else{
            fan = DATA;
        }
        return  cc.sys.localStorage.setItem( name , dUb.pack.encode( fan ));
    }

    /**定时回收资源 */
    public static huishou (leixin:boolean = false){
        for(var xx in dUb.ZIYUAN){ 
            if(xx.indexOf("config")>-1){
                cc.assetManager.releaseAsset(dUb.ZIYUAN[xx].url);
                delete(dUb.ZIYUAN[xx]);
            }else if(dUb.ZIYUAN[xx].donghua&&leixin){
                var xiangcha = dUb.time() - dUb.ZIYUAN[xx].atime;
                if(xiangcha >=30){
                    var uuul = dUb.ZIYUAN[xx].url;
                    if(uuul){
                        delete(dUb.YUANLINE[xx]);
                        delete(dUb.ZIYUAN[xx]);
                        for(var ziname in uuul){
                            cc.assetManager.releaseAsset(uuul[ziname]);
                            delete(dUb.YUANCHENG[ziname]);
                        }  
                    }
                }

            }else if(!leixin){

                var uuul = dUb.ZIYUAN[xx].url;
                if(uuul){
                    delete(dUb.YUANLINE[xx]);
                    delete(dUb.ZIYUAN[xx]);
                    for(var ziname in uuul){
                        cc.assetManager.releaseAsset(uuul[ziname]);
                        delete(dUb.YUANCHENG[ziname]);
                    }  
                }

            } 
        }
        if(!leixin){
            dUb.ZISUO = {};  
        }
    }

    /* 加载资源 */
    public static load(url:string,fanhuide){
        if( dUb.loadurl(url).indexOf("://") <  0 ){
            var types = url.split('.');
            var jiurl = url;
            if(types.length > 1){   
                jiurl = jiurl.replace(new RegExp(cc.path.extname(url),"g"),"");
            }
            cc.resources.load(jiurl,fanhuide);
        }else{
            if(dUb.JIAZAINUM < 1000){
                dUb.JIAZAINUM++;
            }
            dUb.MAN.scheduleOnce(function(x1,x23){
                cc.assetManager.loadRemote( dUb.loadurl(x1) ,x23);
                if(dUb.JIAZAINUM > 0){
                    dUb.JIAZAINUM--;
                }
            }.bind(this,url,fanhuide),0.015*dUb.JIAZAINUM);
        }
    }
    
    /** loading加载界面 */
    public static  loading(off:boolean,wenzi:string){
        if(!dUb.PAN(wenzi)){
            wenzi = "";
        }
        var nodes = cc.find("Canvas/loading");
        if(!nodes){
            if(dUb.LOAING){
                nodes = cc.instantiate( dUb.LOAING );
                nodes.parent = cc.find("Canvas");
            }else{
                dUb.MAN.scheduleOnce(function(){
                    dUb.loading (off,wenzi);
                },1);
                return ;
            }
        }
        dUb.wenzi( dUb.$K( nodes.children,'miaoshu') , wenzi);
        if(nodes){
            nodes.active = off;
        }
    }
    /** 跳转场景*/
    public static  changjing (Scene:string){
        
        dUb.loading(true,"场景加载中");
        cc.director.preloadScene(Scene, function (err) {

            dUb.loading(false,"");
            if(err){
                dUb.p(err);
                return ;
            }
            cc.director.loadScene(Scene);
        });
    }

    start () {

    }

    update ( dt ) {

    }
}
if(! dUb.initstar){
    dUb.init();
}

