import { _decorator, Component, Node, SceneAsset, director, resources } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Scene1')
export class Scene1 extends Component {
    private testScene: SceneAsset = null;

    onBtnDirectorPreloadClick() {
        console.log("call director.preloadScene");
        director.preloadScene("TestSceneInsideResourcesDir", (err, sceneAsset) => {
            if (!err) {
                this.testScene = sceneAsset;
                console.log('preload success', sceneAsset);
            }
        });
    }

    onBtnResourcesPreloadClick() {
        console.log("call resources.loadScene");
        resources.loadScene('TestSceneInsideResourcesDir', (err, sceneAsset) => {
            if (!err) {
                this.testScene = sceneAsset;
                console.log('preload success', sceneAsset);
            }
        });
    }

    onBtnLoadClick() {
        console.log("call director.loadScene");
        globalThis.lastTestTime = (new Date()).getTime();
        director.loadScene("TestSceneInsideResourcesDir")
    }

    onBtnRunClick() {
        if (this.testScene) {
            console.log("call director.runScene");
            globalThis.lastTestTime = (new Date()).getTime();
            director.runScene(this.testScene);
        } else {
            console.error('this.testScene = ', this.testScene);
        }
    }
}

