import { _decorator, Component, BufferAsset, assetManager } from 'cc';
const { ccclass, property } = _decorator;
import init, { DaoShuiGameBox } from "./demo";
import { Asset } from 'cc';
@ccclass('DaoShuiWasm')
export class DaoShuiWasm extends Component {
    @property({ type: BufferAsset, tooltip: 'bin' })
    bin: BufferAsset = null!;
    static wasmUrl: string = ''
    start() {
        this.start_init_api();
    }

    async start_init_api() {
        class BottleState {
            static Empty = 0
            static Some = 1
            static Full = 2
            static Close = 3
        }
        class GameState {
            static GameInit = 0
            static GamePlay = 1
            static GameWin = 2
            static GameLost = 3
            static GameOver = 4
            static GamePause = 5
        }
        function testCheck(test_name: string, val: any, need: any) {
            let is_success = val == need
            // assert(is_success, test_name);
            if (is_success == false) {
                console.error('测试【' + test_name + '】失败', '需要:', need, '实际:', val)
            } else {
                console.log('测试【' + test_name + '】成功')
            }
            return is_success
        }
        try {

            await new Promise<boolean>((resolve, reject) => {
                assetManager.loadAny('3014100d-ab4d-4f21-ab33-92072a91231c', BufferAsset, (err, asset: Asset) => {
                    if (err) {
                        console.error('Failed to load asset:', err);
                        return;
                    }
                    DaoShuiWasm.wasmUrl = asset.nativeUrl;
                    console.log('微信环境主要是获取这个 WASM URL:', DaoShuiWasm.wasmUrl);
                    resolve(true);
                });
            });
            // 初始化Wasm模块
            try {
                await init(DaoShuiWasm.wasmUrl);
                console.log('Wasm模块加载成功 h5方式');
            } catch (err) {
                console.error(err)
            }

            let config_data = {
                bottles_bodys: [[1, 2, 3], [1, 2, 3], [1, 2, 3], []],
                max_body_length: 3,
                max_round: 8,
                max_more_round: 2,
            }
            let game = new DaoShuiGameBox()
            game.set_config_data(JSON.parse(JSON.stringify(config_data)))
            console.log('创建了游戏盒子实例', game);

            game.play()
            // 
            game.touch_bottle(1)
            game.touch_bottle(3)
            let move_bodys = Array.from(game.move_body()) // 需要将Uint32Array 转一下
            // console.log('move_bodys',move_bodys)
            game.check_game_win_or_lost()
            testCheck('移动的bodys', JSON.stringify(move_bodys), '[3]')
            testCheck('from bodys', JSON.stringify(game.get_bottle_info(1).bodys), '[1,2]')
            testCheck('from state=BottleState.Some', JSON.stringify(game.get_bottle_info(1).state), BottleState.Some)
            testCheck('to bodys', JSON.stringify(game.get_bottle_info(3).bodys), '[3]')
            testCheck('to state=BottleState.Some', JSON.stringify(game.get_bottle_info(3).state), BottleState.Some)
            testCheck('当前未选中瓶from', game.get_cur_bottle(), null)
            testCheck('当前未选中瓶to', game.get_target_bottle(), null)
            // console.log(game.getData())
            game.touch_bottle(0)
            game.touch_bottle(3)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(3)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            testCheck('to state=BottleState.Close', JSON.stringify(game.get_bottle_info(3).state), BottleState.Close)
            game.touch_bottle(1)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            //  
            game.touch_bottle(1)
            game.touch_bottle(2)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(0)
            game.touch_bottle(1)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(1)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()

            // console.log(game.getData())


            game.touch_bottle(2)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            testCheck('游戏胜利', game.get_game_state(), GameState.GameWin)

        } catch (error) {
            console.error("Failed to load WASM:", error);
        }
    }
}