import { BottleState, DaoShuiGameBox, GameState, IConfigDaoShuiGameBoxData, IDaoShuiGameBoxData } from "./../DaoShuiGameBox";
import { assert, describe, test } from "poku";
import { TestUtil } from "./tools/TestUtil";
import { TimeSystem } from "./tools/TimeSystem";


let config_data: IConfigDaoShuiGameBoxData = {
    bottles_bodys: [[1, 2, 3], [1, 2, 3], [1, 2, 3], []],
    max_body_length: 3,
    max_round: 8,
    max_more_round: 2,
}

// let data_str = JSON.stringify(data)

const test_00 = () => {
    return new Promise((resolve, reject) => {
        test('测试基础功能方法', async () => {
            let game: DaoShuiGameBox = new DaoShuiGameBox()
            game.set_config_data(JSON.parse(JSON.stringify(config_data)))
            let bottles = game.get_bottles()
            testCheck('getBottles正常', JSON.stringify(bottles), '[{"bodys":[1,2,3],"index":0,"state":2},{"bodys":[1,2,3],"index":1,"state":2},{"bodys":[1,2,3],"index":2,"state":2},{"bodys":[],"index":3,"state":0}]')
            let gameTime = game.get_game_time()
            testCheck('getGameTime的初始值', gameTime, 0)
            resolve(true)
        })
    })
}

const test_01 = () => {
    return new Promise((resolve, reject) => {
        test('测试游戏时间', async () => {
            // 初始化及开始
            let game: DaoShuiGameBox = new DaoShuiGameBox()
            game.set_config_data(JSON.parse(JSON.stringify(config_data)))
            TestUtil.getInstance().setTimePassDt(10)
            TimeSystem.getInstance().addSystemToTimeUpdate(game).timePlay()
            game.play()
            await TimeSystem.getInstance().waitTimeSystemXms(200)
            testCheck('游戏时间流逝0.2秒正常', game.get_game_time(), 200)
            game.stop()
            await TimeSystem.getInstance().waitTimeSystemXms(200)
            testCheck('游戏时间暂停0.2秒正常', game.get_game_time(), 200)
            game.backplay()
            await TimeSystem.getInstance().waitTimeSystemXms(200)
            testCheck('游戏时间继续0.2秒正常', game.get_game_time(), 400)
            TimeSystem.getInstance().timeStop()
            resolve(true)
        })
    })
}

const test_02 = () => {
    return new Promise((resolve, reject) => {
        test('测试选中', async () => {
            // 初始化及开始
            let game: DaoShuiGameBox = new DaoShuiGameBox()
            game.set_config_data(JSON.parse(JSON.stringify(config_data)))
            // TestUtil.getInstance().setTimePassDt(1000).addSystemToTimeUpdate(game)
            let touch_empty_index = game.touch_bottle(3)
            testCheck('选不中空瓶子', touch_empty_index, -1)
            let touch_from_index = game.touch_bottle(1)
            testCheck('当前选中瓶子index=1', touch_from_index, 1)
            testCheck('当前瓶子内容', JSON.stringify(game.get_cur_bottle()), '{"bodys":[1,2,3],"index":1,"state":2}')
            let touch_to_index1 = game.touch_bottle(3)
            testCheck('目标选中了未满瓶子index=3', touch_to_index1, 3)
            testCheck('目标瓶子内容', JSON.stringify(game.get_target_bottle()), '{"bodys":[],"index":3,"state":0}')
            resolve(true)
        })
    })
}

const test_03 = () => {
    return new Promise((resolve, reject) => {
        test('测试倒水胜利', async () => {
            // 初始化及开始
            let game: DaoShuiGameBox = new DaoShuiGameBox()
            game.set_config_data(JSON.parse(JSON.stringify(config_data)))
            TestUtil.getInstance().setTimePassDt(100)
            TimeSystem.getInstance().addSystemToTimeUpdate(game).timePlay()
            game.play()
            // 
            game.touch_bottle(1)
            game.touch_bottle(3)
            let move_bodys = game.move_body()
            game.check_game_win_or_lost()
            testCheck('移动的bodys', JSON.stringify(move_bodys), '[3]')
            testCheck('from bodys', JSON.stringify(game.get_bottle_info(1).bodys), '[1,2]')
            testCheck('from state=BottleState.Some', JSON.stringify(game.get_bottle_info(1).state), BottleState.Some)
            testCheck('to bodys', JSON.stringify(game.get_bottle_info(3).bodys), '[3]')
            testCheck('to state=BottleState.Some', JSON.stringify(game.get_bottle_info(3).state), BottleState.Some)
            testCheck('当前未选中瓶from', game.get_cur_bottle(), null)
            testCheck('当前未选中瓶to', game.get_target_bottle(), null)
            // console.log(game.getData())
            game.touch_bottle(0)
            game.touch_bottle(3)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(3)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            testCheck('to state=BottleState.Close', JSON.stringify(game.get_bottle_info(3).state), BottleState.Close)
            game.touch_bottle(1)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            //  
            game.touch_bottle(1)
            game.touch_bottle(2)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(0)
            game.touch_bottle(1)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(1)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()

            // console.log(game.getData())

            await TimeSystem.getInstance().waitTimeSystemXms(2000)
            game.touch_bottle(2)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            testCheck('游戏胜利', game.get_game_state(), GameState.GameWin)

            // console.log(game.getData())

            await TimeSystem.getInstance().waitTimeSystemXms(2000)
            TimeSystem.getInstance().timeStop()
            resolve(true)
        })
    })
}

const test_04 = () => {
    return new Promise((resolve, reject) => {
        test('测试倒水失败后复活再次over', async () => {
            // 初始化及开始
            let game = new DaoShuiGameBox()
            game.set_config_data(JSON.parse(JSON.stringify(config_data)))
            TestUtil.getInstance().setTimePassDt(100)
            TimeSystem.getInstance().addSystemToTimeUpdate(game).timePlay()
            game.play()
            // 
            game.touch_bottle(1)
            game.touch_bottle(3)
            let move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(0)
            game.touch_bottle(3)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(3)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            testCheck('to state=BottleState.Close', JSON.stringify(game.get_bottle_info(3).state), BottleState.Close)
            game.touch_bottle(1)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            //  
            game.touch_bottle(1)
            game.touch_bottle(2)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(0)
            game.touch_bottle(1)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            game.touch_bottle(2)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            //console.log(game.getData())
            game.touch_bottle(1)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())

            game.touch_bottle(0)
            game.touch_bottle(1)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            // console.log(game.getData())
            testCheck('游戏失利', game.get_game_state(), GameState.GameLost)
            game.game_revive()
            testCheck('复活成功', game.get_game_state(), GameState.GamePlay)
            // testCheck('回合数增加', game.getData().curMoreRound, game.getData().maxMoreRound)
            game.touch_bottle(1)
            game.touch_bottle(0)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()

            game.touch_bottle(0)
            game.touch_bottle(1)
            move_bodys = game.move_body()
            game.check_game_win_or_lost()
            testCheck('游戏失败', game.get_game_state(), GameState.GameOver)

            await TimeSystem.getInstance().waitTimeSystemXms(2000)
            TimeSystem.getInstance().timeStop()
        })
    })
}

let functions = [
    test_00,
    test_01,
    test_02,
    test_03,
    test_04
]


function testCheck(test_name: string, val: any, need: any) {
    let is_success = val == need
    assert(is_success, test_name);
    if (is_success == false) {
        console.error('测试【' + test_name + '】失败', '需要:', need, '实际:', val)
    }
    return is_success
}

describe('关卡DaoShuiGameBox的001', async () => {
    while (functions.length > 0) {
        await functions.shift()()
        await waitXms() // 为了输出字幕顺序正常(poku的问题)
    }
});
const waitXms = (ms: number = 0) => {
    return new Promise<void>((resolve, reject) => {
        setTimeout(() => {
            resolve()
        }, ms)
    })
}

