import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('app')
export class app extends Component {
    @property(cc.Prefab)
    itemPrefab = null

    @property(Node)
    parentNode1 = null

    @property(Node)
    parentNode2 = null

    async start() {
        for (let i = 0; i < 30; i++) {
            let node = cc.instantiate(this.itemPrefab)
            node.parent = this.parentNode1
            let label = cc.find('Button/Label', node).getComponent(cc.Label)
            label.string = i + ' 继续滑动'
            if (i % 2 == 0) {
                node.parent = this.parentNode2
                label.string = i + ' 异常穿透'
            }
            cc.find('Button', node).on('touch-end', e => {
                cc.log('点击了: ' + i)
            })
        }
    }
}

