
import { ByteArray } from "./websocket/ByteArray";
import EgretWebSocket from "./websocket/EgretWebSocket";
import EventManager from "../manager/EventManager";
import SocketEvent from "./SocketEvent";
import App from "../App";
import AssetConst from "../../module/const/AssetConst";

const { ccclass, property } = cc._decorator;

/**
 * socket
 * @author chenkai 2020.6.19
 */
@ccclass
export default class ClientSocket {
	//单例
	private static _ins: ClientSocket;
	public static get ins(): ClientSocket {
		if (this._ins == null) {
			this._ins = new ClientSocket();
		}
		return this._ins;
	}

	/**WebSocket*/
	private socket: EgretWebSocket = null;
	/**锁屏UI */
	private lockUI: cc.Node;

	/**连接 */
	public connect(serverUrl: string) {
		console.log("[Socket] 开始连接:", serverUrl);
		this.createSocket();
		this.socket.connectByUrl(serverUrl);
	}

	/**创建Socket*/
	private createSocket() {
		if (this.socket == null) {
			this.socket = new EgretWebSocket();
			this.socket.type = EgretWebSocket.TYPE_BINARY;
			this.socket.on(EgretWebSocket.CONNECT, this.onConnect, this);
			this.socket.on(EgretWebSocket.SOCKET_DATA, this.onReceive, this);
			this.socket.on(EgretWebSocket.IO_ERROR, this.onIOError, this);
			this.socket.on(EgretWebSocket.CLOSE, this.onClose, this);
		}
	}

	/**连接成功*/
	private onConnect() {
		console.log("[Socket] 连接成功");
		EventManager.ins.emit(SocketEvent.SOCKET_CONNECT_SUCCESS);
	}


	/**
	 * 发送数据
	 * @param cmd 命令
	 * @sendByte 数据（ProtoBuf）
	 * @param bLock 是否显示加载动画
	 */
	public send(cmd: string, sendByte: Uint8Array, bLock: boolean = false) {
		console.log("[Socket] 发送cmd:", cmd);
		//未连接
		if (this.isConnencted() == false) {
			EventManager.ins.emit(SocketEvent.SOCKET_NOT_CONNECT);
			return;
		}
		//加载动画
		bLock && this.lock();

		//发送的数据cmd+proto
		let sendByteArray = new ByteArray(sendByte);
		let byteArray: ByteArray = new ByteArray();
		byteArray.writeUnsignedShort(Number(cmd));
		byteArray.writeBytes(sendByteArray);
		//发送
		this.socket.writeBytes(byteArray);
		this.socket.flush();
	}


	/**接收数据*/
	private onReceive() {
		// //读取socket数据
		var byte: ByteArray = new ByteArray();
		this.socket.readBytes(byte);
		//读取cmd
		let cmd: number = byte.readUnsignedShort();
		//读取proto
		let revByteArray: ByteArray = new ByteArray();
		byte.readBytes(revByteArray);

		this.unlock();
		
		EventManager.ins.emit(cmd + "", revByteArray.bytes);
	}

	/**连接错误*/
	private onIOError(e) {
		console.log("[Socket] 连接错误");
		this.unlock();
		EventManager.ins.emit(SocketEvent.SOCKET_IO_ERROR);
	}

	/**连接断开*/
	private onClose() {
		console.log("[Socket] 连接关闭");
		this.unlock();
		EventManager.ins.emit(SocketEvent.SOCKET_CLOSE);
	}

	/**主动关闭socket */
	public forceClose() {
		this.unlock();
		this.socket.close();
	}

	/**是否已经连接 */
	public isConnencted() {
		if (this.socket && this.socket.connected == true) {
			return true;
		} else {
			return false;
		}
	}

	/**锁屏 */
	private lock() {
		//todo
	}

	/**解锁 */
	private unlock() {
		//todo
	}
}
