//////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) 2014-present, Egret Technology.
//  All rights reserved.
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Egret nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY EGRET AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL EGRET AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE, DATA,
//  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//////////////////////////////////////////////////////////////////////////////////////



/**
 * The HttpMethod class provides values that specify whether the HttpRequest object should use the POST method
 * or the GET method when sending data to a server.
 * @see egret.HttpRequest
 * @version Egret 2.4
 * @platform Web,Native
 * @language en_US
 */
/**
 * HttpRequestMethod 类提供了一些值，这些值可指定在将数据发送到服务器时，
 * HttpRequest 对象应使用 POST 方法还是 GET 方法。
 * @see egret.HttpRequest
 * @version Egret 2.4
 * @platform Web,Native
 * @language zh_CN
 */
export namespace HttpMethod {

    /**
     * Specifies that the HttpRequest object is a GET.
     * @version Egret 2.4
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 表示 HttpRequest 对象是一个 GET。
     * @version Egret 2.4
     * @platform Web,Native
     * @language zh_CN
     */
    export const GET = "GET";

    /**
     * Specifies that the HttpRequest object is a POST.
     * @version Egret 2.4
     * @platform Web,Native
     * @language en_US
     */
    /**
     * 表示 HttpRequest 对象是一个 POST。
     * @version Egret 2.4
     * @platform Web,Native
     * @language zh_CN
     */
    export const POST = "POST";
}
