
import { _decorator, Component, Node, director, assetManager, AssetManager, SceneAsset } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        // [3]
    }

    click1(){
        director.loadScene("scene1")
    }

    click2(){
        assetManager.loadBundle("test",null, (err: Error|null, bundle: AssetManager.Bundle)=>{
            if(bundle){
                bundle.loadScene("scene2", (err:Error, scene: SceneAsset)=>{
                    director.runScene(scene);
                })
            }
        })
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
