/**
 * 游戏配置
 */

export class GameConst {
    public static cocosWebDebug = false;//网页调试环境
    public static ignoreRemoteImg = false;//是否忽略远程图片的下载请求
    public static readonly isDebug = true;//是否是内网测试服调试模式 <<<<<<<<<<<<<<<<------------切换内外网修改这里



    public static readonly version = "0.1.3";//版本号
    public static readonly language = "EN";
    public static readonly maxAdsCount = 20;
    public static netTime = 0;//联网时间戳

    public static openPages = [];//当前打开的页面名称
    public static menuPage = [];//当前打开的页面名称

    //可挖掘的地块id数组 ,根据挖矿设置可能会加入15-宝箱序号
    public static mineTileArr: number[] = [2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 17];
    //高价值的地块
    public static goodTileArr: number[] = [7, 8, 9, 10, 11, 12, 13, 14, 17];
    //修复矿镐耐久度的单价,恢复1点耐久需要多少金币
    public static fixCost: number = 35;

}
//挖矿设置,深度优先(为假则是宽度优先)，自动修复，自动开宝箱
export let autoMineSet: { deepFirst: boolean, autoFix: boolean, openBox: boolean } = {
    deepFirst: true,
    autoFix: false,
    openBox: false
};
export class GameInviteInfo {
    public static userId = '';
    public static userName = '';
    public static isTG = '';
}

/**充值数值配置,限定1-5共5个参数,第六个是自定义数值*/
export let chargeNums = {
    '1': 100,
    '2': 1000,
    '3': 10000,
    '4': 100000,
    '5': 500000 //50万
}
export let chipChargeNum = {
    '1': 100,
    '2': 1000,
    '3': 10000,
    '4': 100000,
    '5': 500000 //50万
}



//------以下是确定用到的------------
//摧毁地块需要消耗的耐久度
// export let tileCost = [
//     0,//没有生成的黑块格子
//     0,//1-道路格子
//     1,//2-黄色泥巴格子
//     2,//3-灰白岩石格子
//     3,//4-赭色岩石格子
//     4,//5-深紫岩石格子
//     0,//6-熔岩地砖不能摧毁
//     1,//7-普通石头
//     2,//8-红土矿石
//     3,//9-银土矿石
//     4,//10-绿矿石
//     5,//11-彩矿石

//     5,//12-彩色能源
//     6,//13-毁灭矿石
//     6,//14-大彩矿石
//     0,//15-珍惜宝箱
//     0,//16-usdt宝箱-哥布林token宝箱
//     3,//17-钻石
// ];
// export let tileTimeCost = [
//     0, 0, 1, 2, 4, 7, 0,//没显示的黑格子，路格子，前五种砖
//     2, 3, 4, 5,//普通矿石，红土，银土，绿矿石，
//     6, 7, 7, 7,//彩矿石，彩色能源，毁灭矿石，大彩矿石
//     4, 0, 3//珍惜宝箱，哥布林token宝箱,钻石
// ];
export interface tileModel {
    x: number,
    y: number,
    state: number
}
//矿镐信息配置
export interface mineInfoModel {
    time: number,
    lastTileIndex: { x: number, y: number },
    //depth: number,//当前矿场的深度
    level: number,//当前矿场的关卡
    tileArr: number[][],//当前矿场的地块信息
    door: { x: number, y: number },//当前矿场的出口坐标
}
//配置表的相关接口
export interface tableDataModel {
    // pickaxeLv: { [key: string]: pickaxeLvModel },
    // pickaxe: { [key: string]: pickaxeModel },
    spBlockConfigList: blockConfig[],//地块配置列表
    spHoeConfigList: hoeConfig[]//锄头配置列表
}
//矿镐配置
export interface pickaxeModel {
    name: string,
    des: string,
    keyDay: number,
    soldPrice: number,
    soldType: number,
    reduceLosses: number
}
//矿镐等级配置
export interface pickaxeLvModel {
    durable: number,//耐久度上限
    goldRate: number,//每秒增加的金币
    durableRate: number,//每小时恢复的耐久度
    goldAuto: number,//自动收集的金币/小时
}
//挖掘地块后的奖励接口
export interface spBlockRsp {
    gold?: number;          // 金币产出(整数，可选)
    diaa?: number;          // 钻石产出(数字，可选)
    keyCount?: number;      // 钥匙产出(整数，可选)
    point?: number;         // 积分产出(整数，可选)
    usdt?: number;          // USDT金额(数字，可选)
    equipId?: number;       // 装备ID(整数，可选)
    equipIdCount?: number;  // 装备数量(整数，可选)
    durability: number;     // 消耗耐久度(整数，必选)
}
//地砖的配置信息
export interface blockConfig {
    id?: number;              // 方块ID(整数，可选)
    blockImg?: string;        // 方块图片(可选)
    blockTime?: number;       // 消耗时间(整数，可选)
    gold?: number;            // 金币产出(整数，可选)
    diaa?: number;            // 钻石产出(数字，可选)
    keyCount?: number;        // 钥匙产出(整数，可选)
    point?: number;           // 积分产出(整数，可选)
    incrRate?: number;        // 每关递增比例(数字，可选)
    rate?: number;            // 生成概率(数字，可选)
    durability?: number;      // 消耗耐久度(整数，可选)
    toRate?: number;          // 底部概率(数字，可选)
    toIncrRate?: number;      // 底部递增概率(数字，可选)
}
//矿镐的配置信息
export interface hoeConfig {
    id?: number;                  // 装备ID(整数，可选)
    hoeName?: string;             // 稿子名称(可选)
    durability?: number;          // 最大耐久度(整数，可选)
    hoeImg?: string;              // 稿子图片(可选)
    hoeType?: number;// 稿子类型(1橙色 2红色 3紫色 4蓝色 5绿色)
    goldCapacity?: number;        // 金币产能（倍率，数字，可选)
    replyDurability?: number;     // 耐久回复（每小时，数字，可选)
    repairDurability?: number;    // 一点耐久度修复需要金币(整数，可选)
    autoGold?: number;            // 金币收集进度(每小时，整数，可选)
    type?: number;                // 装备类型(1普通 2高级)
    sellJson?: string;            // 售卖奖励(JSON字符串，可选) [{\"type\":4,\"value\":100},{\"type\":5,\"value\":3}]
    autoJson?: string;            // 装备锄头24小时获得的奖励(JSON字符串，可选) [{\"type\":3,\"value\":100}]
    deathRate?: number;           // 减少战斗死亡比例(数字，可选)
    rate?: number;                 // 抽奖比例
    incr: string;                 // 稿子介绍
    num?: number;                  // 数量
}
//矿场信息接口
export interface spPool {
    userId?: string;        // 用户ID(可选)
    gridState?: string;   // 存储矿场排布的字节类型数据(数组，可选)
    x?: number;             // 传送点x坐标(整数，可选)
    y?: number;             // 传送点y坐标(整数，可选)
    level?: number;         // 当前关卡(整数，可选)
    lastX?: number;         // 最后记录的x坐标(整数，可选)
    lastY?: number;         // 最后记录的y坐标(整数，可选)
}
//背包中的道具信息
export interface itemConfig {
    id?: number;          // 物品ID(整数，可选)
    nameJson?: string;    // 名称(JSON字符串，可选)
    img?: string;         // 图片路径(可选)
    endTime?: string;     // 结束时间(字符串，可选)
    awardJson?: string;   // 奖励配置信息(JSON字符串，可选)
    rate?: number;        // 出现概率(数字，可选)
    num?: number;         // 拥有的数量(整数，可选)
}
//文物抽卡返回的道具模板数据
export interface hoeItem {
    id?: number;                 // 装备ID(整数，可选)
    hoeName?: string;            // 稿子名称(可选)
    durability?: number;         // 最大耐久度(整数，可选)
    hoeImg?: string;             // 稿子图片路径(可选)
    hoeType?: number;            // 稿子类型(1橙色 2红色 3紫色 4蓝色 5绿色)
    goldCapacity?: number;       // 金币产能倍率(数字，可选)
    autoGoldMax?: number;        // 最大收集金币数量(整数，可选)
    replyDurability?: number;    // 耐久回复速度(每小时，数字，可选)
    repairDurability?: number;   // 单点耐久修复金币消耗(整数，可选)
    autoGold?: number;           // 金币收集进度(每小时，整数，可选)
    type?: number;               // 装备品质(1普通 2高级)
    sellJson?: string;           // 售卖奖励(JSON字符串，可选)
    autoJson?: string;           // 24小时装备奖励(JSON字符串，可选)
    deathRate?: number;          // 战斗死亡率降低比例(数字，可选)
    rate?: number;               // 抽奖获得概率(数字，可选)
    incr?: string;               // 稿子详细介绍文本(可选)
}
//文物抽奖的记录
export interface hoeDrawInfo {
    id?: number;         // 记录ID(整数，可选)
    userId?: string;     // 用户ID(字符串，可选)
    hoeId?: number;      // 锄头装备ID(整数，可选)
    num?: number;        // 锄头数量(整数，可选)
    createTime?: string; // 创建时间(字符串，ISO格式，可选)
    usdt?: number;       // 物品价值(USDT，数字，可选) 
}
//活动道具模板--矿场两边的图标
export interface actPropModel {
    id: number;
    nameJson: { [key: string]: string };//多语言名称
    img: string;
    endTime: string;//活动结束时间
    awardJson: actPropAward[];//奖励
    rate: number;//概率
    num: number;//数量
    rewardStr: number[];//已领的选项奖励id  数组
}
//活动道具的奖励
export interface actPropAward {
    id: number;//奖励id
    type: number;//奖励类型
    value: number;//奖励值
    twoType: number;//奖励类型2
    twoValue: number;//奖励值2
    buyType: number;//购买类型
    buyValue: number;//购买值
    stars: number;//购买值：星星支付的价格
    tonValue: number;//购买值：ton价格
    eoet: number;//购买值：eoet价格
    eqCount: number;//数量
}
//提现钻石的配置模板
export interface withdrawCfgModel {
    id: number;
    value: number;//需要提取的钻石数量
    point: number;//需要的积分
    inviteNum: number;//需要有效邀请的人数
    flag: string;//1已领取或者提现中 0没有
}
//提现记录的模板
export interface withdrawRecordModel {
    id?: number; // 提现记录ID 
    userId?: string; // 用户ID 
    withdrawId?: number; // 提现ID 
    state?: number; // 提现状态：0体现中 1提现成功 2提现失败 
    hash?: string; // 提现hash 
    errorMsg?: string; // 错误信息 
    createTime?: string; // 创建时间 
    withdrawValue?: number; // 提现金额 
    walletAddress?: string; // 提现钱包地址 
}