import Singleton from "../plugin/Singleton";
import GFunc from "../GFunc";
import LogMgr from "./LogMgr";
import { actPropModel, mineInfoModel, spPool, tableDataModel } from "../Config";


export class UserInfo {
    userId: string = ''; // 用户ID
    userName: string = ''; // 用户名称
    shareCode: string = ''; // 邀请码
    usdt: number = 0; // USDT余额
    balance: number = 0; // 金币余额
    diaa: number = 0; // 钻石余额
    keyCount: number = 0; // 钥匙数量
    energy: number = 0; // 耐久度
    point: number = 0; // 积分
    hoeId: number = 0; // 锄头ID
    hoeLevel: number = 0; // 锄头等级
    freeForgingCount: number = 0; // 免费锻造数量
    forgingCount: number = 0; // 收费锻造数量
    walletAddress: string = ''; // 玩家自己绑定的钱包地址
    isPre: number = 0; // 1是TG会员 0不是TG会员
    createTime: string = ''; // 创建时间
    updateTime: string = ''; // 更新时间
    poolUpdateTime: string = ''; // 矿场更新时间
    hotUpdateTime: string = ''; // 耐久度更新时间
    collectTime: string = ''; // 收集时间
    hoeUpdateTime: string = ''; // 锄头装备时间
    invitedLink: string = ''; // 邀请链接
    inviteNum: number = 0; // 邀请人数
    invitePreNum: number = 0; // 邀请tg会员人数
    img: string = ''; // 图片链接
    address: string = ''; // 项目收款钱包地址



}
//矿洞每个格子的信息
interface GridCell {
    x: number;
    y: number;
    state: number;
}

class userDataMgr extends Singleton {
    private userData: UserInfo = null;
    private tableData: tableDataModel = null;//配置表参数

    //矿场信息
    private mineInfo: mineInfoModel = { time: 506640, lastTileIndex: { x: 0, y: 0 }, door: { x: 0, y: 0 }, level: 1, tileArr: [] };


    public initData(userData: UserInfo): void {
        LogMgr.info('初始化用户数据:', userData);
        if (!userData) {
            userData = GFunc.getLocal('userInfo');
            if (!userData) {
                userData = new UserInfo();
            }
        }
        this.userData = userData;
    }
    /**初始化矿洞信息
     * @param netMineInfo
     * */
    public initMineInfo(): void {
        //先转换字符串为Uint8Array
        this.mineInfo = {
            "time": 0, "lastTileIndex": { "x": 37, "y": 8 }, "level": 4,
            "tileArr": [
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 16, 1, 1, 1, 1, 4, 2, 0, 3, 2, 1, 1, 2, 2, 3, 7, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 1, 1, 2, 1, 16, 1, 1, 1, 2, 2, 2, 2, 2, 0, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 4, 1, 1, 2, 16, 0, 0, 0, 0, 0, 3, 2, 1, 1, 3, 1, 1, 1, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 1, 2, 3, 2, 2, 2, 7, 0, 2, 2, 1, 2, 3, 2, 2, 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 1, 2, 2, 2, 4, 2, 2, 2, 2, 4, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 3, 4, 2, 1, 2, 2, 2, 1, 1, 1, 1, 3, 4, 1, 2, 3, 2, 3, 7, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 1, 2, 3, 1, 1, 1, 1, 2, 3, 2, 2, 2, 3, 7, 2, 1, 1, 16, 2, 4, 3, 2, 2, 2, 2, 1, 1, 1, 1, 2, 8, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 4, 0, 0, 0, 3, 2, 2, 1, 1, 2, 2, 3, 1, 1, 1, 2, 4, 2, 1, 3, 2, 8, 3, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 2, 1, 3, 2, 3, 2, 3, 3, 2, 7, 0, 0, 0, 3, 3, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 3, 1, 1, 1, 1, 2, 3, 3, 0, 0, 7, 4, 4, 4, 2, 1, 2, 2, 1, 2, 1, 1, 1, 4, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 3, 1, 4, 1, 3, 15, 1, 1, 2, 7, 2, 0, 0, 0, 0, 2, 2, 1, 1, 1, 1, 2, 1, 3, 1, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 1, 1, 4, 2, 1, 1, 2, 4, 0, 0, 0, 0, 2, 2, 1, 2, 4, 1, 2, 2, 2, 2, 4, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 2, 2, 2, 2, 2, 15, 3, 3, 2, 4, 2, 2, 2, 1, 2, 1, 1, 2, 4, 1, 2, 7, 3, 4, 4, 2, 2, 4, 2, 2, 1, 1, 15, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [3, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 3, 2, 2, 2, 4, 1, 1, 2, 2, 2, 3, 3, 2, 3, 2, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [4, 2, 1, 2, 1, 1, 2, 2, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2, 4, 1, 1, 1, 1, 4, 2, 3, 1, 1, 1, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 16, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [1, 1, 1, 2, 2, 1, 1, 1, 16, 2, 2, 3, 4, 2, 4, 3, 4, 2, 2, 1, 3, 1, 2, 1, 16, 3, 1, 1, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 4, 16, 3, 0, 0, 0, 0, 0, 0, 0, 0],
                [2, 2, 2, 16, 7, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 2, 2, 2, 2, 2, 3, 0, 0, 0, 8, 2, 1, 1, 1, 1, 1, 2, 16, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 2, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 4, 2, 1, 1, 2, 2, 0, 0, 0, 0, 2, 16, 2, 16, 2, 1, 1, 2, 2, 2, 7, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 2, 16, 2, 1, 2, 7, 2, 3, 3, 2, 2, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 16, 2, 2, 3, 2, 2, 2, 2, 1, 1, 1, 1, 2, 9, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 2, 4, 1, 1, 2, 1, 3, 1, 3, 1, 2, 1, 2, 2, 1, 2, 2, 1, 1, 2, 3, 1, 1, 2, 1, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 2, 2, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 3, 2, 2, 1, 2, 3, 1, 2, 3, 2, 3, 2, 7, 2, 2, 8, 2, 0, 0, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 2, 2, 2, 2, 3, 2, 1, 1, 2, 2, 1, 4, 1, 1, 3, 1, 1, 1, 1, 2, 2, 3, 1, 1, 2, 3, 4, 2, 1, 2, 3, 2, 2, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 8, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 4, 2, 4, 3, 3, 1, 2, 2, 3, 2, 2, 1, 1, 1, 2, 2, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 1, 2, 2, 15, 2, 3, 2, 1, 2, 2, 3, 2, 4, 3, 2, 1, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 2, 2, 0, 2, 2, 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 2, 1, 2, 2, 0, 4, 2, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 3, 2],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 3, 2, 2, 2, 5, 2, 1, 3, 6, 1, 1, 2, 3, 1, 1, 2, 1, 4, 2, 2, 16, 1, 1, 1, 1, 1, 1],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 5, 1, 1, 1, 1, 1, 4, 3, 3, 1, 1, 1, 4, 16, 2, 1, 1, 1, 1, 1, 3, 1, 2, 1, 15, 2],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 2, 1, 3, 1, 2, 2, 2, 3, 1, 1, 2, 2, 3, 6, 1, 4, 5, 1, 2, 1, 1, 2, 1, 4, 1],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 1, 1, 1, 2, 2, 1, 2, 1, 1, 3, 9, 2, 2, 2, 4, 4, 5, 4, 1, 1, 1, 3, 1, 1, 1],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 2, 1, 1, 15, 1, 1, 1, 1, 5, 4, 2, 2, 16, 16, 1, 6, 2, 2, 2, 7, 4, 1, 1, 15, 2, 2, 5],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 1, 2, 2, 2, 1, 1, 3, 4, 3, 2, 2, 2, 1, 1, 1, 1, 2, 1, 3, 3, 1, 2, 4, 3, 3, 2],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 1, 1, 1, 1, 5, 1, 1, 1, 1, 1, 1, 4, 2, 4, 2, 3, 1, 1, 1, 1, 4, 1, 1, 1, 1, 5, 7],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 9, 16, 3, 7, 3, 1, 1, 2, 1, 1, 1, 2, 3, 3, 1, 1, 1, 1, 1, 3, 2, 1, 2, 5, 1, 1, 1, 1, 1, 3, 4, 7],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 17, 1, 1, 2, 2, 1, 1, 3, 1, 5, 1, 3, 4, 1, 1, 2, 4, 3, 1, 4, 2, 1, 3, 3, 16, 4, 5, 1, 3, 3, 7, 0],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 2, 4, 17, 4, 1, 17, 3, 4, 1, 1, 1, 1, 16, 1, 1, 2, 2, 1, 2, 5, 16, 1, 2, 6, 1, 1, 1, 1, 2, 16, 2, 2, 3, 2, 16],
                [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 3, 2, 1, 3, 1, 3, 1, 3, 5, 7, 1, 16, 3, 1, 4, 15, 1, 2, 4, 1, 1, 1, 1, 2, 15, 9, 2, 3, 2, 1, 1, 1, 1, 5, 1, 6, 4],
                [0, 0, 0, 0, 0, 0, 7, 2, 2, 3, 3, 3, 3, 3, 1, 1, 1, 1, 8, 1, 10, 10, 12, 1, 4, 2, 2, 4, 2, 1, 1, 1, 1, 15, 3, 5, 4, 8, 6, 1, 1, 3, 3, 16, 1, 1, 1, 1, 1, 1],
                [0, 0, 0, 0, 0, 0, 5, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 3, 8, 1, 4, 1, 1, 1, 3, 2, 1, 1, 1, 1, 16, 4, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2],
                [0, 0, 0, 0, 0, 0, 2, 3, 3, 1, 4, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 17, 3, 2, 2, 1, 3, 2, 4, 3, 1, 4, 1, 6, 3, 2, 1, 1, 1, 1, 2, 16, 1, 4, 1, 1, 3, 15, 2],
                [0, 0, 0, 0, 0, 2, 3, 3, 1, 1, 2, 3, 3, 1, 3, 1, 2, 1, 1, 1, 1, 6, 7, 2, 2, 2, 1, 2, 4, 1, 1, 1, 5, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 1, 1, 1, 2, 2, 4, 0],
                [0, 0, 0, 0, 0, 17, 11, 1, 1, 3, 1, 16, 2, 3, 15, 2, 2, 2, 16, 1, 2, 3, 3, 5, 3, 1, 1, 1, 1, 1, 15, 4, 2, 3, 16, 3, 1, 1, 2, 1, 16, 2, 6, 1, 1, 4, 2, 2, 0, 0],
                [0, 0, 0, 2, 4, 2, 5, 1, 1, 1, 1, 1, 2, 4, 0, 0, 4, 2, 1, 1, 2, 5, 3, 1, 1, 1, 2, 1, 16, 2, 2, 1, 16, 3, 8, 3, 4, 4, 1, 1, 1, 1, 2, 1, 1, 5, 16, 0, 0, 0],
                [3, 5, 2, 3, 3, 1, 1, 1, 1, 18, 3, 1, 3, 15, 2, 0, 5, 2, 2, 3, 1, 1, 1, 1, 2, 4, 3, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 5, 5, 5, 5, 1, 1, 5, 1, 4, 3, 0, 0, 0],
                [1, 5, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 2, 3, 4, 3, 2, 1, 1, 4, 2, 2, 2, 15, 1, 3, 3, 1, 1, 16, 3, 1, 1, 1, 1, 4, 2, 4, 3, 3, 1, 2, 2, 8, 3, 0, 0, 0],
                [1, 1, 1, 2, 2, 1, 3, 1, 16, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 16, 1, 2, 2, 5, 2, 8, 8, 17, 3, 1, 2, 8, 0, 0, 0, 0, 0],
                [1, 2, 2, 15, 1, 1, 1, 1, 2, 6, 1, 1, 1, 1, 6, 2, 1, 2, 3, 3, 1, 3, 16, 1, 2, 1, 3, 3, 4, 2, 1, 2, 4, 1, 1, 4, 4, 2, 4, 2, 2, 1, 1, 2, 3, 0, 0, 0, 0, 0],
                [1, 2, 3, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1, 5, 2, 4, 1, 2, 5, 1, 1, 1, 15, 1, 2, 1, 1, 5, 2, 2, 16, 3, 4, 2, 1, 1, 1, 1, 2, 7, 2, 1, 1, 2, 16, 0, 0, 0, 0, 0],
                [1, 3, 3, 1, 1, 4, 1, 1, 2, 1, 6, 1, 1, 1, 3, 2, 2, 4, 1, 1, 1, 1, 1, 1, 2, 4, 1, 6, 4, 0, 0, 0, 10, 6, 4, 1, 1, 5, 7, 2, 8, 3, 2, 4, 8, 0, 0, 0, 0, 0]
            ],
            "door": { "x": 9, "y": 44 }
        };
    }
    /**
     * 更新矿洞地块信息
     * @param maps { x: number, y: number, state: number }[]
     */
    public updateMineTile(maps: { x: number, y: number, state: number }[]) {
        for (let i = 0; i < maps.length; i++) {
            let tile = maps[i];
            if (!this.mineInfo.tileArr[tile.y]) {
                this.mineInfo.tileArr[tile.y] = [];
            }
            this.mineInfo.tileArr[tile.y][tile.x] = tile.state;
        }
    }

    //获取用户数据
    public getData(): UserInfo {
        if (!this.userData) {
            this.userData = new UserInfo();
        }
        return this.userData;
    }
    //获取矿洞信息
    public getMineInfo(): mineInfoModel {
        return this.mineInfo;
    }

    //初始化配置表参数
    public initTableData(tableData: tableDataModel): void {
        this.tableData = tableData;
    }

    public log() {
        console.log('当前用户数据为：', this.userData);
    }

}
let DataMgr = userDataMgr.getInstance();
export default DataMgr;
// 使用示例：
// const dataManager = DataMgr.getInstance();
// dataManager.updateData('playerStats', { level: 5, score: 1000 });
// const stats = dataManager.getData<{ level: number }>('playerStats');
