import { actPropModel, autoMineSet, GameConst, mineInfoModel, spBlockRsp, tileModel } from '../Config';
import { _decorator, Sprite, instantiate, Node, Label, v3, Vec3, RichText, tween, ProgressBar, Button, UITransform, ScrollView, v2, sp, SpriteFrame, Animation, isValid } from 'cc';
import PageBase from '../plugin/PageBase';
import ResManger from '../Manager/ResManger';
import GFunc from '../GFunc';
import UIHelp from '../UIHelp';
import EventManager from '../Manager/EventManager';
import LogMgr from '../Manager/LogMgr';
import DataMgr, { UserInfo } from '../Manager/DataMgr';
import tileUtil from '../Manager/tileUtil';
import TilePoolMgr from '../Manager/TilePoolMgr';
const { ccclass, property } = _decorator;

@ccclass('MinePage2')
export class MinePage2 extends PageBase {
    @property(Label)
    goldLab: Label = null!;//坐标位置
    @property(Label)
    posLab: Label = null!;//坐标位置
    @property(Node)
    autoTip: Node = null!;//自动挖矿的提示节点
    @property(ScrollView)
    mineScroll: ScrollView = null!;//矿场地块列表

    @property(Node)
    tileCell: Node = null!;//地块
    @property(Node)
    mineLayer: Node = null!;
    @property(Node)
    worker: Node = null!;//矿工
    @property(Node)
    alertTip: Node = null!;//地块挖掘奖励提示节点

    private _canDig: boolean = true;//能否点击地块挖掘
    private deepestPos: { x: number, y: number } = { x: 0, y: 0 };//最深的坐标位置
    private startPos: { x: number, y: number } = { x: 0, y: 0 };//最开始的坐标位置
    private _roadArr: { x: number, y: number }[] = [];//当前道路数组
    private widthDigArr: tileModel[] = [];//广度优先的当前可挖的数组
    private _wIdx: number = 0;//广度优先的当前可挖的数组下标
    private _retryCount: number = 0;//广度优先时的重搜次数
    private _gold: number = 0;//金币数量
    private _doorTW: any = null;//挖到门后的提示动画

    onLoad(): void {
        LogMgr.log("==Mine=onload==");

        //监听获得奖励的动画 事件
        EventManager.on('digAlert', this.digAlert, this);
        //监听 自动挖矿时自动移动视图 事件
        EventManager.on('scrollHL', (h: number, l: number, second: number = 0.5) => {
            //scrollToOffset是把目标点放在左上角零点位置的，所以需要修正一下，让目标格子显示在中间位置
            //oPx:layer宽度-view宽度差的一半负值,layer锚点Y=1
            LogMgr.redLog('----scrollToTile:', h, l);
            let oPx = -5125, oPy = 0;//scroll滚动的左上角坐标
            let tileNode = this.mineLayer.getChildByName('tile-' + h + '-' + l);
            LogMgr.redLog('----scrollToTile,tileNode:', isValid(tileNode));
            if (isValid(tileNode)) {
                this.mineScroll.scrollToOffset(v2(tileNode.x - oPx, -tileNode.y - 400), second);
            }

        }, this);
        //监听 自动挖矿时自动移动视图 事件
        /*
        this.mineScroll.node.on(ScrollView.EventType.SCROLL_ENDED, (scrollView: ScrollView) => {
            LogMgr.warn('==Offset:', this.mineScroll.getScrollOffset(), ',max:', this.mineScroll.getMaxScrollOffset());//max:{x: 10250, y: 6100}
            //根据Offset数值计算出对应的行列值
            let off = this.mineScroll.getScrollOffset();
            let px = -off.x - 5125;//105
            let py = -off.y - 400;//-6310
            let lhSum = (px + 5145) / 105;//50
            let lhSub = (py + 3475) / 67.5;//-42
            let h = (lhSum - lhSub) / 2;
            let l = (lhSum + lhSub) / 2;
            LogMgr.redLog('==h:', h, 'l:', l);
            if (Math.abs(h - Math.round(h)) > 0.0001 || Math.abs(l - Math.round(l)) > 0.0001) {
                LogMgr.redLog('=----=h:', Math.round(h), 'l:', Math.round(l));
                EventManager.emit('scrollHL', Math.round(h), Math.round(l));
                return;
            } else {
                h = Math.round(h);
                l = Math.round(l);
            }
            // 回收视口外的节点
            this.mineLayer.children.forEach(tile => {
                let [pre, gH, gL] = tile.name.split('-');
                let tileH = Number(gH);
                let tileL = Number(gL);
                //如果行数小于当前行数-4或者大于当前行数+4,则回收
                if (tileH < h - 4 || tileH > h + 4) {
                    TilePoolMgr.put(tile);
                    return;
                }
                //行数序号在当前行数-4和当前行数+4之间的,则需要判断列序号是否在显示列之间
                //确定当前行数所需要显示的列的序号
                let startL = tileL - 4 + tileH - h;
                let endL = tileL + 4 - tileH + h;
                LogMgr.warn('==tile:', tile.name, startL, endL);
                if (tileL < startL || tileL > endL) {
                    TilePoolMgr.put(tile);
                }
            });
            LogMgr.warn('==h:生成可视区域内的地块h:', h, 'l:', l);
            let tileArr = DataMgr.getMineInfo().tileArr;
            // 生成可视区域内的地块
            for (let row = h - 4; row <= h + 4; row++) {
                let startCol = l - 4 + row - h;
                let endCol = l + 4 - row + h;
                for (let col = startCol; col <= endCol; col++) {
                    if (row >= 0 && row < 50 && col >= 0 && col < 50) {
                        LogMgr.warn('==h:生成可视区域内的地块row:', row, col, tileArr[row][col]);
                        this.showNewTile(row, col, tileArr[row][col]);
                    }
                }
            }
        }, this);
*/

        //临时测试用
        EventManager.on('autoDig', this.startAutoDig, this);
        EventManager.on('digTile', (x: number, y: number) => {
            let mineInfo = DataMgr.getMineInfo();
            if (mineInfo.tileArr[y] && mineInfo.tileArr[y][x]) {
                mineInfo.tileArr[y][x] = 1;
            }
            let brick = this.mineLayer.getChildByName('tile-' + y + '-' + x);
            if (brick) {
                brick.getComponent(Sprite).spriteFrame = ResManger.getTileSP('ore1');//重置为道路地块
                brick.getComponent(Button).clickEvents[0].customEventData = JSON.stringify({ state: 1, x: x, y: y });
            }
        }, this);

        window['DataMgr'] = DataMgr;


    }
    start() {

    }
    showNewTile(h: number, l: number, state: number) {
        let tileKey = 'tile-' + h + '-' + l;
        if (this.mineLayer.getChildByName(tileKey)) {
            LogMgr.log('已经存在了:', tileKey);
            return;
        }
        if (!state) { return; }
        let zeroPx = -5145, zeroPy = -3375 - 100;
        let tile = TilePoolMgr.get();
        tile.name = tileKey;
        tile.parent = this.mineLayer;
        let px = zeroPx + l * 105 + h * 105, py = zeroPy - h * 67.5 + l * 67.5;
        tile.position = v3(px, py, 0);
        tile.setSiblingIndex(h * 100 + 51 - l);
        let ore = tile.getChildByName('ore');
        if (state <= 1) {
            ore.getComponent(Sprite).spriteFrame = null;
        } else {
            ore.getComponent(Sprite).spriteFrame = ResManger.getTileSP('ore' + state);
        }
        ore.getComponent(Button).clickEvents[0].customEventData = JSON.stringify({ state: state, x: l, y: h });
        tile.getChildByName('Label').getComponent(Label).string = h + '-' + l;
    }
    /**
     * 初始化
     * @param mineInfo 初始给定的部分矿场数据
     * */
    init(): void {
        super.onInit();
        let tileArr = DataMgr.getMineInfo().tileArr;
        LogMgr.log("=----------=MineHex==init=", tileArr);
        if (tileArr && tileArr.length > 0) {
            //把起始部分矿场数据写入本地矿场数组中
            //this.updateMineInfo(tileArr);
            //显示矿场地块
            if (this.mineLayer.children.length == 0) {
                this.showFirstMineInfo();
            }
            //确定最深的坐标位置
            let mineInfo = DataMgr.getMineInfo();
            this.startPos = mineInfo.lastTileIndex;
            //保存当前最深坐标
            this._roadArr = tileUtil.searchRoadArr(this.startPos.x, this.startPos.y);
            LogMgr.warn('确定this._roadArr:', this._roadArr);
            for (let i = 0; i < this._roadArr.length; i++) {
                let tile = this._roadArr[i];
                if (tile.y > this.deepestPos.y) {
                    this.deepestPos = tile;
                }
            }

            //坐标位置
            //this.posLab.string = `Y:${mineInfo.lastTileIndex.y}  X:${mineInfo.lastTileIndex.x}`;

        }

    }


    //显示矿场地块
    showFirstMineInfo() {
        let mineInfo = DataMgr.getMineInfo();
        if (!mineInfo.tileArr) {
            mineInfo.tileArr = [];
        }
        LogMgr.log('显示矿场地块--------------');
        //显示地块
        let tileArr = mineInfo.tileArr;
        //let zeroPx = -3430, zeroPy = -2250;//-49*140/2,-50*90/2
        let zeroPx = -5145, zeroPy = -3375 - 100;
        for (let i = 0; i < 50; i++) {//行
            let delayTime = 10;
            if (i >= 13) {
                delayTime = 1000;
            } else {
                delayTime *= i;
            }
            setTimeout(() => {
                for (let j = 49; j >= 0; j--) {//列
                    if (i == 49 && j == 0) {
                        LogMgr.log('显示矿场地块mineInfo.lastTileIndex:', mineInfo.lastTileIndex, tileArr[i][j]);
                        //EventManager.emit('scrollHL', mineInfo.lastTileIndex.y, mineInfo.lastTileIndex.x, 1);
                    }
                    if (!tileArr[i]) {
                        tileArr[i] = [];
                    }
                    if (!tileArr[i][j]) {
                        tileArr[i][j] = 0;//没生成地砖的黑格子
                        //continue;
                    }
                    let tile = instantiate(this.tileCell);
                    tile.name = 'tile-' + i + '-' + j;
                    tile.parent = this.mineLayer;
                    tile.active = !!tileArr[i][j];
                    //LogMgr.log('显示矿场地块tile,行：', i, j);
                    //tile.position = v3(-1764 + j * 72, -60 - i * 72, 0);
                    //把矿工显示在最后操作的位置
                    if (tileArr[i][j] == 1) {
                        let r = Math.random();
                        if (i > 5 && r < 0.3 && !this.worker.active) {
                            mineInfo.lastTileIndex = {
                                x: j,
                                y: i
                            };
                            LogMgr.log('***显示矿场地块tile,lastTileIndex：', mineInfo.lastTileIndex);
                            this.worker.parent = this.mineLayer;
                            this.worker.position = v3(tile.x, tile.y - 20, 0);
                            this.worker.setSiblingIndex(10000);
                            this.worker.active = true;
                            if (!isValid(this.node)) { return; }
                            LogMgr.log('***显示矿场,isValid:', isValid(this.node));
                            let body = this.worker.getChildByName('body');
                            let bodySP = body.getComponent(sp.Skeleton);
                            bodySP.setSkin('Common-1');
                            bodySP.setAnimation(0, 'Idle', true);
                            this.posLab.string = `Y:${mineInfo.lastTileIndex.y}  X:${mineInfo.lastTileIndex.x}`;
                            EventManager.emit('scrollHL', mineInfo.lastTileIndex.y, mineInfo.lastTileIndex.x, 1);
                        }
                    }

                    //let px = zeroPx + j * 70 + i * 70, py = zeroPy - i * 45 + j * 45;
                    let px = zeroPx + j * 105 + i * 105, py = zeroPy - i * 67.5 + j * 67.5;
                    tile.position = v3(px, py, 0);
                    tile.setSiblingIndex(i * 100 + 51 - j);
                    //LogMgr.log('显示坐标:', i, j, ',pxy:', px, py, ',zidx:', i * 100 + j);

                    //tile.getComponent(Sprite).spriteFrame = ResManger.getTileSP('ore' + tileArr[i][j]);
                    let tileIdx = tileArr[i][j];//地砖序号=state
                    // if (tileArr[i][j] <= 6 && tileArr[i][j] >= 2) {
                    //     tileIdx = 2;
                    // }
                    let ore = tile.getChildByName('ore');
                    if (!tileIdx) {
                        tile.getComponent(Sprite).color = GFunc.getColor('BLACK');
                        ore.getComponent(Sprite).spriteFrame = null;
                    }
                    else if (tileIdx <= 1) {
                        ore.getComponent(Sprite).spriteFrame = null;
                    } else {
                        ore.getComponent(Sprite).spriteFrame = ResManger.getTileSP('ore' + tileIdx);
                    }
                    ore.getComponent(Button).clickEvents[0].customEventData = JSON.stringify({ state: tileArr[i][j], x: j, y: i });

                    //检测是否已经挖出来门了
                    this.checkIsDigOutDoor(tileIdx);
                    tile.getChildByName('Label').getComponent(Label).string = i + '-' + j;
                }
            }, delayTime);
        }
    }
    showFirstMineInfo2() {
        let mineInfo = DataMgr.getMineInfo();
        if (!mineInfo.tileArr) {
            mineInfo.tileArr = [];
        }
        LogMgr.log('showFirstMineInfo2:', mineInfo.lastTileIndex);
        //显示地块
        let tileArr = mineInfo.tileArr, isFinish = false;
        //先显示最后坐标附近的节点 行列+- 4
        for (let h = mineInfo.lastTileIndex.y - 4; h <= mineInfo.lastTileIndex.y + 4; h++) {
            for (let l = mineInfo.lastTileIndex.x + 4; l >= mineInfo.lastTileIndex.x - 4; l--) {
                if (h == mineInfo.lastTileIndex.y + 4 && l == mineInfo.lastTileIndex.x - 4) {
                    EventManager.emit('scrollHL', mineInfo.lastTileIndex.y, mineInfo.lastTileIndex.x, 1);
                }
                LogMgr.log('显示地块1:', h, l);
                if (!tileArr[h] || !tileArr[h][l]) { continue; }
                LogMgr.log('显示地块2:', h, tileArr[h], tileArr[h][l]);
                this.showNewTile(h, l, tileArr[h][l]);

                //tile.active = !!tileArr[h][l];
                //把矿工显示在最后操作的位置
                if (h == mineInfo.lastTileIndex.y && l == mineInfo.lastTileIndex.x) {
                    let tileNode = this.mineLayer.getChildByName('tile-' + h + '-' + l)
                    this.worker.parent = this.mineLayer;
                    this.worker.position = v3(tileNode.x, tileNode.y - 20, 0);
                    this.worker.active = true;
                    let body = this.worker.getChildByName('body');
                    let bodySP = body.getComponent(sp.Skeleton);
                    bodySP.setSkin('Common-1');
                    bodySP.setAnimation(0, 'Idle', true);
                }
            }
        }
    }
    //自动挖矿
    onAutoDigClick() {
        if (!this._canDig) {//正在手动挖掘中
            UIHelp.showTips('正在手动挖掘中');
            return;
        }
        this.playAutoMineAnim();
        //开始自动挖矿
        this.startAutoDig();
    }
    startAutoDig() {
        if (!this.autoTip.active) {
            UIHelp.showTips('挖掘已停止');
            return;
        }
        LogMgr.log('开始自动挖矿,深度优先:', autoMineSet.deepFirst, ',真实deepestPos:', this.deepestPos);
        if (autoMineSet.deepFirst) {//深度优先
            let nextPos = tileUtil.getDeepNextPos(this.deepestPos);
            if (!nextPos) {//找不到下一个深度可挖的坐标时就改成广度优先但是不保存设置到本地
                UIHelp.showTips('找不到下一个深度可挖的坐标');
                this.stopAutoMineAnim()
                autoMineSet.deepFirst = false;
                this.startAutoDig();
                return;
            }
            this.onAutoDig(nextPos, () => {
                //自动挖掘后的回调
                LogMgr.assert('自动挖矿后的回调,下一个坐标:', this._wIdx, this.widthDigArr[this._wIdx]);
                this.startAutoDig();
            });
        } else {//广度优先:先一次性找到当前所有路边可挖的点，没有了再搜索一次重新找
            //广度优先应该是指以当前道路为起点，向四周扩散，直到找到可挖的地块
            LogMgr.warn('lastTileIndex:', DataMgr.getMineInfo().lastTileIndex, ',this.startPos:', this.startPos)
            this.widthDigArr = tileUtil.searchDigArr(this.startPos.x, this.startPos.y);
            LogMgr.redLog('广度优先,widthDigArr:', JSON.stringify(this.widthDigArr));
            if (!this.widthDigArr || !this.widthDigArr.length) {
                let tArr = tileUtil.getTypeTileArr();//高价值的地块
                if (!tArr || !tArr.length) {
                    //没有高价值地块了，直接随机挖一个普通地块
                    tArr = tileUtil.getNormalTileArr();
                }
                this._wIdx = 0;
                let nextPos = tArr.shift();
                if (!nextPos) {//实在没有可挖的地块了，就去找通往门的道路
                    //搜索是否能到门的道路
                    let door = DataMgr.getMineInfo().door;
                    let roadToDoor = tileUtil.searchToRoad(door.x, door.y);
                    if (!roadToDoor || !roadToDoor.length) {//应该是出错了或者真的没有看到门
                        UIHelp.showTips('找不到下一个深度可挖的坐标');
                        this.stopAutoMineAnim();
                        return;
                    }
                    nextPos = door;
                    LogMgr.redLog('广度优先穷尽,门坐标赋予下一个坐标:', JSON.stringify(nextPos));
                }
                //LogMgr.redLog('广度优先穷尽,获取坐标:', JSON.stringify(nextPos));
                this.widthDigArr = tileUtil.searchToRoad(nextPos.x, nextPos.y);
                LogMgr.redLog('广度优先穷尽,获取高值地块:', JSON.stringify(tArr), ',widthDigArr:', JSON.stringify(this.widthDigArr));
                if (!this.widthDigArr || !this.widthDigArr.length) {//重试3次还是没找到，就提示没路了
                    if (this._retryCount > 3) {
                        UIHelp.showTips('找不到下一个深度可挖的坐标');
                        this.stopAutoMineAnim();
                        this._retryCount = 0;
                        return;
                    }
                }
                //去掉数组中的道路地块
                for (let i = this.widthDigArr.length - 1; i >= 0; i--) {
                    if (!this.widthDigArr[i].state || this.widthDigArr[i].state == 1) {
                        this.widthDigArr.splice(i, 1);
                    }
                }
            }
            if (this._wIdx >= this.widthDigArr.length) {
                this._wIdx = 0;
                this._retryCount++;
                LogMgr.error('-----广度优先穷尽,this._wIdx >= len');
                this.startAutoDig();
            } else {
                LogMgr.log('-----广度优先onAutoDig,this._wIdx:', this._wIdx, this.widthDigArr[this._wIdx]);
                this.onAutoDig(this.widthDigArr[this._wIdx], () => {
                    //自动挖掘后的回调
                    //LogMgr.warn('自动挖矿后的回调,下一个坐标:', this._wIdx, this.widthDigArr[this._wIdx]);
                    this.startAutoDig();
                });
                this._wIdx++;
            }
        }
    }
    //自动挖矿
    onAutoDig(nextPos: { x: number, y: number }, cb: Function = null) {
        LogMgr.warn('自动挖矿:', nextPos, ',自动修复：', autoMineSet.autoFix);
        //判断矿镐的耐久度
        let userData = DataMgr.getData(), mineInfo = DataMgr.getMineInfo();
        let state = mineInfo.tileArr[nextPos.y][nextPos.x];//地砖型号
        if ([0, 1, 6].indexOf(state) >= 0) {//0没显示的黑格子、道路、熔岩地砖
            UIHelp.showTips('不能挖掘的格子');
            LogMgr.error('自动，当前地块不能挖掘:', state);
            this._canDig = true;
            if (state <= 1) {
                let tileNode = this.mineLayer.getChildByName('tile-' + nextPos.y + '-' + nextPos.x);
                if (tileNode) {
                    tileNode.getChildByName('ore').getComponent(Sprite).spriteFrame = null;
                }
            }
            return;
        }

        //滚动卷轴到当前操作的地块
        EventManager.emit('scrollHL', nextPos.y, nextPos.x);
        //显示挖矿的动画
        this.showWorkerAnim(state, nextPos.x, nextPos.y, cb);

    }

    //手动挖矿
    handDigClick(e: Button, d: string) {
        LogMgr.warn('手动点击，this._canDig:', this._canDig, d);
        if (this.autoTip.active) {
            UIHelp.showTips('自动挖掘中');
            return;
        }
        if (!this._canDig) { return; }
        let { state, x, y } = JSON.parse(d);
        if (state == 6) {
            UIHelp.showTips('这个地块不能挖');
        }
        if ([0, 1, 6].indexOf(state) >= 0) {//0没显示的黑格子、道路、熔岩地砖
            UIHelp.showTips('手动，当前地块不能挖掘');
            LogMgr.error('手动，当前地块不能挖掘:', state);
            this._canDig = true;
            if (state <= 1) {
                let tileNode = this.mineLayer.getChildByName('tile-' + y + '-' + x);
                if (tileNode) {
                    tileNode.getChildByName('ore').getComponent(Sprite).spriteFrame = null;
                }
            }
            return;
        }
        let userData = DataMgr.getData();
        //直接判断是不是16类型的usdt宝箱
        if (state == 16) {
            EventManager.emit('showPop', { x: x, y: y }, 'mineUsdtBoxPop');
            return;
        } else if (state == 18) {//挖到门了
            UIHelp.showTips('恭喜你挖到门了,3秒后跳转');
            LogMgr.warn('过关了，重新初始化地图');
            setTimeout(() => {
                this.mineLayer.removeAllChildren();
                this.init();
            }, 3000);
            return;
        }

        //显示挖矿的动画
        let canDig = tileUtil.checkSelfCanDig(x, y);
        if (!canDig) {
            if (state != 1) {
                UIHelp.showTips('地块不能挖掘');
                LogMgr.error('当前地块不能挖掘:', state);
            }
        } else {
            this._canDig = false;
            this.showWorkerAnim(state, x, y);
        }
    }
    //显示矿工动画
    showWorkerAnim(state: number, l: number, h: number, cb: Function = null) {
        //找到要挖的地块旁边的道路，并显示一个矿镐动画
        let roadP = tileUtil.getNearRoad(h, l);
        if (!roadP) {
            LogMgr.error('showWorkerAnim,找不到要挖的地块旁边的道路:', h, l);
            this._canDig = true;
            return;
        }
        let tileNode = this.mineLayer.getChildByName('tile-' + roadP.h + '-' + roadP.l);
        if (!tileNode) {
            LogMgr.error('showWorkerAnim,找不到要挖的地块:', l, h);
            this._canDig = true;
            return;
        }
        this.worker.parent = this.mineLayer;
        this.worker.position = v3(tileNode.x, tileNode.y - 20, 0);
        this.worker.setSiblingIndex(10000);
        this.worker.active = true;
        let body = this.worker.getChildByName('body');
        LogMgr.redLog('showWorkerAnim,roadP:', JSON.stringify(roadP));
        if (roadP.fx == 'zs' || roadP.fx == 'zx') {//左边的矿石需要翻转一下
            body.scaleX = -1;
        } else {
            body.scaleX = 1;
        }

        LogMgr.warn('显示挖矿的动画,tileType:', state, l, h, ',active:', this.worker.active);
        let bodySP = body.getComponent(sp.Skeleton);
        bodySP.setSkin('Common-1');
        bodySP.setAnimation(0, 'CommonWorking', true);

        //矿镐动画倒计时，结束后把地块改成默认的0样式
        let second = 2, count = second * 10 - 1;
        let djsLab = this.worker.getChildByName('djsLab').getComponent(Label);
        djsLab.string = `${second}s`;

        this.schedule(() => {
            second -= 0.1;
            //LogMgr.log('手动挖矿:', second, typeof second);
            if (second <= 0.01) {//本质上算<=0,精度问题
                if (state >= 7 && state <= 14) {
                } else if (state == 15) {
                }
                djsLab.string = '';
                bodySP.setAnimation(0, 'Idle', true);

                this.onDig(l, h, cb);


            } else {
                djsLab.string = `${Math.floor(second * 10) / 10}s`;
            }
        }, 0.1, count, 0.01);
    }

    //挖掘一次
    onDig(l: number, h: number, cb: Function = null) {
        //LogMgr.warn('挖掘一次:', x, y);
        let mineInfo = DataMgr.getMineInfo(), oldTile = mineInfo.tileArr[h][l];
        let mineNode = this.mineLayer.getChildByName('tile-' + h + '-' + l);
        let ore = mineNode.getChildByName('ore');
        if (oldTile == 15) {//普通宝箱被挖掘了
            this.stopAutoMineAnim();
            this._canDig = true;
            //重置为道路地块
            ore.getComponent(Button).clickEvents[0].customEventData = JSON.stringify({ state: 1, x: l, y: h });
            ore.getComponent(Sprite).spriteFrame = null;
            //把矿工移动到原矿石的位置
            this.worker.parent = this.mineLayer;
            this.worker.position = v3(mineNode.x, mineNode.y - 20, 0);
            this.worker.setSiblingIndex(10000);
            //更新地块坐标信息
            this.refreshTilePos(mineInfo, l, h, null, cb);
            return;
        }

        //重置为道路地块
        ore.getComponent(Button).clickEvents[0].customEventData = JSON.stringify({ state: 1, x: l, y: h });
        ore.getComponent(Sprite).spriteFrame = null;
        //把矿工移动到原矿石的位置
        this.worker.parent = this.mineLayer;
        this.worker.position = v3(mineNode.x, mineNode.y - 20, 0);
        this.worker.setSiblingIndex(10000);
        //更新地块坐标信息
        this.refreshTilePos(mineInfo, l, h, null, cb);
        //EventManager.emit('updateTask', 5, true);

    }
    /**刷新地块坐标信息
     * @param mineInfo mineInfoModel
     * @param x number 列
     * @param y number 行
     * @param res { maps: { x: number, y: number, state: number }[], spBlockRsp: spBlockRsp }
     * @param cb Function
     */
    refreshTilePos(mineInfo: mineInfoModel, x: number, y: number, res: { maps: { x: number, y: number, state: number }[] }, cb: Function = null) {
        this._canDig = true;
        let state = mineInfo.tileArr[y][x];
        mineInfo.tileArr[y][x] = 1;
        //更新坐标位置深度
        if (y >= this.deepestPos.y) {
            this.deepestPos = { x: x, y: y };
        }
        //修改最后挖掘的坐标位置
        mineInfo.lastTileIndex = { x: x, y: y };
        this.posLab.string = `Y:${y}  X:${x}`;
        if (!res) {
            res = {
                maps: tileUtil.getResMap(y, x)
            }
        }
        //更新地图信息
        if (res.maps && res.maps.length) {
            //重设地块信息
            DataMgr.updateMineTile(res.maps);
            //刷新地块显示ui
            GFunc.sortArrayByKey(res.maps, 'x', false);
            for (let i = 0; i < res.maps.length; i++) {
                let tile = res.maps[i];
                let tileNode = this.mineLayer.getChildByName('tile-' + tile.y + '-' + tile.x);
                if (!tileNode) { continue; }
                tileNode.active = true;
                LogMgr.log('-2222---显示坐标:', tile.y, tile.x, tile.state);
                tileNode.getComponent(Sprite).color = GFunc.getColor('Normal');
                tileNode.getChildByName('Label').getComponent(Label).string = tile.y + '-' + tile.x;
                let ore = tileNode.getChildByName('ore');
                ore.getComponent(Sprite).spriteFrame = ResManger.getTileSP('ore' + tile.state);
                ore.getComponent(Button).clickEvents[0].customEventData = JSON.stringify({ state: tile.state, x: tile.x, y: tile.y });
                //如果当前是广度搜索，则把高价值地块写入当前待挖掘数组中
                //if (!autoMineSet.deepFirst) {
                if (GameConst.goodTileArr.indexOf(tile.state) >= 0) {
                    this.widthDigArr.splice(this._wIdx + 1, 0, { x: tile.x, y: tile.y, state: tile.state });
                }
                //}
                //判断是不是门，是门就显示门跳转的提示
                this.checkIsDigOutDoor(tile.state);
            }
        }
        //显示挖矿奖励
        let addValue = state < 6 ? state : state < 15 ? state * 10 : 100;
        this._gold += addValue;
        this.goldLab.string = '' + this._gold;
        LogMgr.redLog('addValue:', addValue);
        //重新搜索道路
        this.researchRoad(x, y, cb);
    }
    //重新搜索道路
    researchRoad(x: number, y: number, cb: Function) {
        let roadArr = tileUtil.searchRoadArr(x, y);
        //LogMgr.warn('搜索道路地块数组:', roadArr);
        let isNewDeepest = false;
        for (let i = 0; i < roadArr.length; i++) {
            if (roadArr[i].y > this.deepestPos.y) {//更新坐标位置深度
                this.deepestPos = { x: roadArr[i].x, y: roadArr[i].y };
                isNewDeepest = true;
            }
        }
        if (isNewDeepest && this.autoTip.active) {
            //LogMgr.warn('重新搜索道路更新坐标位置深度:', this.deepestPos);
            this.startAutoDig();
        } else {
            //延迟300毫秒再挖
            if (cb) {
                setTimeout(() => {
                    LogMgr.redLog('重新搜索道路延迟300毫秒再挖:', x, y);
                    cb();
                }, 300);
            }
        }
    }
    //按钮事件
    onBtnClick(e: Button, d: string) {
        switch (d) {
            case 'location'://定位
                let mineInfo = DataMgr.getMineInfo();
                EventManager.emit('scrollHL', mineInfo.lastTileIndex.y, mineInfo.lastTileIndex.x);
                break;
            case 'jumpToDoor'://定位到门
                let door = DataMgr.getMineInfo().door;
                EventManager.emit('scrollHL', door.y, door.x);
                this._doorTW && this._doorTW.stop();
                break;
        }
    }

    //挖掘地块后的简单奖励信息
    digAlert(iconKey: string, count: number) {
        let len = this.alertTip.parent.children.length;
        let alertTip = instantiate(this.alertTip);
        alertTip.parent = this.alertTip.parent;
        //删除多余的组件
        let uit = alertTip.getComponents(UITransform);
        if (uit.length > 1) {
            for (let i = uit.length - 1; i >= 0; i--) {
                if (uit[i].width < 500) {
                    // 先销毁组件再移除
                    uit[i].destroy();
                    alertTip.removeComponent(uit[i]);
                }
            }
        }
        alertTip.getChildByName('alertRich').getComponent(RichText).string = `${iconKey}: <color=#B8FF00>x${count}</color>`;
        alertTip.active = true;
        tween(alertTip)
            .set({ position: v3(0, 50 + (len * this.alertTip.heightUT + 20), 0) })
            .by(0.5, { position: v3(0, -50, 0) })
            .delay(1)
            .destroySelf()
            .start();
    }
    //播放自动挖掘的状态动画
    playAutoMineAnim() {
        this.autoTip.active = true;
        this.autoTip.parent.getChildByName('earnLabBg').active = false;
        this.autoTip.parent.getChildByName('stopLabBg').active = true;

    }
    //停止自动挖掘的状态动画
    stopAutoMineAnim() {
        this.autoTip.active = false;
        this.autoTip.parent.getChildByName('earnLabBg').active = true;
        this.autoTip.parent.getChildByName('stopLabBg').active = false;
    }
    //检测是否已经挖出来门了
    checkIsDigOutDoor(state: number) {
        let doorTip = this.autoTip.parent.getChildByName('doorTip');
        if (doorTip.active || state != 18) { return; }
        doorTip.active = true;
        tween(doorTip)
            .to(2, { scale: v3(1.2, 1.2, 1) })
            .to(0.5, { scale: v3(1, 1, 1) })
            .union()
            .repeatForever()
            .start();
    }
    onExitClick() {
        this.node.active = false;
    }
}