import { _decorator, Component, instantiate, isValid, Node, Prefab, resources } from 'cc';
import DataMgr from './Manager/DataMgr';
import EventManager from './Manager/EventManager';
import LogMgr from './Manager/LogMgr';
import UIHelp from './UIHelp';
import ResManger from './Manager/ResManger';
const { ccclass, property } = _decorator;

@ccclass('game')
export class game extends Component {

    @property(Node)
    pageParent: Node = null;

    protected onLoad(): void {
        DataMgr.initMineInfo();
        ResManger.init();
    }


    openMine() {
        let mineInfo = DataMgr.getMineInfo();
        this.showPage("MinePage", mineInfo.tileArr);
    }
    openYour() {
        let mineInfo = DataMgr.getMineInfo();
        this.showPage("MinePage2", mineInfo.tileArr);
    }
    showPage(pageName: string, params: any) {
        let prefab = this.pageParent.getChildByName(pageName);
        if (isValid(prefab)) {
            prefab.active = true;
            let pageCom = prefab.getComponent(pageName);
            if (isValid(pageCom) && pageCom['init']) {
                pageCom['init'](params);
                return;
            }
        }
        resources.load(`page/${pageName}`, Prefab, (error: Error, Prefab: Prefab) => {
            if (error) {
                LogMgr.error(`showPage,load page:${pageName} err:${error}`);
                return;
            }
            let prefabNode = instantiate(Prefab);
            prefabNode.parent = this.pageParent;
            let pageCom = prefabNode.getComponent(pageName);
            if (isValid(pageCom) && pageCom['init']) {
                pageCom['init'](params);
            }
        });
    }
    update(deltaTime: number) {

    }
}


