
import { _decorator, Component, tween } from 'cc';
import EventManager from '../Manager/EventManager';
import UIHelp from '../UIHelp';
import LogMgr from '../Manager/LogMgr';
import GFunc from '../GFunc';
const { ccclass, property } = _decorator;

@ccclass
export default abstract class PageBase extends Component {

    onInit(params: any = null) {
        //打开页面后，隐藏加载中页面
        //LogMgr.warn(`打开页面后，隐藏加载中页面,${this.node.name}`);
        EventManager.emit('showHideLoading', false);
        LogMgr.log(`打开页面后，onInit参数：${JSON.stringify(params)}`);
        if (params && params['noAnim']) {//不需要动画

        } else {//需要进入动画
            this.node.x = 500;
            tween(this.node)
                .to(0.1, { x: 0 })
                .start();
        }

    }
    //haoyu add
    onHideClick() {
        // LogMgr.warn(`隐藏页面按钮被点击：${this.node.name}`);
        //this.node.active = false;
        EventManager.emit('closePage', this.node.name);
        //GFunc.closePage();
    }
    // protected onEnable() {
    //     LogMgr.log('pageBase 设置电报返回按钮可用,当前页面的名字：', this.node.name);
    //     UIHelp.setBackBtnVisible(true);
    // }
}