System.register(["__unresolved_0", "cc", "__unresolved_1"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, instantiate, Pool, Singleton, TilePoolMgr, _crd;

  function _reportPossibleCrUseOfSingleton(extras) {
    _reporterNs.report("Singleton", "../plugin/Singleton", _context.meta, extras);
  }

  _export("default", void 0);

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      instantiate = _cc.instantiate;
      Pool = _cc.Pool;
    }, function (_unresolved_2) {
      Singleton = _unresolved_2.default;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "7ab45pXBlpMKoYto3MLlFJX", "TilePoolMgr", undefined);

      __checkObsolete__(['_decorator', 'Node', 'instantiate', 'Pool']);

      _export("default", TilePoolMgr = class TilePoolMgr extends (_crd && Singleton === void 0 ? (_reportPossibleCrUseOfSingleton({
        error: Error()
      }), Singleton) : Singleton) {
        /**
        * 初始化节点池
        * @param tileTemplate 地块节点模板
        * @param preloadCount 预加载数量
        */
        static init(tileTemplate, preloadCount = 10) {
          if (this._tilePool) {
            console.warn('TilePoolManager already initialized!');
            return;
          }

          this._tileCell = tileTemplate;
          this._tilePool = new Pool(() => {
            const newNode = instantiate(this._tileCell);

            this._allNodes.add(newNode);

            return newNode;
          }, 81, node => {
            node.removeFromParent();
            node.active = false;
          }); // 预加载节点

          this.preload(preloadCount);
        }
        /**
         * 预加载节点
         * @param count 预加载数量
         */


        static preload(count) {
          const nodes = [];

          for (let i = 0; i < count; i++) {
            nodes.push(this._tilePool.alloc());
          }

          nodes.forEach(node => this._tilePool.free(node));
        }
        /**
         * 从池中获取一个节点
         */


        static get() {
          if (!this._tilePool) {
            console.error('TilePoolManager not initialized!');
            return null;
          }

          let node = this._tilePool.alloc();

          node.active = true;
          return node;
        }
        /**
         * 回收节点到池中
         * @param node 要回收的节点
         */


        static put(node) {
          if (!this._tilePool) {
            console.error('TilePoolManager not initialized!');
            return;
          }

          if (!node) {
            console.warn('Trying to put null node into pool');
            return;
          }

          this._tilePool.free(node);
        }

      });

      TilePoolMgr._tilePool = null;
      TilePoolMgr._tileCell = null;
      TilePoolMgr._allNodes = new Set();

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=0973d25957d4c7760bc44b686604484e5527ec09.js.map