System.register(["__unresolved_0", "cc", "__unresolved_1", "__unresolved_2", "__unresolved_3", "__unresolved_4", "__unresolved_5"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, GameConst, Singleton, LogMgr, DataMgr, GFunc, tileUtil, _crd;

  function _reportPossibleCrUseOfGameConst(extras) {
    _reporterNs.report("GameConst", "db://assets/scripts/Config", _context.meta, extras);
  }

  function _reportPossibleCrUseOftileModel(extras) {
    _reporterNs.report("tileModel", "db://assets/scripts/Config", _context.meta, extras);
  }

  function _reportPossibleCrUseOfSingleton(extras) {
    _reporterNs.report("Singleton", "../plugin/Singleton", _context.meta, extras);
  }

  function _reportPossibleCrUseOfLogMgr(extras) {
    _reporterNs.report("LogMgr", "./LogMgr", _context.meta, extras);
  }

  function _reportPossibleCrUseOfDataMgr(extras) {
    _reporterNs.report("DataMgr", "./DataMgr", _context.meta, extras);
  }

  function _reportPossibleCrUseOfGFunc(extras) {
    _reporterNs.report("GFunc", "../GFunc", _context.meta, extras);
  }

  _export("default", void 0);

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
    }, function (_unresolved_2) {
      GameConst = _unresolved_2.GameConst;
    }, function (_unresolved_3) {
      Singleton = _unresolved_3.default;
    }, function (_unresolved_4) {
      LogMgr = _unresolved_4.default;
    }, function (_unresolved_5) {
      DataMgr = _unresolved_5.default;
    }, function (_unresolved_6) {
      GFunc = _unresolved_6.default;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "32069iDXARHgrsCw87JBh6d", "tileUtil", undefined);

      __checkObsolete__(['random']);

      _export("default", tileUtil = class tileUtil extends (_crd && Singleton === void 0 ? (_reportPossibleCrUseOfSingleton({
        error: Error()
      }), Singleton) : Singleton) {
        //根据起点坐标搜索所有的道路地块组
        static searchRoadArr(startX, startY) {
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo();
          let roadArr = []; // 初始化访问标记数组

          const visited = Array.from({
            length: mineInfo.tileArr.length
          }, () => new Array(mineInfo.tileArr[0].length).fill(false));
          this.searchRoadTile(mineInfo.tileArr, startX, startY, roadArr, visited);
          return roadArr;
        } // 递归搜索道路地块


        static searchRoadTile(tileArr, x, y, roadArr, visited) {
          // 越界检查
          if (x < 0 || y < 0 || x >= tileArr[0].length || y >= tileArr.length) return; // 已访问过或非道路地块

          if (visited[y][x] || tileArr[y][x] !== 1) return; // 标记为已访问并加入道路数组

          visited[y][x] = true;
          roadArr.push({
            x,
            y
          }); // 递归搜索四个方向

          const directions = [{
            dx: 0,
            dy: -1
          }, // 上
          {
            dx: 0,
            dy: 1
          }, // 下
          {
            dx: -1,
            dy: 0
          }, // 左
          {
            dx: 1,
            dy: 0
          } // 右
          ];
          directions.forEach(({
            dx,
            dy
          }) => {
            this.searchRoadTile(tileArr, x + dx, y + dy, roadArr, visited);
          });
        } //广度搜索：根据起点坐标搜索所有的可挖掘地块组


        static searchDigArr(startX, startY) {
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo();
          let itemArr = [];
          let roadArr = this.searchRoadArr(startX, startY); // 初始化访问标记数组

          const visited = Array.from({
            length: mineInfo.tileArr.length
          }, () => new Array(mineInfo.tileArr[0].length).fill(false));

          for (let i = 0; i < roadArr.length; i++) {
            // 递归搜索四个方向
            const directions = [{
              dx: 0,
              dy: -1
            }, // 左上
            {
              dx: 0,
              dy: 1
            }, // 右下
            {
              dx: -1,
              dy: 0
            }, // 左下
            {
              dx: 1,
              dy: 0
            } // 右上
            ];
            directions.forEach(({
              dx,
              dy
            }) => {
              //搜索高价值地块
              this.searchItemTile(mineInfo.tileArr, roadArr[i].x + dx, roadArr[i].y + dy, itemArr, visited);
            });
          } //LogMgr.log('--搜索后,itemArr:', itemArr);


          return itemArr;
        } // 递归搜索可挖掘地块


        static searchItemTile(tileArr, x, y, itemArr, visited) {
          // 越界检查
          if (x < 0 || y < 0 || x >= tileArr[0].length || y >= tileArr.length) return;
          if (visited[y][x] || (_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
            error: Error()
          }), GameConst) : GameConst).goodTileArr.indexOf(tileArr[y][x]) < 0) return; // 标记为已访问并加入道路数组

          visited[y][x] = true;
          itemArr.push({
            x,
            y,
            state: tileArr[y][x]
          }); //LogMgr.log('--递归搜索可挖掘地块,itemArr:', itemArr);
        } //获取深度优先的下一个可挖的地块


        static getDeepNextPos(pos) {
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo(); //如果是最后一行,或者在第一行之前

          if (pos.y >= 49 || pos.y < 0 || !mineInfo.tileArr[pos.y + 1]) {
            return null;
          }

          if ((_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
            error: Error()
          }), GameConst) : GameConst).mineTileArr.indexOf(mineInfo.tileArr[pos.y + 1][pos.x]) >= 0) {
            //可挖
            return {
              x: pos.x,
              y: pos.y + 1
            };
          } //下层不可挖，优先选向右挖


          let canRight = (_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
            error: Error()
          }), GameConst) : GameConst).mineTileArr.indexOf(mineInfo.tileArr[pos.y][pos.x + 1]) >= 0;

          if (!canRight) {
            let canLeft = (_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
              error: Error()
            }), GameConst) : GameConst).mineTileArr.indexOf(mineInfo.tileArr[pos.y][pos.x - 1]) >= 0;

            if (!canLeft) {
              return null;
            } else {
              return {
                x: pos.x - 1,
                y: pos.y
              };
            }
          } else {
            return {
              x: pos.x + 1,
              y: pos.y
            };
          }
        } //检查自身是否可被挖掘-上下左右有一个是道路就能挖


        static checkSelfCanDig(l, h) {
          if (l < 0 || h < 0 || l >= 50 || h >= 50) return false;
          let tileArr = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo().tileArr;

          if (!tileArr[h]) {
            return false;
          }

          (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
            error: Error()
          }), LogMgr) : LogMgr).redLog('---checkSelfCanDig:', l, h, tileArr[h][l]);

          if (!tileArr[h][l] || tileArr[h][l] == 1) {
            //不可挖
            return false;
          }

          let roadArr = []; // 递归搜索四个方向

          const directions = [//斜45度方向,矿石在路的哪个方向
          {
            dh: 0,
            dl: 1,
            fx: 'ys'
          }, // 右上
          {
            dh: -1,
            dl: 0,
            fx: 'zs'
          }, // 左上 
          {
            dh: 1,
            dl: 0,
            fx: 'yx'
          }, // 右下
          {
            dh: 0,
            dl: -1,
            fx: 'zx'
          } // 左下 
          ];

          for (let i = 0; i < directions.length; i++) {
            let dir = directions[i];
            (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
              error: Error()
            }), LogMgr) : LogMgr).warn('---dir', dir, h, ',newH:', h + dir.dh, ',tile:', tileArr[h + dir.dh]); //LogMgr.log('---state:', tileArr[h + dir.dh][l + dir.dl]);

            if (tileArr[h + dir.dh] && tileArr[h + dir.dh][l + dir.dl] === 1) {
              roadArr.push({
                x: l + dir.dl,
                y: h + dir.dh
              });
            }
          }

          (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
            error: Error()
          }), LogMgr) : LogMgr).warn('---roadArr：', roadArr);

          if (roadArr.length > 0) {
            return roadArr;
          } else {
            return false;
          }
        } //搜索某种地块的坐标数组


        static searchTileArr(tileType) {
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo();
          let itemArr = [];

          for (let i = 0; i < mineInfo.tileArr.length; i++) {
            if (!mineInfo.tileArr[i]) {
              continue;
            }

            for (let j = 0; j < mineInfo.tileArr[i].length; j++) {
              if (mineInfo.tileArr[i][j] === tileType) {
                itemArr.push({
                  x: j,
                  y: i,
                  state: tileType
                });
              }
            }
          }

          return itemArr;
        }
        /** 回溯路径 */


        static tracePath(parentMap, x, y, state) {
          const path = [];
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo();
          let current = {
            x,
            y,
            state: mineInfo.tileArr[y][x]
          };

          while (parentMap.has(`${current.x},${current.y}`)) {
            path.unshift({ ...current,
              state: current.state
            });
            current = parentMap.get(`${current.x},${current.y}`);
            (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
              error: Error()
            }), LogMgr) : LogMgr).log('---current:', current);
          }

          return path;
        }
        /*根据坐标获取该坐标到附近的道路所需要经过的地块信息（只有可挖掘的地块的信息）
        *@param x 起点x坐标
        *@param y 起点y坐标
        *@return tileModel[] 路径信息数组
        */


        static searchToRoad(x, y) {
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo();
          const queue = [];
          const visited = new Map();
          const parentMap = new Map(); // 初始化队列

          queue.push({
            x,
            y,
            path: [],
            state: mineInfo.tileArr[y][x]
          });
          visited.set(`${x},${y}`, true); // 四个方向向量

          const directions = [{
            dx: -1,
            dy: 0
          }, // 左
          {
            dx: 1,
            dy: 0
          }, // 右
          {
            dx: 0,
            dy: -1
          }, // 上
          {
            dx: 0,
            dy: 1
          } // 下
          ];

          while (queue.length > 0) {
            var _mineInfo$tileArr$cur;

            const current = queue.shift(); //LogMgr.log('当前坐标：', current.x, current.y, ',state:', current.state);
            // 找到道路地块

            if (((_mineInfo$tileArr$cur = mineInfo.tileArr[current.y]) == null ? void 0 : _mineInfo$tileArr$cur[current.x]) === 1) {
              const path = this.tracePath(parentMap, current.x, current.y, current.state); //path.length -= 1;

              path.reverse();
              (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
                error: Error()
              }), LogMgr) : LogMgr).log('已处理，找到路径：', path);
              return path;
            } // 遍历四个方向


            for (const dir of directions) {
              const newX = current.x + dir.dx;
              const newY = current.y + dir.dy;
              const key = `${newX},${newY}`; // 边界检查

              if (newX < 0 || newY < 0 || newX >= 50 || newY >= 50 || !mineInfo.tileArr[newY]) continue;
              let curState = mineInfo.tileArr[newY][newX]; //LogMgr.warn('---newX：', newX, '---newY：', newY, !visited.has(key), ',curState:', curState, ',include:', GameConst.mineTileArr.includes(curState));
              // 检查是否可挖掘且未访问过

              if (!visited.has(key)) {
                if (mineInfo.tileArr[newY][newX] == 1 || (_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
                  error: Error()
                }), GameConst) : GameConst).mineTileArr.includes(curState)) {
                  visited.set(key, true);
                  parentMap.set(key, {
                    x: current.x,
                    y: current.y,
                    state: current.state
                  }); //LogMgr.warn('---key：', { x: current.x, y: current.y, state: current.state });

                  queue.push({
                    x: newX,
                    y: newY,
                    path: [...current.path, {
                      x: newX,
                      y: newY,
                      state: curState
                    }],
                    state: curState
                  });
                }
              }
            }
          }

          return [];
        } //当广度搜索穷尽之后，就需要根据地块的序号，分类获取相应的地块数组去挖掘


        static getTypeTileArr() {
          for (let i = (_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
            error: Error()
          }), GameConst) : GameConst).goodTileArr.length - 1; i >= 0; i--) {
            let tileArr = (_crd && GFunc === void 0 ? (_reportPossibleCrUseOfGFunc({
              error: Error()
            }), GFunc) : GFunc).copyData(this.searchTileArr((_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
              error: Error()
            }), GameConst) : GameConst).goodTileArr[i]));

            if (tileArr.length > 0) {
              tileArr.forEach(element => {
                delete element.state;
              });
              return tileArr;
            }
          }

          return [];
        }
        /**获取普通地块的坐标数组
         */


        static getNormalTileArr() {
          let normalArr = [2, 3, 4, 5]; //普通地砖类型

          for (let i = normalArr.length - 1; i >= 0; i--) {
            let tileArr = (_crd && GFunc === void 0 ? (_reportPossibleCrUseOfGFunc({
              error: Error()
            }), GFunc) : GFunc).copyData(this.searchTileArr(normalArr[i]));

            if (tileArr.length > 0) {
              tileArr.forEach(element => {
                delete element.state;
              });
              return tileArr;
            }
          }

          return [];
        }
        /**获取当前地块周围最近的道路
         * @param h 行
         * @param l 列
         */


        static getNearRoad(h, l) {
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo(); // 四个方向向量

          const directions = [//斜45度方向,矿石在路的哪个方向
          {
            dh: 0,
            dl: -1,
            fx: 'ys'
          }, // 右上
          {
            dh: 1,
            dl: 0,
            fx: 'zs'
          }, // 左上 
          {
            dh: -1,
            dl: 0,
            fx: 'ys'
          }, // 右下
          {
            dh: 0,
            dl: 1,
            fx: 'zx'
          } // 左下 
          ];

          for (const dir of directions) {
            const newH = h + dir.dh;
            const newL = l + dir.dl; // 边界检查

            if (newH < 0 || newL < 0 || newH >= 50 || newL >= 50 || !mineInfo.tileArr[newH]) {
              continue;
            }

            (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
              error: Error()
            }), LogMgr) : LogMgr).log('+++newH：', newH, '---newL：', newL);
            (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
              error: Error()
            }), LogMgr) : LogMgr).log('state:', mineInfo.tileArr[newH][newL]);

            if (mineInfo.tileArr[newH][newL] == 1) {
              return {
                h: newH,
                l: newL,
                fx: dir.fx
              };
            }
          }

          return null;
        }
        /**
         * 搜索最优质的宝箱哇卷路径
         */


        static searchBoxTilePath() {
          let boxArr = this.searchTileArr(15);
          let minLength = 99,
              bestPath = [],
              bestBox = null;

          for (let i = 0; i < boxArr.length; i++) {
            let roadArr = this.searchToRoad(boxArr[i].x, boxArr[i].y);

            if (roadArr && roadArr.length < minLength) {
              minLength = roadArr.length;
              bestPath = roadArr;
              bestBox = boxArr[i];
            }
          }

          (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
            error: Error()
          }), LogMgr) : LogMgr).warn('---bestPath：', (_crd && GFunc === void 0 ? (_reportPossibleCrUseOfGFunc({
            error: Error()
          }), GFunc) : GFunc).copyData(bestPath));

          if (bestPath.length == 0) {
            return [];
          }

          bestPath.length -= 1;
          bestPath.reverse();
          bestPath.push(bestBox);
          return bestPath;
        }
        /**
         * 模拟打开新的地块，随机地块类型
         * @param h 
         * @param l 
         */


        static getResMap(h, l) {
          let mapArr = [];
          let mineInfo = (_crd && DataMgr === void 0 ? (_reportPossibleCrUseOfDataMgr({
            error: Error()
          }), DataMgr) : DataMgr).getMineInfo();

          for (let i = h - 2; i <= h + 2; i++) {
            if (i < 0 || i >= 50 || !mineInfo.tileArr[i]) {
              continue;
            }

            for (let j = l - 2; j <= l + 2; j++) {
              if (j < 0 || j >= 50 || mineInfo.tileArr[i][j]) {
                continue;
              }

              mineInfo.tileArr[i][j] = Math.floor(Math.random() * 18);
              mapArr.push({
                x: j,
                y: i,
                state: mineInfo.tileArr[i][j]
              });
            }
          }

          return mapArr;
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=c5de79d81ceb9659c1cb470f9ae0fe3b263b94fc.js.map