System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _cc, _crd, cc, PI180, PI360;

  return {
    setters: [function (_cc2) {
      _cclegacy = _cc2.cclegacy;
      __checkObsolete__ = _cc2.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc2.__checkObsoleteInNamespace__;
      _cc = _cc2;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "86df8aNXpFBxpyBUofDi+zA", "NodeEx", undefined);

      cc = __checkObsoleteInNamespace__(_cc);
      PI180 = Math.PI / 180;
      PI360 = Math.PI / 360;
      Object.defineProperties(cc.Node.prototype, {
        ['x']: {
          get: function () {
            return this._lpos['x'];
          },
          set: function (val) {
            this._lpos['x'] = val;
            this.invalidateChildren(cc.TransformBit.POSITION);
          }
        },
        y: {
          get: function () {
            return this._lpos.y;
          },
          set: function (val) {
            this._lpos.y = val;
            this.invalidateChildren(cc.TransformBit.POSITION);
          }
        },
        z: {
          get: function () {
            return this._lpos.z;
          },
          set: function (val) {
            this._lpos.z = val;
            this.invalidateChildren(cc.TransformBit.POSITION);
          }
        },
        angleX: {
          get: function () {
            return this._euler.x;
          },
          set: function (val) {
            this._euler.x = val;
            val *= PI360;
            this._lrot.x = Math.sin(val);
            this._lrot.w = Math.cos(val);
            this.invalidateChildren(cc.TransformBit.ROTATION);
          }
        },
        angleY: {
          get: function () {
            return this._euler.y;
          },
          set: function (val) {
            this._euler.y = val;
            val *= PI360;
            this._lrot.y = Math.sin(val);
            this._lrot.w = Math.cos(val);
            this.invalidateChildren(cc.TransformBit.ROTATION);
          }
        },
        angleZ: {
          get: function () {
            return this._euler.z;
          },
          set: function (val) {
            this._euler.z = val;
            val *= PI360;
            this._lrot.z = Math.sin(val);
            this._lrot.w = Math.cos(val);
            this.invalidateChildren(cc.TransformBit.ROTATION);
          }
        },
        scaleX: {
          get: function () {
            return this._lscale.x;
          },
          set: function (val) {
            this._lscale.x = val;
            this.invalidateChildren(cc.TransformBit.SCALE);
          }
        },
        scaleY: {
          get: function () {
            return this._lscale.y;
          },
          set: function (val) {
            this._lscale.y = val;
            this.invalidateChildren(cc.TransformBit.SCALE);
          }
        },
        scaleZ: {
          get: function () {
            return this._lscale.z;
          },
          set: function (val) {
            this._lscale.z = val;
            this.invalidateChildren(cc.TransformBit.SCALE);
          }
        },
        widthUT: {
          get: function () {
            var _this$_uiProps, _this$_uiProps$_uiTra;

            let ut = (_this$_uiProps$_uiTra = (_this$_uiProps = this._uiProps)._uiTransformComp) != null ? _this$_uiProps$_uiTra : _this$_uiProps._uiTransformComp = this.addComponent(cc.UITransform);
            return ut._contentSize.width;
          },
          set: function (val) {
            var _this$_uiProps2, _this$_uiProps2$_uiTr;

            let ut = (_this$_uiProps2$_uiTr = (_this$_uiProps2 = this._uiProps)._uiTransformComp) != null ? _this$_uiProps2$_uiTr : _this$_uiProps2._uiTransformComp = this.addComponent(cc.UITransform);
            if (ut._contentSize.width === val) return;
            ut._contentSize.width = val;

            ut._markRenderDataDirty();
          }
        },
        heightUT: {
          get: function () {
            var _this$_uiProps3, _this$_uiProps3$_uiTr;

            let ut = (_this$_uiProps3$_uiTr = (_this$_uiProps3 = this._uiProps)._uiTransformComp) != null ? _this$_uiProps3$_uiTr : _this$_uiProps3._uiTransformComp = this.addComponent(cc.UITransform);
            return ut._contentSize.height;
          },
          set: function (val) {
            var _this$_uiProps4, _this$_uiProps4$_uiTr;

            let ut = (_this$_uiProps4$_uiTr = (_this$_uiProps4 = this._uiProps)._uiTransformComp) != null ? _this$_uiProps4$_uiTr : _this$_uiProps4._uiTransformComp = this.addComponent(cc.UITransform);
            if (ut._contentSize.height === val) return;
            ut._contentSize.height = val;

            ut._markRenderDataDirty();
          }
        },
        anchorXUT: {
          get: function () {
            var _this$_uiProps5, _this$_uiProps5$_uiTr;

            let ut = (_this$_uiProps5$_uiTr = (_this$_uiProps5 = this._uiProps)._uiTransformComp) != null ? _this$_uiProps5$_uiTr : _this$_uiProps5._uiTransformComp = this.addComponent(cc.UITransform);
            return ut._anchorPoint.x;
          },
          set: function (val) {
            var _this$_uiProps6, _this$_uiProps6$_uiTr;

            let ut = (_this$_uiProps6$_uiTr = (_this$_uiProps6 = this._uiProps)._uiTransformComp) != null ? _this$_uiProps6$_uiTr : _this$_uiProps6._uiTransformComp = this.addComponent(cc.UITransform);
            if (ut._anchorPoint.x === val) return;
            ut._anchorPoint.x = val;

            ut._markRenderDataDirty();
          }
        },
        anchorYUT: {
          get: function () {
            var _this$_uiProps7, _this$_uiProps7$_uiTr;

            let ut = (_this$_uiProps7$_uiTr = (_this$_uiProps7 = this._uiProps)._uiTransformComp) != null ? _this$_uiProps7$_uiTr : _this$_uiProps7._uiTransformComp = this.addComponent(cc.UITransform);
            return ut._anchorPoint.y;
          },
          set: function (val) {
            var _this$_uiProps8, _this$_uiProps8$_uiTr;

            let ut = (_this$_uiProps8$_uiTr = (_this$_uiProps8 = this._uiProps)._uiTransformComp) != null ? _this$_uiProps8$_uiTr : _this$_uiProps8._uiTransformComp = this.addComponent(cc.UITransform);
            if (ut._anchorPoint.y === val) return;
            ut._anchorPoint.y = val;

            ut._markRenderDataDirty();
          }
        },
        color: {
          get: function () {
            var _this$_uiProps9, _this$_uiProps9$_uiCo;

            let ur = (_this$_uiProps9$_uiCo = (_this$_uiProps9 = this._uiProps)._uiComp) != null ? _this$_uiProps9$_uiCo : _this$_uiProps9._uiComp = this.addComponent(cc.UIRenderer);
            return ur._color;
          },
          set: function (val) {
            var _this$_uiProps10, _this$_uiProps10$_uiC;

            let ur = (_this$_uiProps10$_uiC = (_this$_uiProps10 = this._uiProps)._uiComp) != null ? _this$_uiProps10$_uiC : _this$_uiProps10._uiComp = this.addComponent(cc.UIRenderer);
            if (ur._color.equals(val)) return;
            ur._color._val = (val.a << 24 >>> 0) + (val.b << 16) + (val.g << 8) + (val.r | 0);

            ur._updateColor();
          }
        },
        findChildren: {
          value: function (name, isStartWith = false) {
            let ret = [];
            let find = isStartWith ? node => {
              for (let i = 0, len = node.children.length, childrens = node.children; i < len; ++i) {
                let children = childrens[i];
                children.name.startsWith(name) && ret.push(children);
                find(children);
              }
            } : node => {
              for (let i = 0, len = node.children.length, childrens = node.children; i < len; ++i) {
                let children = childrens[i];
                children.name === name && ret.push(children);
                find(children);
              }
            };
            find(this);
            return ret;
          }
        },
        setAnchor: {
          value: function (point, y) {
            var _this$_uiProps$_uiTra2;

            let ut = (_this$_uiProps$_uiTra2 = this._uiProps._uiTransformComp) != null ? _this$_uiProps$_uiTra2 : this.addComponent(cc.UITransform);
            let anchor = ut._anchorPoint;

            if (typeof point === 'object') {
              if (point.x === anchor.x && point.y === anchor.y) return;
            } else {
              if (point === anchor.x && y === anchor.y) return;
              point = new cc.Vec2(point, y);
            }

            let radian = this.angle * PI180;
            let cos = Math.cos(radian);
            let sin = Math.sin(radian);
            let dx = ut._contentSize.width * this._lscale.x * (point.x - anchor.x);
            let dy = ut._contentSize.height * this._lscale.y * (point.y - anchor.y);
            this._lpos.x = this._lpos.x + dx * cos - dy * sin;
            this._lpos.y = this._lpos.y + dx * sin + dy * cos;
            this.invalidateChildren(cc.TransformBit.POSITION);
            ut._anchorPoint = point;
            this.emit(cc.NodeEventType.ANCHOR_CHANGED, point);

            ut._markRenderDataDirty();
          }
        },
        setColor: {
          value: function (time, color) {
            let tweenColor = (tag, time, color) => {
              return cc.tween(tag).to(time, {
                color: {
                  value: color,
                  progress: (start, end, current, t) => {
                    let sr = start & 0x000000ff;
                    let sg = (start & 0x0000ff00) >> 8;
                    let sb = (start & 0x00ff0000) >> 16;
                    let sa = (start & 0xff000000) >>> 24;
                    let er = end & 0x000000ff;
                    let eg = (end & 0x0000ff00) >> 8;
                    let eb = (end & 0x00ff0000) >> 16;
                    let ea = (start & 0xff000000) >>> 24;
                    let r = sr + (er - sr) * t;
                    let g = sg + (eg - sg) * t;
                    let b = sb + (eb - sb) * t;
                    let a = sa + (ea - sa) * t;
                    return (a << 24 >>> 0) + (b << 16) + (g << 8) + r;
                  }
                }
              });
            };

            let ur = this._uiProps._uiComp;

            if (ur) {
              var _this$colorTween;

              (_this$colorTween = this['colorTween']) == null || _this$colorTween.stop();

              if (color === undefined) {
                if (this['defaultColor'] !== undefined) {
                  this['colorTween'] = tweenColor(ur, time, this['defaultColor']).call(() => {
                    delete this['defaultColor'];
                    delete this['colorTween'];
                  }).start();
                }
              } else {
                var _defaultColor, _this$_defaultColor;

                let defaultColor = (_this$_defaultColor = this[_defaultColor = 'defaultColor']) != null ? _this$_defaultColor : this[_defaultColor] = ur.color.clone();
                let changeColor = cc.color(defaultColor.r * color.r / 255, defaultColor.g * color.g / 255, defaultColor.b * color.b / 255, defaultColor.a * color.a / 255);
                time === 0 ? ur.color = changeColor : this['colorTween'] = tweenColor(ur, time, changeColor).start();
              }
            }

            for (let children = this.children, i = children.length - 1; i > -1; children[i--].setColor(time, color));
          }
        },
        shake: {
          value: function (repeat, amplitude, frequency) {
            var _this$frequency;

            if (this['amplitude']) {
              this._lpos.subtract(this['amplitude']);

              this.invalidateChildren(cc.TransformBit.POSITION);
              clearInterval(this['shakeHandle']);
            }

            if (repeat === 0) {
              delete this['shakeHandle'];
              delete this['amplitude'];
              delete this['frequency'];
              return;
            }

            repeat = ~~repeat;

            if (amplitude) {
              this['amplitude'] = amplitude;
            } else if (this['amplitude']) {
              this['amplitude'].negative();
            } else return;

            this['frequency'] = frequency !== undefined ? Math.max(frequency, 0.01) : (_this$frequency = this['frequency']) != null ? _this$frequency : 0.05;

            this._lpos.add(this['amplitude']);

            this.invalidateChildren(cc.TransformBit.POSITION);
            let step = cc.v3();

            if (repeat > 0) {
              repeat = Math.max(repeat - 1, 1);
              step = cc.v3(-this['amplitude'].x / repeat, -this['amplitude'].y / repeat, -this['amplitude'].z / repeat);
            }

            this['shakeHandle'] = setInterval(() => {
              this._lpos.subtract(this['amplitude']);

              this.invalidateChildren(cc.TransformBit.POSITION);

              if (--repeat === 0) {
                clearInterval(this['shakeHandle']);
                delete this['shakeHandle'];
                delete this['amplitude'];
                delete this['frequency'];
                return;
              }

              step.negative();
              this['amplitude'].negative().add(step);

              this._lpos.add(this['amplitude']);

              this.invalidateChildren(cc.TransformBit.POSITION);
            }, this['frequency'] * 1000);
          }
        },
        destroyRealtime: {
          value: function () {
            if (!cc.isValid(this, true)) return;
            clearInterval(this['shakeHandle']);
            this.destroy();
            this.removeFromParent();
          }
        },
        destroyAllChildrenRealtime: {
          value: function () {
            if (!cc.isValid(this, true)) return;

            for (let children = this.children, i = children.length - 1; i > -1; children[i--].destroyRealtime());
          }
        }
      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=de74cf508f6b4540bf6fd5f71a3c197b56594975.js.map