System.register(["__unresolved_0", "cc", "__unresolved_1", "__unresolved_2", "__unresolved_3"], function (_export, _context) {
  "use strict";

  var _reporterNs, _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, Node, Prefab, UITransform, director, resources, GameConst, EventManager, LogMgr, UIHelp, _crd;

  function _reportPossibleCrUseOfGameConst(extras) {
    _reporterNs.report("GameConst", "./Config", _context.meta, extras);
  }

  function _reportPossibleCrUseOfEventManager(extras) {
    _reporterNs.report("EventManager", "./Manager/EventManager", _context.meta, extras);
  }

  function _reportPossibleCrUseOfLogMgr(extras) {
    _reporterNs.report("LogMgr", "./Manager/LogMgr", _context.meta, extras);
  }

  _export("default", void 0);

  return {
    setters: [function (_unresolved_) {
      _reporterNs = _unresolved_;
    }, function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      Node = _cc.Node;
      Prefab = _cc.Prefab;
      UITransform = _cc.UITransform;
      director = _cc.director;
      resources = _cc.resources;
    }, function (_unresolved_2) {
      GameConst = _unresolved_2.GameConst;
    }, function (_unresolved_3) {
      EventManager = _unresolved_3.default;
    }, function (_unresolved_4) {
      LogMgr = _unresolved_4.default;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "8e8c4XmyEtLA4p2azqN/eRr", "UIHelp", undefined);
      /**
       * 这是一个UI工具类
       */


      __checkObsolete__(['ImageAsset', 'Node', 'Prefab', 'Sprite', 'SpriteFrame', 'Texture2D', 'UITransform', 'Vec3', 'assetManager', 'director', 'resources', 'v3']);

      _export("default", UIHelp = class UIHelp {
        static log() {
          if ((_crd && GameConst === void 0 ? (_reportPossibleCrUseOfGameConst({
            error: Error()
          }), GameConst) : GameConst).isDebug) {
            for (var _len = arguments.length, data = new Array(_len), _key = 0; _key < _len; _key++) {
              data[_key] = arguments[_key];
            }

            (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
              error: Error()
            }), LogMgr) : LogMgr).log(data);
          }
        }

        static seek(target, name) {
          var t = null;

          var func = (target, name) => {
            for (var i = 0, j = target.children, len = j.length; i < len; i += 1) {
              var node = j[i];

              if (t) {
                return t;
              } else if (node.name === name) {
                return j[i];
              } else if (node.children.length > 0) {
                t = func(node, name);
              }
            }

            return t;
          };

          return func(target, name);
        }
        /**
         * 根据名称在指定节点下查找子节点，并可执行回调函数和红点逻辑
         * @param parentNode 父节点，用于查找子节点的起点
         * @param widgetName 子节点名称，指定要查找的子节点的名称
         * @param callback 回调函数，在触摸结束事件触发时执行，可选
         * @param target 额外的参数，传递给回调函数
         * @returns 返回找到的子节点
         */


        static seekWidgetByName(parentNode, widgetName, callback) {
          for (var _len2 = arguments.length, target = new Array(_len2 > 3 ? _len2 - 3 : 0), _key2 = 3; _key2 < _len2; _key2++) {
            target[_key2 - 3] = arguments[_key2];
          }

          // 根据名称在父节点中查找指定的子节点
          var widget = this.seek(parentNode, widgetName); // 如果找到了子节点并且有回调函数，则继续以下逻辑

          if (callback && widget) {
            // 移除子节点的触摸结束事件监听器，以更新或重新绑定事件
            widget.off(Node.EventType.TOUCH_END); // 绑定新的触摸结束事件监听器，触发时执行回调函数

            widget.on(Node.EventType.TOUCH_END, event => {
              callback && callback(event, target);
            }); // 红点功能实现
            // 在找到的子节点下查找名为"redPoint"的子节点，用于显示红点提示

            var redPoint = UIHelp.seekWidgetByName(widget, "redPoint");

            if (redPoint) {
              // 如果找到了红点节点，则将其赋值给widget的redPoint属性
              widget.redPoint = redPoint;
            }
          } // 返回找到的子节点


          return widget;
        }
        /**
         * 获取当前日期和时间的格式化字符串
         * 此方法用于生成一个包含当前年、月、日、时、分、秒的日期时间字符串
         * 格式为：YYYY-MM-DD HH:mm:ss
         * @returns {string} 当前日期和时间的格式化字符串
         */


        static getNowDate() {
          var date = new Date(); // 创建当前日期时间的对象

          var month = date.getMonth() + 1; // 获取当前月份，加1是因为JavaScript的getMonth()方法返回的是0-11

          var strDate = date.getDate(); // 获取当前日期
          // 确保月份和日期都是两位数，如果不是，则在其前添加"0"

          if (month <= 9) {
            month = "0" + month;
          }

          if (strDate <= 9) {
            strDate = "0" + strDate;
          } // 拼接年、月、日和时间，生成最终的字符串格式


          return date.getFullYear() + "-" + month + "-" + strDate + " " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
        }

        static loadPrefab(path, call) {
          resources.load(path, Prefab, (err, prefab) => {
            if (err) {
              (_crd && LogMgr === void 0 ? (_reportPossibleCrUseOfLogMgr({
                error: Error()
              }), LogMgr) : LogMgr).warn(err.message); // UIHelp.showTips("磁盘空间不足，请清理后重启游戏");

              return;
            }

            call && call(prefab);
          });
        }

        static getCurrentScene() {
          return director.getScene();
        }
        /**
         * 将坐标转换为世界坐标
         * @param item 
         * @returns 
         */


        static toWorldPosition(item) {
          // LogMgr.log(item.worldPosition, item.parent.getComponent(UITransform).convertToWorldSpaceAR(item.position))
          // return item.worldPosition;
          return item.parent.getComponent(UITransform).convertToWorldSpaceAR(item.position);
        }
        /**
         * 将世界坐标转换到节点坐标
         * @param item 
         * @param worldPosition 
         * @returns 
         */


        static toNodeSpacePosition(item, worldPosition) {
          return item.parent.getComponent(UITransform).convertToNodeSpaceAR(worldPosition);
        }

        static setIndex(node, index) {
          node.setSiblingIndex(index);
        }

        static getRandomInt(min, max) {
          // Math.random() 生成 0 到 1 之间的随机浮点数，不包括 1
          // Math.floor() 向下取整
          return Math.floor(Math.random() * (max - min + 1)) + min;
        }
        /**
         * 随机一个枚举值
         * @param anEnum 
         * @returns 
         */


        static getRandomEnum(anEnum) {
          var enumValues = Object.keys(anEnum).filter(key => isNaN(Number(key))) // 只获取字符串键（去除反向映射）
          .map(key => anEnum[key]); // 将这些键映射为枚举值

          var randomIndex = Math.floor(Math.random() * enumValues.length);
          return enumValues[randomIndex];
        }
        /**
         * 显示提示信息的静态方法
         * 这个方法首先检查Telegram WebApp环境是否提供了showAlert方法，如果提供了，则使用showAlert方法显示信息；
         * 否则，退回到使用浏览器的alert方法显示信息
         * 此方法确保了在不同的环境下都能够以适当的方式向用户显示提示信息
         * 
         * @param message 要显示给用户的消息文本
         */


        static showTips(message, durationTime) {
          if (durationTime === void 0) {
            durationTime = 1;
          }

          (_crd && EventManager === void 0 ? (_reportPossibleCrUseOfEventManager({
            error: Error()
          }), EventManager) : EventManager).emit('showAlert', message, durationTime);
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=b76333cb3ef7839d8b2196ccfd4cd3f1285b68fa.js.map