
import { _decorator, Component, Node, Asset, Sprite, instantiate, SpriteFrame, Prefab, loader } from 'cc';
import { ResBase } from './ResBase';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends ResBase {

    @property({ type: Node })
    testNode: Node | null = null;

    onAdd() {
        this.loadRes('2DPrefab/mainView/mainView1', Prefab, (e, p) => {
            let item = instantiate(p);
            item.name = 'item';
            item.parent = this.testNode
        })
    }
    onRelease() {
        this.testNode.getChildByName('item')?.destroy();
        // this.testNode?.removeAllChildren();
        this.releaseAutoRes();
    }
    onDump() {
        console.log(loader.getResCount())
    }

}


