import { _decorator, Component, Node, EventTouch, UITransform, v3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('scene')
export class scene extends Component {

    @property({
        type: Node,
        displayName: "移动物体"
    })
    moveItem: Node = null;

    start() {
        this.node.on(Node.EventType.TOUCH_MOVE, (event: EventTouch) => {
            let worldPos = event.getUILocation();
            let localPos = this.moveItem.parent.getComponent(UITransform).convertToNodeSpaceAR(v3(worldPos.x, worldPos.y, 0));
            this.moveItem.setPosition(localPos);
        }, this);
    }

    update(deltaTime: number) {

    }

}

