
import { _decorator, Component, Node, Label, MeshRenderer } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Label3D
 * DateTime = Sat Mar 19 2022 20:40:52 GMT+0800 (中国标准时间)
 * Author = 咕嘟喵
 * FileBasename = Label3D.ts
 * FileBasenameNoExtension = Label3D
 * URL = db://assets/Label3D.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */
 
@ccclass('Label3D')
export class Label3D extends Component {
    @property(Label)
    private lab: Label = null;
        
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        // [3]
        this.scheduleOnce(() => { 
            let material = this.node.getComponent(MeshRenderer).material;
            let labTexture = (this.lab.spriteFrame as any).texture;
            this.node.getComponent(MeshRenderer).material.setProperty('mainTexture',labTexture);
        },3);
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
