// Generated by CoffeeScript 1.9.0
(function() {
  var Edge, HeapSnapshot, MAX_STRING_LEN_TO_PRINT, Node, RETAINED_SIZE_EDGES, fillObjectType, fs, ld, parseEdges, parseNodes, parseObjects, parseSnapshot;

  fs = require('fs');

  ld = require('lodash');

  parseObjects = function(snapshot, values, fields, constructor) {
    var answer, fieldIndex, obj, valueIndex;
    answer = [];
    valueIndex = 0;
    while (valueIndex < values.length) {
      fieldIndex = 0;
      obj = {};
      while (fieldIndex < fields.length) {
        obj[fields[fieldIndex]] = values[valueIndex];
        fieldIndex++;
        valueIndex++;
      }
      if (constructor != null) {
        answer.push(new constructor(snapshot, obj));
      } else {
        answer.push(obj);
      }
    }
    return answer;
  };

  fillObjectType = function(name, object, types) {
    if (object.type != null) {
      if (object.type > types.length) {
        throw new Error("Type " + object.type + " out of range (" + types.length + ") for " + name + ".");
      }
      object.type = types[object.type];
    }
    return object;
  };

  parseNodes = function(snapshot) {
    var nodes;
    return nodes = parseObjects(snapshot, snapshot.nodes, snapshot.snapshot.meta.node_fields, Node);
  };

  parseEdges = function(snapshot) {
    var edges;
    return edges = parseObjects(snapshot, snapshot.edges, snapshot.snapshot.meta.edge_fields, Edge);
  };

  parseSnapshot = function(snapshot, options) {
    var edge, edgeIndex, edges, node, nodeEdgeIndex, nodeIndex, nodes, toNode, _i, _j, _len, _len1;
    if (options == null) {
      options = {};
    }
    if (typeof options.reporter === "function") {
      options.reporter({
        message: "Parsing nodes"
      });
    }
    nodes = parseNodes(snapshot);
    if (typeof options.reporter === "function") {
      options.reporter({
        message: "Parsing edges"
      });
    }
    edges = parseEdges(snapshot);
    if (typeof options.reporter === "function") {
      options.reporter({
        message: "Connecting edges to destination nodes"
      });
    }
    for (_i = 0, _len = edges.length; _i < _len; _i++) {
      edge = edges[_i];
      toNode = nodes[edge.toNodeIndex];
      edge.toNode = toNode;
      toNode.referrers.push(edge);
    }
    if (typeof options.reporter === "function") {
      options.reporter({
        message: "Connecting edges to origin nodes"
      });
    }
    edgeIndex = 0;
    for (nodeIndex = _j = 0, _len1 = nodes.length; _j < _len1; nodeIndex = ++_j) {
      node = nodes[nodeIndex];
      nodeEdgeIndex = 0;
      while (nodeEdgeIndex < node.edge_count) {
        if (edgeIndex >= edges.length) {
          throw new Error("Ran out of edges!");
        }
        edge = edges[edgeIndex];
        node.references.push(edge);
        edge.fromNode = node;
        edgeIndex++;
        nodeEdgeIndex++;
      }
    }
    return {
      nodes: nodes,
      edges: edges
    };
  };

  MAX_STRING_LEN_TO_PRINT = 40;

  RETAINED_SIZE_EDGES = ['context', 'element', 'property', 'hidden'];

  Node = (function() {
    function Node(snapshot, json) {
      var key, value;
      for (key in json) {
        value = json[key];
        this[key] = value;
      }
      if (this.name != null) {
        this.name = snapshot.strings[this.name];
      }
      fillObjectType("node", this, snapshot.snapshot.meta.node_types[0]);
      this.references = [];
      this.referrers = [];
    }

    Node.prototype.toShortString = function() {
      var name;
      name = this.name;
      if (this.type === 'string') {
        name = name.replace(/\n/g, '\\n');
        if (name.length > MAX_STRING_LEN_TO_PRINT) {
          name = name.slice(0, MAX_STRING_LEN_TO_PRINT - 3) + "...";
        }
        name = "\"" + name + "\"";
      } else if (name.length > MAX_STRING_LEN_TO_PRINT + 2) {
        name = '';
      }
      return "(" + this.type + ") " + name + " @" + this.id;
    };

    Node.prototype.toString = function() {
      return (this.toShortString()) + "\nself-size: " + this.self_size + " bytes\nreferences:\n" + (this.references.map(function(r) {
        var _ref, _ref1;
        return "    (" + r.type + ") " + r.name_or_index + ": " + ((_ref = (_ref1 = r.toNode) != null ? _ref1.toShortString() : void 0) != null ? _ref : 'missing');
      }).join("\n")) + "\nreferrers:\n" + (this.referrers.map(function(r) {
        var _ref, _ref1;
        return "    (" + r.type + ") " + r.name_or_index + ": from " + ((_ref = (_ref1 = r.fromNode) != null ? _ref1.toShortString() : void 0) != null ? _ref : 'missing');
      }).join("\n"));
    };

    Node.prototype.getProperty = function(name, edgeType) {
      var ref, _i, _len, _ref;
      if (edgeType == null) {
        edgeType = 'property';
      }
      _ref = this.references;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        ref = _ref[_i];
        if (ref.type === edgeType && ref.name === name) {
          return ref.toNode;
        }
      }
      return null;
    };

    return Node;

  })();

  Edge = (function() {
    function Edge(snapshot, json) {
      var key, nodeFields, value;
      for (key in json) {
        value = json[key];
        if (key !== 'to_node') {
          this[key] = value;
        }
      }
      fillObjectType("edge", this, snapshot.snapshot.meta.edge_types[0]);
      if (this.name_or_index != null) {
        this.name_or_index = snapshot.strings[this.name_or_index];
      }
      this.name = this.name_or_index;
      nodeFields = snapshot.snapshot.meta.node_fields;
      this.toNodeIndex = json.to_node / nodeFields.length;
    }

    Edge.prototype.toString = function() {
      var _ref, _ref1;
      return this.name_or_index + " (" + this.type + ") - from " + ((_ref = this.fromNode) != null ? _ref.toShortString() : void 0) + " to " + ((_ref1 = this.toNode) != null ? _ref1.toShortString() : void 0);
    };

    return Edge;

  })();

  HeapSnapshot = (function() {
    function HeapSnapshot(snapshot, options) {
      var _ref;
      _ref = parseSnapshot(snapshot, options), this.nodes = _ref.nodes, this.edges = _ref.edges;
      this.nodesById = ld.indexBy(this.nodes, 'id');
    }

    return HeapSnapshot;

  })();

  exports.parse = function(snapshot, options) {
    if (ld.isString(snapshot)) {
      snapshot = JSON.parse(snapshot);
    }
    return new HeapSnapshot(snapshot, options);
  };

}).call(this);
