import { RelativeTime, TimeStamp, Duration, ServerDuration, SLS_ClientBaseOptions, IgnoreAllTypes, MatchTraceRequestTypes, IEnableTrackRequestBody, NotifyData, OTTrace, SubscribeCallback, SubscribeDep, SLS_MUTABLE_OPTION, IBasePlugin, ClientRef, BasePublicApi, UnknownFunc } from '@aliyun-sls/web-types';

declare function defineGlobalValue<Global, Name extends keyof Global>(global: Global, name: string, api: Global[Name]): void;
declare function defineGlobal<Global, Name extends keyof Global>(global: Global, name: string, api: Global[Name], hook?: (callback: () => void) => void): void;

interface Subscription {
    unsubscribe: () => void;
}
declare class Observable<T> {
    private onFirstSubscribe?;
    private observers;
    private onLastUnsubscribe?;
    constructor(onFirstSubscribe?: (() => (() => void) | void) | undefined);
    subscribe(f: (data: T) => void): Subscription;
    notify(data: T): void;
}

declare function callMonitored<T extends (...args: any[]) => any>(fn: T, context: ThisParameterType<T>, args: Parameters<T>): ReturnType<T> | undefined;
declare function callMonitored<T extends (this: void) => any>(fn: T): ReturnType<T> | undefined;
declare function monitor<T extends (...args: any[]) => any>(fn: T): T;
declare function getConsoleLogStatus(): boolean;
declare function debugLog(...args: any): void;

declare function relativeToClocks(relative: RelativeTime): {
    relative: RelativeTime;
    timeStamp: TimeStamp;
};
declare function getCorrectedTimeStamp(relativeTime: RelativeTime): TimeStamp;
declare function currentDrift(): number;
declare function toServerDuration(duration: Duration): ServerDuration;
declare function toServerDuration(duration: Duration | undefined): ServerDuration | undefined;
/**
 * get timestamp in us
 * @returns
 */
declare function timeStampNow(): TimeStamp;
declare function relativeNow(): RelativeTime;
declare function clocksNow(): {
    relative: RelativeTime;
    timeStamp: TimeStamp;
};
declare function clocksOrigin(): {
    relative: RelativeTime;
    timeStamp: TimeStamp;
};
declare function elapsed(start: TimeStamp, end: TimeStamp): Duration;
declare function elapsed(start: RelativeTime, end: RelativeTime): Duration;
/**
 * Get the time since the navigation was started.
 *
 * Note: this does not use `performance.timeOrigin` because it doesn't seem to reflect the actual
 * time on which the navigation has started: it may be much farther in the past, at least in Firefox 71.
 * Related issue in Firefox: https://bugzilla.mozilla.org/show_bug.cgi?id=1429926
 */
declare function getRelativeTime(timestamp: TimeStamp): RelativeTime;
declare function getTimeStamp(relativeTime: RelativeTime): TimeStamp;
declare function looksLikeRelativeTime(time: RelativeTime | TimeStamp): time is RelativeTime;
declare function resetNavigationStart(): void;

interface BrowserError extends Error {
    sourceURL?: string;
    fileName?: string;
    line?: string | number;
    lineNumber?: string | number;
    description?: string;
}
type UnhandledErrorCallback = (stack: StackTrace, errorObject?: any) => any;
/**
 * An object representing a single stack frame.
 * @typedef {Object} StackFrame
 * @property {string=} url The JavaScript or HTML file URL.
 * @property {string=} func The function name, or empty for anonymous functions (if guessing did not work).
 * @property {string[]=} args The arguments passed to the function, if known.
 * @property {number=} line The line number, if known.
 * @property {number=} column The column number, if known.
 * @property {string[]=} context An array of source code lines; the middle element corresponds to the correct line#.
 * @memberof TraceKit
 */
interface StackFrame {
    url?: string;
    func?: string;
    args?: string[];
    line?: number;
    column?: number;
    context?: string[];
}
/**
 * An object representing a JavaScript stack trace.
 * @typedef {Object} StackTrace
 * @property {string=} name The name of the thrown exception.
 * @property {string} message The exception error message.
 * @property {StackFrame[]} stack An array of stack frames.
 * -- method used to collect the stack trace.
 * @memberof TraceKit
 */
interface StackTrace {
    name?: string;
    message?: string;
    url?: string;
    stack: StackFrame[];
    incomplete?: boolean;
    partial?: boolean;
}

/**
 * computeStackTrace: cross-browser stack traces in JavaScript
 *
 * Syntax:
 * ```js
 * s = computeStackTraceOfCaller([depth])
 * s = computeStackTrace(exception)
 * ```
 *
 * Supports:
 *   - Firefox:  full stack trace with line numbers and unreliable column
 *               number on top frame
 *   - Opera 10: full stack trace with line and column numbers
 *   - Opera 9-: full stack trace with line numbers
 *   - Chrome:   full stack trace with line and column numbers
 *   - Safari:   line and column number for the topmost stacktrace element
 *               only
 *   - IE:       no line numbers whatsoever
 *
 * Tries to guess names of anonymous functions by looking for assignments
 * in the source code. In IE and Safari, we have to guess source file names
 * by searching for function bodies inside all page scripts. This will not
 * work for scripts that are loaded cross-domain.
 * Here be dragons: some function names may be guessed incorrectly, and
 * duplicate functions may be mismatched.
 *
 * computeStackTrace should only be used for tracing purposes.
 *
 * Note: In IE and Safari, no stack trace is recorded on the Error object,
 * so computeStackTrace instead walks its *own* chain of callers.
 * This means that:
 *  * in Safari, some methods may be missing from the stack trace;
 *  * in IE, the topmost function in the stack trace will always be the
 *    caller of computeStackTrace.
 *
 * This is okay for tracing (because you are likely to be calling
 * computeStackTrace from the function you want to be the topmost element
 * of the stack trace anyway), but not okay for logging unhandled
 * exceptions (because your catch block will likely be far away from the
 * inner function that actually caused the exception).
 *
 * Tracing example:
 * ```js
 *     function trace(message) {
 *         let stackInfo = computeStackTrace.ofCaller();
 *         let data = message + "\n";
 *         for(let i in stackInfo.stack) {
 *             let item = stackInfo.stack[i];
 *             data += (item.func || '[anonymous]') + "() in " + item.url + ":" + (item.line || '0') + "\n";
 *         }
 *         if (window.console)
 *             console.info(data);
 *         else
 *             alert(data);
 *     }
 * ```
 * @memberof TraceKit
 * @namespace
 */
/**
 * Computes a stack trace for an exception.
 * @param {Error} ex
 * @param {(string|number)=} depth
 * @memberof computeStackTrace
 */
declare function computeStackTrace(ex: unknown, depth?: string | number): StackTrace;

/**
 * Cross-browser collection of unhandled errors
 *
 * Supports:
 * - Firefox: full stack trace with line numbers, plus column number
 * on top frame; column number is not guaranteed
 * - Opera: full stack trace with line and column numbers
 * - Chrome: full stack trace with line and column numbers
 * - Safari: line and column number for the top frame only; some frames
 * may be missing, and column number is not guaranteed
 * - IE: line and column number for the top frame only; some frames
 * may be missing, and column number is not guaranteed
 *
 * In theory, TraceKit should work on all of the following versions:
 * - IE5.5+ (only 8.0 tested)
 * - Firefox 0.9+ (only 3.5+ tested)
 * - Opera 7+ (only 10.50 tested; versions 9 and earlier may require
 * Exceptions Have Stacktrace to be enabled in opera:config)
 * - Safari 3+ (only 4+ tested)
 * - Chrome 1+ (only 5+ tested)
 * - Konqueror 3.5+ (untested)
 *
 * Tries to catch all unhandled errors and report them to the
 * callback.
 *
 * Callbacks receive a StackTrace object as described in the
 * computeStackTrace docs.
 *
 * @memberof TraceKit
 * @namespace
 */
declare function startUnhandledErrorCollection(callback: UnhandledErrorCallback): {
    stop: () => void;
};

declare function formatErrorMessage(stack: StackTrace): string;
declare function toStackTraceString(stack: StackTrace): string;
declare function formatUnknownError(stackTrace: StackTrace | undefined, errorObject: any, nonErrorPrefix: string, filterStack?: boolean): {
    message: string;
    stacktrace: string;
    type: string | undefined;
    id: string;
    col?: undefined;
    line?: undefined;
    file?: undefined;
} | {
    message: string;
    stacktrace: string;
    type: string | undefined;
    col: number | undefined;
    line: number | undefined;
    file: string;
    id: string;
};
declare function createHandlingStack(): string;

declare function instrumentMethod<OBJECT extends {
    [key: string]: any;
}, METHOD extends keyof OBJECT>(object: OBJECT, method: METHOD, instrumentationFactory: (original: OBJECT[METHOD]) => (this: OBJECT, ...args: Parameters<OBJECT[METHOD]>) => ReturnType<OBJECT[METHOD]>): {
    stop: () => void;
};
declare function instrumentMethodAndCallOriginal<OBJECT extends {
    [key: string]: any;
}, METHOD extends keyof OBJECT>(object: OBJECT, method: METHOD, { before, after, }: {
    before?: (this: OBJECT, ...args: Parameters<OBJECT[METHOD]>) => ReturnType<OBJECT[METHOD]>;
    after?: (this: OBJECT, ...args: Parameters<OBJECT[METHOD]>) => ReturnType<OBJECT[METHOD]>;
}): {
    stop: () => void;
};

declare function generateTraceId(): any;
declare function generateSpanId(): any;
declare function getB3Header(traceId: string, spanId: string): string;
declare function getW3CTraceHeader(traceId: string, spanId: string): string;
declare function getJaegerTraceHeaderr(traceId: string, spanId: string): string;
declare function patchHeaderOnRequest(traceId: string, spanId: string, init?: RequestInit, customTraceHeaders?: Record<string, string>, headerKey?: string): RequestInit;
declare function patchHeaderOnXhr(xhr: XMLHttpRequest, traceId: string, spanId: string, customTraceHeaders?: Record<string, string>): void;
declare function assembleOTAttribute(event: Record<string, any> | null | undefined, attribute: Record<string, any>, prefix?: string): void;

declare const ONE_SECOND = 1000;
declare const ONE_MINUTE: number;
declare const ONE_HOUR: number;
declare const ONE_DAY: number;
declare const ONE_YEAR: number;
declare const ONE_KILO_BYTE = 1024;
declare const SDK_VERSION: any;
declare function noop(): void;
declare function isNumber(value: unknown): value is number;
declare function isString(str: any): boolean;
declare function isError(str: any): boolean;
declare function round(num: number, decimals: 0 | 1 | 2 | 3 | 4): number;
declare function includes(candidate: string, search: string): boolean;
declare function includes<T>(candidate: T[], search: T): boolean;
declare function matchWithDefault(enable: boolean | null | undefined, def: boolean): boolean;
/**
 * uuid v4
 * @param placeholder
 * @returns
 */
declare function generateUUID(placeholder?: string): string;
declare function genUid(len?: number): string;
declare function matchSample(sampleRate: number): boolean;
declare function catchUserErrors<Args extends any[], R>(fn: (...args: Args) => R, errorMsg: string): (...args: Args) => R | undefined;
declare function getTrackUrl(opt: SLS_ClientBaseOptions): string;
declare function isInternalUrl(url: string, opt?: SLS_ClientBaseOptions): boolean;
declare function isURL(uri: string): boolean;
interface URIObject {
    uri: string;
    protocol: string;
    host: string;
    hostname: string;
    port: string;
    auth: string;
    user: string;
    password: string;
    path: string;
    search: string;
    hash: string;
}
declare function parseUri(uri: string): URIObject | null;
declare function buildHttpInfo(url: string, method: string, status_code: number, parsedUri: URIObject | null): Record<string, any>;
declare function matchCondition(text: string, ignore?: Array<IgnoreAllTypes>, ...args: any): boolean;
declare function shouldTrace(url: string, match?: MatchTraceRequestTypes[]): boolean;
declare function shouldTrackBody(shouldTrackBody: IEnableTrackRequestBody, data: NotifyData<Partial<OTTrace>>, success: boolean): boolean | undefined;
declare function throttle(fn: Function, delay: number): Function;

/**
 * 发布订阅-链式调用
 */
declare class SubscribeChain {
    private subscribeMap;
    private allNotifiers;
    constructor(allNotifiers: string[]);
    private subscribeOne;
    notify(source: string, data: NotifyData<OTTrace>): void;
    /**
     * 注册一个事件，注册的时候会检查是否有循环，这里逻辑上会禁止循环 (TODO:)
     * @param target plugin name, * means subscribe all plugins
     * @param callback
     * @param priority 被 notify 的优先级，负数最低，越大优先级越高
     */
    subscribe(source: string, target: string, callback: SubscribeCallback<OTTrace>, priority: number): void;
    getSubscribeMap(): Record<string, SubscribeDep<OTTrace>[]>;
}

declare abstract class SLSClient<BaseOptions extends SLS_ClientBaseOptions, OT extends OTTrace> {
    protected options: BaseOptions;
    protected isInit: boolean;
    private pendingPlugins;
    private pluginMap;
    private session;
    private context;
    protected sub: SubscribeChain;
    constructor(options: BaseOptions);
    private initPlugin;
    addLog(log: Record<string, any>): void;
    setOptions(options: SLS_MUTABLE_OPTION): void;
    start(): void;
    /**
     * 使用插件，必须在 start 之前
     * @param plugin 插件
     */
    use(plugin: IBasePlugin<BaseOptions, OT>): void;
    abstract setLocalStorage(key: string, value: string): void;
    abstract getLocalStorage(key: string): string | undefined | null;
}

declare function makeWebPublicApi<OT extends OTTrace, BaseOptions extends SLS_ClientBaseOptions, ExpandApiReturn extends Record<string, (...args: any) => void>, Client extends SLSClient<BaseOptions, OT>>(createClient: (options: BaseOptions) => Client, expandApi?: ((clientRef: ClientRef<Client>) => ExpandApiReturn) | null | undefined): BasePublicApi<BaseOptions, OT> & ExpandApiReturn;

/**
 * 发布订阅-遍历调用
 */
declare class Subscribe {
    dep: Map<string, UnknownFunc[]>;
    subscribe(eventName: string, callBack: (data: any) => any): void;
    notify<D = any>(eventName: string, data: D): void;
}

export { BrowserError, ONE_DAY, ONE_HOUR, ONE_KILO_BYTE, ONE_MINUTE, ONE_SECOND, ONE_YEAR, Observable, SDK_VERSION, SLSClient, StackTrace, Subscribe, URIObject, assembleOTAttribute, buildHttpInfo, callMonitored, catchUserErrors, clocksNow, clocksOrigin, computeStackTrace, createHandlingStack, currentDrift, debugLog, defineGlobal, defineGlobalValue, elapsed, formatErrorMessage, formatUnknownError, genUid, generateSpanId, generateTraceId, generateUUID, getB3Header, getConsoleLogStatus, getCorrectedTimeStamp, getJaegerTraceHeaderr, getRelativeTime, getTimeStamp, getTrackUrl, getW3CTraceHeader, includes, instrumentMethod, instrumentMethodAndCallOriginal, isError, isInternalUrl, isNumber, isString, isURL, looksLikeRelativeTime, makeWebPublicApi, matchCondition, matchSample, matchWithDefault, monitor, noop, parseUri, patchHeaderOnRequest, patchHeaderOnXhr, relativeNow, relativeToClocks, resetNavigationStart, round, shouldTrace, shouldTrackBody, startUnhandledErrorCollection, throttle, timeStampNow, toServerDuration, toStackTraceString };
