import { InternalPlugin, InternalPluginPriority, WebEventType, SLS_TRACE_UID_KEY } from '@aliyun-sls/web-types';

function defineGlobalValue(global, name, api) {
  Object.defineProperty(global, name, {
    writable: true,
    enumerable: true,
    configurable: true,
    value: api
  });
}
function defineGlobal(global, name, api, hook) {
  if (hook) {
    hook(() => {
      defineGlobalValue(global, name, api);
    });
  } else {
    defineGlobalValue(global, name, api);
  }
}

class Observable {
  constructor(onFirstSubscribe) {
    this.onFirstSubscribe = onFirstSubscribe;
    this.observers = [];
  }
  subscribe(f) {
    if (!this.observers.length && this.onFirstSubscribe) {
      this.onLastUnsubscribe = this.onFirstSubscribe() || void 0;
    }
    this.observers.push(f);
    return {
      unsubscribe: () => {
        this.observers = this.observers.filter((other) => f !== other);
        if (!this.observers.length && this.onLastUnsubscribe) {
          this.onLastUnsubscribe();
        }
      }
    };
  }
  notify(data) {
    this.observers.forEach((observer) => observer(data));
  }
}

function callMonitored(fn, context, args) {
  try {
    return fn.apply(context, args);
  } catch (e) {
    return void 0;
  }
}
function monitor(fn) {
  return function() {
    return callMonitored(fn, this, arguments);
  };
}
let isConsoleLoging = false;
function getConsoleLogStatus() {
  return isConsoleLoging;
}
function debugLog(...args) {
}

var __defProp$3 = Object.defineProperty;
var __defProps$2 = Object.defineProperties;
var __getOwnPropDescs$2 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$3 = Object.getOwnPropertySymbols;
var __hasOwnProp$3 = Object.prototype.hasOwnProperty;
var __propIsEnum$3 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$3 = (obj, key, value) => key in obj ? __defProp$3(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$3 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$3.call(b, prop))
      __defNormalProp$3(a, prop, b[prop]);
  if (__getOwnPropSymbols$3)
    for (var prop of __getOwnPropSymbols$3(b)) {
      if (__propIsEnum$3.call(b, prop))
        __defNormalProp$3(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$2 = (a, b) => __defProps$2(a, __getOwnPropDescs$2(b));
const ONE_SECOND = 1e3;
const ONE_MINUTE = 60 * ONE_SECOND;
const ONE_HOUR = 60 * ONE_MINUTE;
const ONE_DAY = 24 * ONE_HOUR;
const ONE_YEAR = 365 * ONE_DAY;
const ONE_KILO_BYTE = 1024;
const SDK_VERSION = "0.2.7";
function noop() {
}
function isNumber(value) {
  return typeof value === "number";
}
function isString(str) {
  return Object.prototype.toString.call(str) === "[object String]";
}
function isError(str) {
  return Object.prototype.toString.call(str) === "[object Error]";
}
function round(num, decimals) {
  return +num.toFixed(decimals);
}
function includes(candidate, search) {
  return candidate.indexOf(search) !== -1;
}
function matchWithDefault(enable, def) {
  if (enable == null) {
    return def;
  }
  return !!enable;
}
function generateUUID(placeholder) {
  return placeholder ? (
    // eslint-disable-next-line  no-bitwise
    (parseInt(placeholder, 10) ^ Math.random() * 16 >> parseInt(placeholder, 10) / 4).toString(16)
  ) : `${1e7}-${1e3}-${4e3}-${8e3}-${1e11}`.replace(/[018]/g, generateUUID);
}
function genUid(len = 20) {
  var e, t;
  const n = new Array(len);
  const o = Date.now().toString(36).split("");
  for (; len-- > 0; ) {
    t = (e = 36 * Math.random() | 0).toString(36);
    n[len] = e % 3 ? t : t.toUpperCase();
  }
  for (var i = 0; i < 8; i++) {
    n.splice(3 * i + 2, 0, o[i]);
  }
  return n.join("");
}
function matchSample(sampleRate) {
  return sampleRate !== 0 && Math.random() <= sampleRate;
}
function catchUserErrors(fn, errorMsg) {
  return (...args) => {
    try {
      return fn(...args);
    } catch (err) {
      console.error(errorMsg, err);
    }
  };
}
function getTrackUrl(opt) {
  return "https://" + opt.project + "." + opt.host + "/logstores/" + opt.logstore + "/track";
}
function isInternalUrl(url, opt) {
  if (opt) {
    return url.includes(getTrackUrl(opt));
  }
  return url.includes("/track?APIVersion=0.6.0");
}
const REGEX = /^(?:([^:\/?#]+):\/\/)?((?:([^\/?#@]*)@)?([^\/?#:]*)(?:\:(\d*))?)?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n)*))?/i;
function decode(uri) {
  try {
    return decodeURIComponent(uri);
  } catch (e) {
    return unescape(uri);
  }
}
function isURL(uri) {
  return typeof uri === "string" && REGEX.test(uri);
}
function parseUri(uri) {
  var parts = decode(uri || "").match(REGEX);
  if (parts == null) {
    return null;
  }
  var auth = (parts[3] || "").split(":");
  var host = auth.length ? (parts[2] || "").replace(/(.*\@)/, "") : parts[2];
  return {
    uri: parts[0],
    protocol: parts[1],
    host,
    hostname: parts[4],
    port: parts[5],
    auth: parts[3],
    user: auth[0],
    password: auth[1],
    path: parts[6],
    search: parts[7],
    // query: mapSearchParams(parts[7]),
    hash: parts[8]
  };
}
function buildHttpInfo(url, method, status_code, parsedUri) {
  const base = {
    url,
    method,
    status_code
  };
  if (parsedUri == null) {
    return base;
  }
  return __spreadProps$2(__spreadValues$3({}, base), {
    host: parsedUri.host,
    scheme: parsedUri.protocol
  });
}
function matchCondition(text, ignore, ...args) {
  if (ignore == null || !Array.isArray(ignore)) {
    return false;
  }
  return ignore.some((fn) => {
    if (typeof fn === "function") {
      try {
        return fn(text, ...args);
      } catch (err) {
        console.error("user function callback threw an error:", err);
        return false;
      }
    }
    if (typeof fn === "string") {
      return text.includes(fn);
    }
    if (Object.prototype.toString.call(fn) === "[object RegExp]") {
      return fn.test(text);
    }
    return false;
  });
}
function shouldTrace(url, match) {
  if (match == null) {
    return true;
  }
  return matchCondition(url, match);
}
function shouldTrackBody(shouldTrackBody2, data, success) {
  if (shouldTrackBody2 === false) {
    return false;
  }
  if (shouldTrackBody2 === true) {
    return true;
  }
  if (shouldTrackBody2 === "error") {
    if (!success) {
      return true;
    }
  }
  if (typeof shouldTrackBody2 === "function") {
    return catchUserErrors(shouldTrackBody2, "call shouldTrackBody failed")(data);
  }
  return false;
}
function throttle(fn, delay) {
  let canRun = true;
  return function(...args) {
    if (!canRun)
      return;
    fn.apply(this, args);
    canRun = false;
    setTimeout(() => {
      canRun = true;
    }, delay);
  };
}

function relativeToClocks(relative) {
  return { relative, timeStamp: getCorrectedTimeStamp(relative) };
}
function getCorrectedTimeStamp(relativeTime) {
  const correctedOrigin = Date.now() - performance.now();
  if (correctedOrigin > getNavigationStart()) {
    return Math.round(correctedOrigin + relativeTime);
  }
  return getTimeStamp(relativeTime);
}
function currentDrift() {
  return Math.round(Date.now() - (getNavigationStart() + performance.now()));
}
function toServerDuration(duration) {
  if (!isNumber(duration)) {
    return duration;
  }
  return round(duration * 1e6, 0);
}
function timeStampNow() {
  return Date.now();
}
function relativeNow() {
  return performance.now();
}
function clocksNow() {
  return { relative: relativeNow(), timeStamp: timeStampNow() };
}
function clocksOrigin() {
  return { relative: 0, timeStamp: getNavigationStart() };
}
function elapsed(start, end) {
  return end - start;
}
function getRelativeTime(timestamp) {
  return timestamp - getNavigationStart();
}
function getTimeStamp(relativeTime) {
  return Math.round(getNavigationStart() + relativeTime);
}
function looksLikeRelativeTime(time) {
  return time < ONE_YEAR;
}
let navigationStart;
function getNavigationStart() {
  if (navigationStart === void 0) {
    navigationStart = performance.timing.navigationStart;
  }
  return navigationStart;
}
function resetNavigationStart() {
  navigationStart = void 0;
}

const UNKNOWN_FUNCTION = "?";
function computeStackTrace(ex, depth) {
  let stack;
  const normalizedDepth = depth === void 0 ? 0 : +depth;
  try {
    stack = computeStackTraceFromStacktraceProp(ex);
    if (stack) {
      return stack;
    }
  } catch (e) {
  }
  try {
    stack = computeStackTraceFromStackProp(ex);
    if (stack) {
      return stack;
    }
  } catch (e) {
  }
  try {
    stack = computeStackTraceFromOperaMultiLineMessage(ex);
    if (stack) {
      return stack;
    }
  } catch (e) {
  }
  try {
    stack = computeStackTraceByWalkingCallerChain(ex, normalizedDepth + 1);
    if (stack) {
      return stack;
    }
  } catch (e) {
  }
  return {
    message: tryToGetString(ex, "message"),
    name: tryToGetString(ex, "name"),
    stack: []
  };
}
function computeStackTraceFromStackProp(ex) {
  const stacktrace = tryToGetString(ex, "stack");
  if (!stacktrace) {
    return;
  }
  const chrome = /^\s*at (.*?) ?\(((?:file|https?|blob|chrome-extension|native|eval|webpack|<anonymous>|\/).*?)(?::(\d+))?(?::(\d+))?\)?\s*$/i;
  const gecko = /^\s*(.*?)(?:\((.*?)\))?(?:^|@)((?:file|https?|blob|chrome|webpack|resource|capacitor|\[native).*?|[^@]*bundle)(?::(\d+))?(?::(\d+))?\s*$/i;
  const winjs = /^\s*at (?:((?:\[object object\])?.+) )?\(?((?:file|ms-appx|https?|webpack|blob):.*?):(\d+)(?::(\d+))?\)?\s*$/i;
  let isEval;
  const geckoEval = /(\S+) line (\d+)(?: > eval line \d+)* > eval/i;
  const chromeEval = /\((\S*)(?::(\d+))(?::(\d+))\)/;
  const lines = stacktrace.split("\n");
  const stack = [];
  let submatch;
  let parts;
  let element;
  for (let i = 0, j = lines.length; i < j; i += 1) {
    if (chrome.exec(lines[i])) {
      parts = chrome.exec(lines[i]);
      const isNative = parts[2] && parts[2].indexOf("native") === 0;
      isEval = parts[2] && parts[2].indexOf("eval") === 0;
      submatch = chromeEval.exec(parts[2]);
      if (isEval && submatch) {
        parts[2] = submatch[1];
        parts[3] = submatch[2];
        parts[4] = submatch[3];
      }
      element = {
        args: isNative ? [parts[2]] : [],
        column: parts[4] ? +parts[4] : void 0,
        func: parts[1] || UNKNOWN_FUNCTION,
        line: parts[3] ? +parts[3] : void 0,
        url: !isNative ? parts[2] : void 0
      };
    } else if (winjs.exec(lines[i])) {
      parts = winjs.exec(lines[i]);
      element = {
        args: [],
        column: parts[4] ? +parts[4] : void 0,
        func: parts[1] || UNKNOWN_FUNCTION,
        line: +parts[3],
        url: parts[2]
      };
    } else if (gecko.exec(lines[i])) {
      parts = gecko.exec(lines[i]);
      isEval = parts[3] && parts[3].indexOf(" > eval") > -1;
      submatch = geckoEval.exec(parts[3]);
      if (isEval && submatch) {
        parts[3] = submatch[1];
        parts[4] = submatch[2];
        parts[5] = void 0;
      } else if (i === 0 && !parts[5] && !isUndefined(ex.columnNumber)) {
        stack[0].column = ex.columnNumber + 1;
      }
      element = {
        args: parts[2] ? parts[2].split(",") : [],
        column: parts[5] ? +parts[5] : void 0,
        func: parts[1] || UNKNOWN_FUNCTION,
        line: parts[4] ? +parts[4] : void 0,
        url: parts[3]
      };
    } else {
      continue;
    }
    if (!element.func && element.line) {
      element.func = UNKNOWN_FUNCTION;
    }
    stack.push(element);
  }
  if (!stack.length) {
    return;
  }
  return {
    stack,
    message: tryToGetString(ex, "message"),
    name: tryToGetString(ex, "name")
  };
}
function computeStackTraceFromStacktraceProp(ex) {
  const stacktrace = tryToGetString(ex, "stacktrace");
  if (!stacktrace) {
    return;
  }
  const opera10Regex = / line (\d+).*script (?:in )?(\S+)(?:: in function (\S+))?$/i;
  const opera11Regex = / line (\d+), column (\d+)\s*(?:in (?:<anonymous function: ([^>]+)>|([^)]+))\((.*)\))? in (.*):\s*$/i;
  const lines = stacktrace.split("\n");
  const stack = [];
  let parts;
  for (let line = 0; line < lines.length; line += 2) {
    let element;
    if (opera10Regex.exec(lines[line])) {
      parts = opera10Regex.exec(lines[line]);
      element = {
        args: [],
        column: void 0,
        func: parts[3],
        line: +parts[1],
        url: parts[2]
      };
    } else if (opera11Regex.exec(lines[line])) {
      parts = opera11Regex.exec(lines[line]);
      element = {
        args: parts[5] ? parts[5].split(",") : [],
        column: +parts[2],
        func: parts[3] || parts[4],
        line: +parts[1],
        url: parts[6]
      };
    }
    if (element) {
      if (!element.func && element.line) {
        element.func = UNKNOWN_FUNCTION;
      }
      element.context = [lines[line + 1]];
      stack.push(element);
    }
  }
  if (!stack.length) {
    return;
  }
  return {
    stack,
    message: tryToGetString(ex, "message"),
    name: tryToGetString(ex, "name")
  };
}
function computeStackTraceFromOperaMultiLineMessage(ex) {
  const message = tryToGetString(ex, "message");
  if (!message) {
    return;
  }
  const lines = message.split("\n");
  if (lines.length < 4) {
    return;
  }
  const lineRE1 = /^\s*Line (\d+) of linked script ((?:file|https?|blob)\S+)(?:: in function (\S+))?\s*$/i;
  const lineRE2 = /^\s*Line (\d+) of inline#(\d+) script in ((?:file|https?|blob)\S+)(?:: in function (\S+))?\s*$/i;
  const lineRE3 = /^\s*Line (\d+) of function script\s*$/i;
  const stack = [];
  const scripts = window && window.document && window.document.getElementsByTagName("script");
  const inlineScriptBlocks = [];
  let parts;
  for (const s in scripts) {
    if (has(scripts, s) && !scripts[s].src) {
      inlineScriptBlocks.push(scripts[s]);
    }
  }
  for (let line = 2; line < lines.length; line += 2) {
    let item;
    if (lineRE1.exec(lines[line])) {
      parts = lineRE1.exec(lines[line]);
      item = {
        args: [],
        column: void 0,
        func: parts[3],
        line: +parts[1],
        url: parts[2]
      };
    } else if (lineRE2.exec(lines[line])) {
      parts = lineRE2.exec(lines[line]);
      item = {
        args: [],
        column: void 0,
        // TODO: Check to see if inline#1 (+parts[2]) points to the script number or column number.
        func: parts[4],
        line: +parts[1],
        url: parts[3]
      };
    } else if (lineRE3.exec(lines[line])) {
      parts = lineRE3.exec(lines[line]);
      const url = window.location.href.replace(/#.*$/, "");
      item = {
        url,
        args: [],
        column: void 0,
        func: "",
        line: +parts[1]
      };
    }
    if (item) {
      if (!item.func) {
        item.func = UNKNOWN_FUNCTION;
      }
      item.context = [lines[line + 1]];
      stack.push(item);
    }
  }
  if (!stack.length) {
    return;
  }
  return {
    stack,
    message: lines[0],
    name: tryToGetString(ex, "name")
  };
}
function augmentStackTraceWithInitialElement(stackInfo, url, lineNo) {
  const initial = {
    url,
    line: lineNo ? +lineNo : void 0
  };
  if (initial.url && initial.line) {
    stackInfo.incomplete = false;
    const stack = stackInfo.stack;
    if (stack.length > 0) {
      if (stack[0].url === initial.url) {
        if (stack[0].line === initial.line) {
          return false;
        }
        if (!stack[0].line && stack[0].func === initial.func) {
          stack[0].line = initial.line;
          stack[0].context = initial.context;
          return false;
        }
      }
    }
    stack.unshift(initial);
    stackInfo.partial = true;
    return true;
  }
  stackInfo.incomplete = true;
  return false;
}
function computeStackTraceByWalkingCallerChain(ex, depth) {
  const functionName = /function\s+([_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*)?\s*\(/i;
  const stack = [];
  const funcs = {};
  let recursion = false;
  let parts;
  let item;
  for (let curr = computeStackTraceByWalkingCallerChain.caller; curr && !recursion; curr = curr.caller) {
    if (curr === computeStackTrace) {
      continue;
    }
    item = {
      args: [],
      column: void 0,
      func: UNKNOWN_FUNCTION,
      line: void 0,
      url: void 0
    };
    parts = functionName.exec(curr.toString());
    if (curr.name) {
      item.func = curr.name;
    } else if (parts) {
      item.func = parts[1];
    }
    if (typeof item.func === "undefined") {
      item.func = parts ? parts.input.substring(0, parts.input.indexOf("{")) : void 0;
    }
    if (funcs[curr.toString()]) {
      recursion = true;
    } else {
      funcs[curr.toString()] = true;
    }
    stack.push(item);
  }
  if (depth) {
    stack.splice(0, depth);
  }
  const result = {
    stack,
    message: tryToGetString(ex, "message"),
    name: tryToGetString(ex, "name")
  };
  augmentStackTraceWithInitialElement(
    result,
    tryToGetString(ex, "sourceURL") || tryToGetString(ex, "fileName"),
    tryToGetString(ex, "line") || tryToGetString(ex, "lineNumber")
  );
  return result;
}
function tryToGetString(candidate, property) {
  if (typeof candidate !== "object" || !candidate || !(property in candidate)) {
    return void 0;
  }
  const value = candidate[property];
  return typeof value === "string" ? value : void 0;
}
function has(object, key) {
  return Object.prototype.hasOwnProperty.call(object, key);
}
function isUndefined(what) {
  return typeof what === "undefined";
}

function instrumentMethod(object, method, instrumentationFactory) {
  const original = object[method];
  let instrumentation = instrumentationFactory(original);
  const instrumentationWrapper = function() {
    return instrumentation.apply(this, arguments);
  };
  object[method] = instrumentationWrapper;
  return {
    stop: () => {
      if (object[method] === instrumentationWrapper) {
        object[method] = original;
      } else {
        instrumentation = original;
      }
    }
  };
}
function instrumentMethodAndCallOriginal(object, method, {
  before,
  after
}) {
  return instrumentMethod(
    object,
    method,
    (original) => function() {
      const args = arguments;
      let result;
      if (before) {
        callMonitored(before, this, args);
      }
      if (typeof original === "function") {
        result = original.apply(this, args);
      }
      if (after) {
        callMonitored(after, this, args);
      }
      return result;
    }
  );
}

const ERROR_TYPES_RE = /^(?:[Uu]ncaught (?:exception: )?)?(?:((?:Eval|Internal|Range|Reference|Syntax|Type|URI|)Error): )?(.*)$/;
function startUnhandledErrorCollection(callback) {
  const { stop: stopInstrumentingOnError } = instrumentOnError(callback);
  const { stop: stopInstrumentingOnUnhandledRejection } = instrumentUnhandledRejection(callback);
  return {
    stop: () => {
      stopInstrumentingOnError();
      stopInstrumentingOnUnhandledRejection();
    }
  };
}
function instrumentOnError(callback) {
  return instrumentMethodAndCallOriginal(window, "onerror", {
    before(message, url, lineNo, columnNo, errorObj) {
      let stack;
      if (errorObj) {
        stack = computeStackTrace(errorObj);
        callback(stack, errorObj);
      } else {
        const location = {
          url,
          column: columnNo,
          line: lineNo
        };
        let name;
        let msg = message;
        if ({}.toString.call(message) === "[object String]") {
          const groups = ERROR_TYPES_RE.exec(msg);
          if (groups) {
            name = groups[1];
            msg = groups[2];
          }
        }
        stack = {
          name,
          message: typeof msg === "string" ? msg : void 0,
          stack: [location]
        };
        callback(stack, message);
      }
    }
  });
}
function instrumentUnhandledRejection(callback) {
  return instrumentMethodAndCallOriginal(window, "onunhandledrejection", {
    before(e) {
      const reason = e.reason || "Empty reason";
      const stack = computeStackTrace(reason);
      callback(stack, reason);
    }
  });
}

function formatErrorMessage(stack) {
  return `${stack.name || "Error"}: ${stack.message}`;
}
function filterRumStack(stack) {
  return stack.filter((frame) => frame.url == null || !frame.url.includes("sls-rum.js"));
}
function toStackTraceString(stack) {
  let result = formatErrorMessage(stack);
  stack.stack.forEach((frame) => {
    const func = frame.func === "?" ? "<anonymous>" : frame.func;
    const args = frame.args && frame.args.length > 0 ? `(${frame.args.join(", ")})` : "";
    const line = frame.line ? `:${frame.line}` : "";
    const column = frame.line && frame.column ? `:${frame.column}` : "";
    result += `
  at ${func}${args} @ ${frame.url}${line}${column}`;
  });
  return encodeURIComponent(result);
}
function formatUnknownError(stackTrace, errorObject, nonErrorPrefix, filterStack = true) {
  var _a;
  if (!stackTrace || stackTrace.message === void 0 && !(errorObject instanceof Error)) {
    return {
      message: `${nonErrorPrefix} ${JSON.stringify(errorObject)}`,
      stacktrace: "",
      type: stackTrace && stackTrace.name,
      id: generateUUID()
    };
  }
  if ((stackTrace == null ? void 0 : stackTrace.stack) && filterStack) {
    stackTrace.stack = filterRumStack(stackTrace.stack);
  }
  const topFrame = (_a = stackTrace == null ? void 0 : stackTrace.stack) == null ? void 0 : _a[0];
  return {
    message: encodeURIComponent(stackTrace.message || "Empty message"),
    stacktrace: toStackTraceString(stackTrace),
    type: stackTrace.name,
    col: topFrame ? topFrame.column : void 0,
    line: topFrame ? topFrame.line : void 0,
    file: encodeURIComponent(topFrame && topFrame.url ? topFrame.url : ""),
    id: generateUUID()
  };
}
function createHandlingStack() {
  const error = new Error();
  let formattedStack;
  callMonitored(() => {
    const stackTrace = computeStackTrace(error);
    if (stackTrace == null ? void 0 : stackTrace.stack) {
      stackTrace.stack = filterRumStack(stackTrace.stack);
    }
    formattedStack = toStackTraceString(stackTrace);
  });
  return formattedStack;
}

const SPAN_ID_BYTES = 8;
const TRACE_ID_BYTES = 16;
const B3_CONTEXT_HEADER = "b3";
const TRACE_PARENT_HEADER = "traceparent";
const UBER_TRACE_ID_HEADER = "uber-trace-id";
const SHARED_CHAR_CODES_ARRAY = Array(32);
function generateId(bytes) {
  for (let i = 0; i < bytes * 2; i++) {
    SHARED_CHAR_CODES_ARRAY[i] = Math.floor(Math.random() * 16) + 48;
    if (SHARED_CHAR_CODES_ARRAY[i] >= 58) {
      SHARED_CHAR_CODES_ARRAY[i] += 39;
    }
  }
  return String.fromCharCode.apply(null, SHARED_CHAR_CODES_ARRAY.slice(0, bytes * 2));
}
function generateTraceId() {
  return generateId(TRACE_ID_BYTES);
}
function generateSpanId() {
  return generateId(SPAN_ID_BYTES);
}
function getB3Header(traceId, spanId) {
  return `${traceId}-${spanId}-1`;
}
function getW3CTraceHeader(traceId, spanId) {
  return `00-${traceId}-${spanId}-01`;
}
function getJaegerTraceHeaderr(traceId, spanId) {
  return `${traceId}:${spanId}:0:1`;
}
const TRACE_HEADER = {
  b3: {
    name: B3_CONTEXT_HEADER,
    getter: getB3Header
  },
  traceparent: {
    name: TRACE_PARENT_HEADER,
    getter: getW3CTraceHeader
  },
  uber: {
    name: UBER_TRACE_ID_HEADER,
    getter: getJaegerTraceHeaderr
  }
};
function patchHeaderOnRequest(traceId, spanId, init, customTraceHeaders, headerKey = "headers") {
  var _a;
  const request = init != null ? init : {};
  request[headerKey] = (_a = request[headerKey]) != null ? _a : {};
  request[headerKey][B3_CONTEXT_HEADER] = getB3Header(traceId, spanId);
  request[headerKey][TRACE_PARENT_HEADER] = getW3CTraceHeader(traceId, spanId);
  request[headerKey][UBER_TRACE_ID_HEADER] = getJaegerTraceHeaderr(traceId, spanId);
  try {
    if (customTraceHeaders) {
      for (const [key, value] of Object.entries(customTraceHeaders)) {
        if (TRACE_HEADER[value]) {
          request[headerKey][key] = TRACE_HEADER[value].getter(traceId, spanId);
        }
      }
    }
  } catch (e) {
  }
  return request;
}
function patchHeaderOnXhr(xhr, traceId, spanId, customTraceHeaders) {
  xhr.setRequestHeader(B3_CONTEXT_HEADER, getB3Header(traceId, spanId));
  xhr.setRequestHeader(TRACE_PARENT_HEADER, getW3CTraceHeader(traceId, spanId));
  xhr.setRequestHeader(UBER_TRACE_ID_HEADER, getJaegerTraceHeaderr(traceId, spanId));
  try {
    if (customTraceHeaders) {
      for (const [key, value] of Object.entries(customTraceHeaders)) {
        if (TRACE_HEADER[value]) {
          xhr.setRequestHeader(key, TRACE_HEADER[value].getter(traceId, spanId));
        }
      }
    }
  } catch (e) {
  }
}
function assembleOTAttribute(event, attribute, prefix) {
  if (event == null) {
    return;
  }
  Object.keys(event).map((key) => {
    if (prefix == null || prefix == "") {
      attribute[key] = event[key];
    } else {
      attribute[`${prefix}.${key}`] = event[key];
    }
  });
}

var __defProp$2 = Object.defineProperty;
var __defProps$1 = Object.defineProperties;
var __getOwnPropDescs$1 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2 = Object.getOwnPropertySymbols;
var __hasOwnProp$2 = Object.prototype.hasOwnProperty;
var __propIsEnum$2 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2 = (obj, key, value) => key in obj ? __defProp$2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2.call(b, prop))
      __defNormalProp$2(a, prop, b[prop]);
  if (__getOwnPropSymbols$2)
    for (var prop of __getOwnPropSymbols$2(b)) {
      if (__propIsEnum$2.call(b, prop))
        __defNormalProp$2(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1 = (a, b) => __defProps$1(a, __getOwnPropDescs$1(b));
function createBaseTransformPlugin() {
  return {
    name: InternalPlugin.BASE_TRANSFORM,
    run: function() {
      this.subscribe(
        "*",
        (data, next) => {
          var _a, _b;
          const { otBase, extra } = data;
          otBase.service = this.options.service;
          otBase.attribute = __spreadProps$1(__spreadValues$2(__spreadValues$2({}, (_a = this.options.attribute) != null ? _a : {}), otBase.attribute), {
            sid: this.session.getSessionId(),
            pid: this.session.getPageId(),
            uid: this.options.uid
          });
          if (this.options.nickname) {
            otBase.attribute.nickname = this.options.nickname;
          }
          assembleOTAttribute(this.options.custom, otBase.attribute, "custom");
          otBase.resource = __spreadValues$2(__spreadValues$2({}, (_b = this.options.resource) != null ? _b : {}), otBase.resource);
          assembleOTAttribute(
            {
              sdk_version: SDK_VERSION,
              workspace: this.options.workspace,
              "deployment.environment": this.options.env
            },
            otBase.resource
          );
          if (this.options.namespace) {
            otBase.resource["service.namespace"] = this.options.namespace;
          }
          if (this.options.version) {
            otBase.resource["service.version"] = this.options.version;
          }
          const nextData = {
            otBase,
            extra
          };
          debugLog(InternalPlugin.BASE_TRANSFORM, nextData);
          next(nextData);
        },
        InternalPluginPriority[InternalPlugin.BASE_TRANSFORM]
      );
    }
  };
}

function createLogPlugin() {
  return {
    name: InternalPlugin.LOG_SEND,
    run: function() {
    }
  };
}

function notifyDep(deps, current, data) {
  if (current < 0) {
    return;
  }
  const next = (newData) => {
    notifyDep(deps, current - 1, newData);
  };
  const dep = deps[current];
  catchUserErrors(() => {
    dep.callback.call(void 0, data, next);
  }, "plugin notify run error")();
}
class SubscribeChain {
  constructor(allNotifiers) {
    this.subscribeMap = {};
    this.allNotifiers = [];
    this.allNotifiers = allNotifiers;
  }
  subscribeOne(source, target, callback, priority) {
    var _a;
    const subscribeDep = (_a = this.subscribeMap[target]) != null ? _a : [];
    this.subscribeMap[target] = subscribeDep;
    subscribeDep.push({
      name: source,
      priority,
      callback
    });
    subscribeDep.sort((a, b) => a.priority - b.priority);
  }
  notify(source, data) {
    var _a;
    const deps = (_a = this.subscribeMap[source]) != null ? _a : [];
    notifyDep(deps, deps.length - 1, data);
  }
  /**
   * 注册一个事件，注册的时候会检查是否有循环，这里逻辑上会禁止循环 (TODO:)
   * @param target plugin name, * means subscribe all plugins
   * @param callback
   * @param priority 被 notify 的优先级，负数最低，越大优先级越高
   */
  subscribe(source, target, callback, priority) {
    if (target === "*") {
      for (let ind = 0; ind < this.allNotifiers.length; ind++) {
        const el = this.allNotifiers[ind];
        if (source !== el) {
          this.subscribeOne(source, el, callback, priority);
        }
      }
    } else {
      this.subscribeOne(source, target, callback, priority);
    }
  }
  getSubscribeMap() {
    return this.subscribeMap;
  }
}

function createSession() {
  const session_id = generateTraceId();
  let page_id = generateSpanId();
  return {
    getSessionId: () => {
      return session_id;
    },
    getPageId: () => {
      return page_id;
    },
    refreshPageId: () => {
      page_id = generateSpanId();
    }
  };
}

var __defProp$1 = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$1 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1 = (obj, key, value) => key in obj ? __defProp$1(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1.call(b, prop))
      __defNormalProp$1(a, prop, b[prop]);
  if (__getOwnPropSymbols$1)
    for (var prop of __getOwnPropSymbols$1(b)) {
      if (__propIsEnum$1.call(b, prop))
        __defNormalProp$1(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const mutableOptionKeys = ["uid", "nickname", "env", "service", "version", "custom", "namespace"];
class SLSClient {
  constructor(options) {
    this.isInit = false;
    this.pendingPlugins = [];
    this.pluginMap = {};
    this.session = createSession();
    var _a, _b;
    this.options = options;
    this.use(createLogPlugin());
    this.use(createBaseTransformPlugin());
    this.options.env = (_a = options.env) != null ? _a : "prod";
    this.options.version = (_b = options.version) != null ? _b : "-";
  }
  initPlugin(plugin) {
    if (plugin == null || typeof plugin !== "object") {
      console.error("plugin is not a object");
      return;
    }
    if (plugin.name == null || plugin.name === "") {
      console.error("plugin name is required.");
      return;
    }
    if (this.pluginMap[plugin.name]) {
      console.error(`plugin name: ${plugin.name} is conflict`);
      return;
    }
    if (typeof plugin.run !== "function") {
      console.error("plugin.run is not a function");
      return;
    }
    const context = __spreadProps(__spreadValues$1({}, this.context), {
      subscribe: (target, callback, priority) => {
        this.sub.subscribe(plugin.name, target, callback, priority);
      },
      notify: (data) => {
        this.sub.notify(plugin.name, data);
      }
    });
    catchUserErrors(() => plugin.run.call(context), `plugin ${plugin.name} init failed`)();
  }
  addLog(log) {
    if (this.isInit) {
      const attribute = {
        t: WebEventType.LOG
      };
      assembleOTAttribute(log, attribute, WebEventType.LOG);
      const ot = {
        start: timeStampNow() * 1e3,
        attribute,
        resource: {}
      };
      this.sub.notify(InternalPlugin.LOG_SEND, {
        otBase: ot,
        extra: {}
      });
    } else {
      console.error(`log should call after start`);
    }
  }
  setOptions(options) {
    if (this.isInit) {
      mutableOptionKeys.forEach((key) => {
        if (options[key] !== this.options[key] && options[key] != null && options[key] != "") {
          this.options[key] = options[key];
          if (key === "uid") {
            if (typeof this.setLocalStorage === "function") {
              this.setLocalStorage(SLS_TRACE_UID_KEY, options[key]);
            }
          }
        }
      });
    } else {
      console.error(`setOptions should call after start`);
    }
  }
  start() {
    if (!this.isInit) {
      this.isInit = true;
      let uid = this.options.uid;
      if (uid == null || uid === "") {
        if (typeof this.getLocalStorage === "function") {
          uid = this.getLocalStorage(SLS_TRACE_UID_KEY);
        }
        if (uid == null || uid === "") {
          uid = genUid();
        }
      }
      this.options.uid = uid;
      if (typeof this.setLocalStorage === "function") {
        this.setLocalStorage(SLS_TRACE_UID_KEY, uid);
      }
      const allNotifiers = this.pendingPlugins.map((plu) => plu == null ? void 0 : plu.name).filter((plu) => plu != null);
      this.sub = new SubscribeChain(allNotifiers);
      this.context = {
        options: this.options,
        session: this.session
      };
      for (const plugin of this.pendingPlugins) {
        this.initPlugin(plugin);
      }
    }
  }
  /**
   * 使用插件，必须在 start 之前
   * @param plugin 插件
   */
  use(plugin) {
    if (!this.isInit) {
      this.pendingPlugins.push(plugin);
    } else {
      console.error(`plugin: ${plugin == null ? void 0 : plugin.name} use should run before start`);
    }
  }
}

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
function makeWebPublicApi(createClient, expandApi) {
  var _a;
  const clientRef = {
    current: void 0
  };
  const cachePlugins = [];
  let expand = {};
  if (typeof expandApi === "function") {
    expand = (_a = expandApi(clientRef)) != null ? _a : {};
  }
  return __spreadValues({
    init: (options) => {
      if (clientRef.current != null) {
        return;
      }
      clientRef.current = createClient(options);
      const client = clientRef.current;
      cachePlugins.forEach((p) => {
        client.use(p);
      });
      client.start();
    },
    use: (plugin) => {
      cachePlugins.push(plugin);
    },
    addLog: (log) => {
      const client = clientRef.current;
      client.addLog(log);
    },
    onReady(callback) {
      callback();
    },
    setOptions: (options) => {
      const client = clientRef.current;
      client.setOptions(options);
    }
  }, expand);
}

class Subscribe {
  constructor() {
    this.dep = /* @__PURE__ */ new Map();
  }
  subscribe(eventName, callBack) {
    const fns = this.dep.get(eventName);
    if (fns) {
      this.dep.set(eventName, fns.concat(callBack));
      return;
    }
    this.dep.set(eventName, [callBack]);
  }
  notify(eventName, data) {
    const fns = this.dep.get(eventName);
    if (!eventName || !fns)
      return;
    fns.forEach((fn) => {
      try {
        fn(data);
      } catch (err) {
        console.error(err);
      }
    });
  }
}

export { ONE_DAY, ONE_HOUR, ONE_KILO_BYTE, ONE_MINUTE, ONE_SECOND, ONE_YEAR, Observable, SDK_VERSION, SLSClient, Subscribe, assembleOTAttribute, buildHttpInfo, callMonitored, catchUserErrors, clocksNow, clocksOrigin, computeStackTrace, createHandlingStack, currentDrift, debugLog, defineGlobal, defineGlobalValue, elapsed, formatErrorMessage, formatUnknownError, genUid, generateSpanId, generateTraceId, generateUUID, getB3Header, getConsoleLogStatus, getCorrectedTimeStamp, getJaegerTraceHeaderr, getRelativeTime, getTimeStamp, getTrackUrl, getW3CTraceHeader, includes, instrumentMethod, instrumentMethodAndCallOriginal, isError, isInternalUrl, isNumber, isString, isURL, looksLikeRelativeTime, makeWebPublicApi, matchCondition, matchSample, matchWithDefault, monitor, noop, parseUri, patchHeaderOnRequest, patchHeaderOnXhr, relativeNow, relativeToClocks, resetNavigationStart, round, shouldTrace, shouldTrackBody, startUnhandledErrorCollection, throttle, timeStampNow, toServerDuration, toStackTraceString };
//# sourceMappingURL=web-base.es.js.map
