class WebTracker {
  constructor(opt) {
    this.timer = null;
    this.time = 10;
    this.count = 10;
    this.arr = [];
    var _a, _b;
    this.time = (_a = opt.time) != null ? _a : 10;
    this.count = (_b = opt.count) != null ? _b : 10;
    if (opt.host.startsWith("http://") || opt.host.startsWith("https://")) {
      this.url = opt.host + "/logstores/" + opt.logstore + "/track";
    } else {
      this.url = "https://" + opt.project + "." + opt.host + "/logstores/" + opt.logstore + "/track";
    }
    this.opt = opt;
    if (opt.installUnloadHook && typeof opt.installUnloadHook === "function") {
      opt.installUnloadHook(() => {
        this.sendImmediateInner();
      });
    }
  }
  assemblePayload(arr = this.arr) {
    const payload = {
      __logs__: arr
    };
    if (this.opt.tags) {
      payload.__tags__ = this.opt.tags;
    }
    if (this.opt.topic) {
      payload.__topic__ = this.opt.topic;
    }
    if (this.opt.source) {
      payload.__source__ = this.opt.source;
    }
    return JSON.stringify(payload);
  }
  platformSend() {
    if (this.opt.sendPayload && typeof this.opt.sendPayload === "function") {
      const payloadStr = this.assemblePayload();
      this.opt.sendPayload(this.url, payloadStr);
    }
  }
  transString(obj) {
    let newObj = {};
    for (let i in obj) {
      if (typeof obj[i] == "object") {
        newObj[i] = JSON.stringify(obj[i]);
      } else {
        newObj[i] = String(obj[i]);
      }
    }
    return newObj;
  }
  sendImmediateInner() {
    if (this.arr && this.arr.length > 0) {
      this.platformSend();
      if (this.timer != null) {
        clearTimeout(this.timer);
        this.timer = null;
      }
      this.arr = [];
    }
  }
  sendInner() {
    if (this.timer) {
      if (this.arr.length >= this.count) {
        clearTimeout(this.timer);
        this.timer = null;
        this.sendImmediateInner();
      }
    } else {
      const that = this;
      if (this.arr.length >= this.count || this.time <= 0) {
        this.sendImmediateInner();
      } else {
        this.timer = setTimeout(function() {
          that.sendImmediateInner();
        }, this.time * 1e3);
      }
    }
  }
  send(originLog) {
    const obj = this.transString(originLog);
    this.arr.push(obj);
    this.sendInner();
  }
  sendImmediate(originLog) {
    const obj = this.transString(originLog);
    this.arr.push(obj);
    this.sendImmediateInner();
  }
  sendBatchLogs(originLogs) {
    const logs = originLogs.map((originLog) => this.transString(originLog));
    this.arr.push(...logs);
    this.sendInner();
  }
  sendBatchLogsImmediate(originLogs) {
    const logs = originLogs.map((originLog) => this.transString(originLog));
    this.arr.push(...logs);
    this.sendImmediateInner();
  }
}

export { WebTracker as default };
//# sourceMappingURL=web-track-base.es.js.map
