'use strict';

var webBase = require('@aliyun-sls/web-base');
var WebTracker = require('@aliyun-sls/web-track-base');

function sendBeacon(url, payload) {
  if (navigator && navigator.sendBeacon) {
    return navigator.sendBeacon(`${url}?APIVersion=0.6.0`, payload);
  }
  return false;
}
function sendUseXhr(url, reqPayload) {
  const httpRequest_ = new window.XMLHttpRequest();
  httpRequest_.open("POST", `${url}?APIVersion=0.6.0`, true);
  httpRequest_.send(reqPayload);
}
function send(url, payload) {
  try {
    if (payload.length >= 32768) {
      sendUseXhr(url, payload);
      return;
    }
    if (!sendBeacon(url, payload)) {
      sendUseXhr(url, payload);
    }
  } catch (ex) {
    if (window && window.console && typeof window.console.error === "function") {
      console.error("Failed to log to ali log service because of this exception:\n" + ex);
      console.error("Failed log data:", url);
    }
  }
}
class WebTrackerBrowser extends WebTracker {
  constructor(opt) {
    const superOpt = Object.assign({}, opt, {
      installUnloadHook: (hook) => {
        window.addEventListener("beforeunload", () => {
          hook();
        });
      },
      sendPayload: (url, payload) => {
        send(url, payload);
      }
    });
    super(superOpt);
  }
}

webBase.defineGlobal(window, "SLS_Tracker", WebTrackerBrowser);

module.exports = WebTrackerBrowser;
//# sourceMappingURL=web-track-browser.js.map
