type Duration = number & {
    d: 'Duration in ms';
};
type ServerDuration = number & {
    s: 'Duration in ns';
};
type TimeStamp = number & {
    t: 'Epoch time in ms';
};
type RelativeTime = number & {
    r: 'Time relative to navigation start';
} & {
    d: 'Duration in ms';
};
type ClocksState = {
    relative: RelativeTime;
    timeStamp: TimeStamp;
};
type MatchFun = (url: string) => boolean;
type MatchRequestFun = (url: string, status?: number) => boolean;
type MatchRequestTypes = MatchRequestFun | string | RegExp;
type MatchCommonTypes = MatchFun | string | RegExp;
type MatchTraceRequestTypes = MatchCommonTypes;
type IgnoreAllTypes = MatchRequestTypes | MatchCommonTypes;
type UnknownFunc = (...args: unknown[]) => void;
declare enum WebEventType {
    ERROR = "error",
    LOG = "log",
    LOCATION = "pv",
    API = "api",
    RESOURCE = "res",
    RESOURCE_ERROR = "res_err",
    PERF = "perf",
    CONSOLE_LOG = "console",
    DOM_CLICK = "dom_click"
}
declare enum InternalPlugin {
    LOG_SEND = "LOG_SEND",
    BROWSER_SEND = "BROWSER_SEND",
    BASE_TRANSFORM = "BASE_TRANSFORM",
    BROWSER_BASE_TRANSFORM = "BROWSER_BASE_TRANSFORM",
    BROWSER_FETCH = "BROWSER_FETCH",
    BROWSER_XHR = "BROWSER_XHR",
    BROWSER_DOM = "BROWSER_DOM",
    BROWSER_LOCATION = "BROWSER_LOCATION",
    BROWSER_RUNTIME_ERROR = "BROWSER_RUNTIME_ERROR",
    BROWSER_CUSTOM_ERROR = "BROWSER_CUSTOM_ERROR",
    BROWSER_RESOURCE_ERROR = "BROWSER_RESOURCE_ERROR",
    BROWSER_CONSOLE = "BROWSER_CONSOLE",
    BROWSER_PERF = "BROWSER_PERF",
    BROWSER_RESOURSE = "BROWSER_RESOURSE",
    MINI_SEND = "MINI_SEND",
    MINI_REQUEST = "MINI_REQUEST",
    MINI_BASE_TRANSFORM = "MINI_BASE_TRANSFORM",
    MINI_ROUTE = "MINI_ROUTE"
}
declare const InternalPluginPriority: {
    BROWSER_SEND: number;
    MINI_SEND: number;
    BASE_TRANSFORM: number;
    BROWSER_BASE_TRANSFORM: number;
    MINI_BASE_TRANSFORM: number;
    BROWSER_PERF: number;
    BROWSER_FETCH: number;
    BROWSER_XHR: number;
    MINI_REQUEST: number;
    BROWSER_RUNTIME_ERROR: number;
};
declare const SLS_TRACE_UID_KEY = "sls-trace-uid";
interface IRequestExtra {
    start: number;
    relativeTime: RelativeTime;
    duration: Duration;
    httpInfo: Record<string, any>;
}

/**
 * 标准OT数据格式
 */
interface OTTrace {
    start: number;
    attribute: Record<string, any>;
    resource: Record<string, any>;
    duration: number;
    end: number;
    host: string;
    kind: string;
    links: any[];
    logs: any[];
    name: string;
    parentSpanID: string | undefined;
    service: string;
    spanID: string;
    statusCode: OTStatusCode;
    statusMessage: string | undefined;
    traceID: string;
}
declare enum OTStatusCode {
    OK = "OK",
    ERROR = "ERROR",
    UNSET = "UNSET"
}
interface OTHttpInfo {
    method: string;
    url: string;
    target: string;
    host: string;
    scheme: string;
    status_code: string;
}

interface WebTrackerOptions {
    host: string;
    project: string;
    logstore: string;
    /**
     * 发送时间阈值, default 10s
     */
    time?: number;
    /**
     * 发送条数阈值, default 10
     */
    count?: number;
    /**
     * 日志主题
     */
    topic?: string;
    /**
     * 日志来源
     */
    source?: string;
    /**
     * 日志标签
     */
    tags?: Record<string, any>;
    installUnloadHook?: (hook: () => void) => void;
    sendPayload: (url: string, payload: string) => void;
}
type OmitedWebTrackerOptions = Omit<WebTrackerOptions, 'installUnloadHook' | 'sendPayload'>;
interface MiniPlatformOptions {
    /**
     * 小程序平台的 SDK，例如微信小程序就是 wx，已经适配的平台可以不用填写
     */
    platformSDK?: any;
    /**
     * 小程序平台 SDK 发送请求的接口字符串名称，例如微信小程序就是 request，默认会使用 request 或者 httpRequest
     */
    platformRequestName?: string;
}
interface WebTrackerMiniOptions extends OmitedWebTrackerOptions, MiniPlatformOptions {
}
type WebTrackerBrowserOptions = Omit<WebTrackerOptions, 'installUnloadHook' | 'sendPayload'>;

declare const SLS_CLIENT_NAME = "SLS_CLIENT";
interface ISession {
    getSessionId: () => string;
    getPageId: () => string;
    refreshPageId: () => void;
}
interface IBaseSession {
    sessionId: string;
    pageId: string;
}
interface SLS_ClientBaseOptions {
    project: string;
    host: string;
    logstore: string;
    workspace: string;
    uid?: string;
    nickname?: string;
    /**
     * 环境，默认为prod
     */
    env?: string;
    /**
     * 当前服务，浏览器默认为 web，小程序下默认为 miniprogram
     */
    service?: string;
    /**
     * 服务 namespace
     */
    namespace?: string;
    /**
     * 版本号
     */
    version?: string;
    /**
     * 自定义字段
     */
    custom?: Record<string, any>;
    /**
     * 发送数据的时间阈值，单位秒（s），在该阈值时间内的数据会合并发送，默认值为2，0为立即发送
     */
    trackTimeThreshold?: number;
    /**
     * 发送数据的条数阈值，在该阈值内的条数会合并发送，默认值为10，0和1都为立即发送
     */
    trackCountThreshold?: number;
    /**
     * 附加 resource，添加到所有 span
     */
    resource?: Record<string, number>;
    /**
     * 附加 attribute，添加到所有 span
     */
    attribute?: Record<string, number>;
}
type SLS_MUTABLE_OPTION = Pick<SLS_ClientBaseOptions, 'uid' | 'nickname' | 'env' | 'service' | 'version' | 'custom' | 'namespace'>;
interface IBasePlugin<BaseOptions extends SLS_ClientBaseOptions, OT extends OTTrace> {
    /**
     * key, use for subscribe and notify data events.
     */
    name: string;
    /**
     * plugin 启动函数，只会运行一次
     * @returns
     */
    run: (this: ClientContext<BaseOptions, OT>) => void;
}
interface NotifyData<OT extends Partial<OTTrace>, Extra = Record<string, any> | undefined> {
    otBase: OT;
    extra: Extra;
}
type SubscribeCallback<OT extends Partial<OTTrace>> = (data: NotifyData<OT>, next: (data: NotifyData<OT>) => void) => void;
interface SubscribeDep<OT extends Partial<OTTrace>> {
    name: string;
    priority: number;
    callback: SubscribeCallback<OT>;
}
interface BaseClientContext<BaseOptions extends SLS_ClientBaseOptions> {
    options: BaseOptions;
    session: ISession;
}
interface ClientContext<BaseOptions extends SLS_ClientBaseOptions, OT extends OTTrace> extends BaseClientContext<BaseOptions> {
    notify: (data: NotifyData<Partial<OTTrace>>) => void;
    subscribe: (target: string, callback: SubscribeCallback<OT>, priority: number) => void;
}
interface BasePublicApi<BaseOptions extends SLS_ClientBaseOptions, OT extends OTTrace> {
    init: (options: BaseOptions) => void;
    addLog: (log: Record<string, any>) => void;
    onReady: (callback: () => void) => void;
    setOptions: (options: BaseOptions) => void;
    use: (plugin: IBasePlugin<BaseOptions, OT>) => void;
}
type IEnableTrackRequestBody = boolean | ((data: NotifyData<Partial<OTTrace>>) => boolean) | 'error' | undefined;
interface SLS_BrowserClientOptions extends SLS_ClientBaseOptions {
    /**
     * 是否打开链路追踪，默认为 false
     */
    enableTrace?: boolean;
    /**
     * 自定义配置需要开启 trace 的请求
     * web下不传就是同域名的都开启，传了后所有域名都要经过判断
     * 小程序下不传就是默认都开启
     */
    enableTraceRequestConfig?: MatchTraceRequestTypes[];
    /**
     * 自定义配置 trace header
     */
    customTraceHeaders?: Record<string, string>;
    /**
     * 上报请求数据（fetch、xhr、...），默认为 true
     */
    enableRequest?: boolean;
    /**
     * 配置哪些请求不上报，默认全部上报
     */
    ignoreRequestConfig?: MatchRequestTypes[];
    /**
     * 自定义配置哪些请求需要记录 body
     */
    enableRequestBodyConfig?: IEnableTrackRequestBody;
    /**
     * 是否上报JS错误，默认为true
     */
    enableRuntimeError?: boolean;
    /**
     * 自定义配置哪些运行时错误需要忽略
     */
    ignoreRuntimeErrorConfig?: MatchCommonTypes[];
    /**
     * 是否上报JS资源错误，默认为true
     */
    enableResourceError?: boolean;
    /**
     * 上报资源性能数据（js、css、image、audio、vedio)，默认为 true
     */
    enableResourcePerf?: boolean;
    /**
     * 自定义配置哪些资源的请求需要忽略
     */
    ignoreResourceConfig?: MatchCommonTypes[];
    /**
     * 是否上报页面加载性能数据，默认为 true
     */
    enablePerf?: boolean;
    /**
     * 是否记录console打印记录，默认为 false
     * 支持配置级别，支持 'error' | 'warn' | 'log' | 'info' | 'debug' | false
     * 例如 配置为 'info' 则只记录 error、warn、info 级别的日志
     */
    enableConsoleLog?: 'error' | 'warn' | 'log' | 'info' | 'debug' | false;
    /**
     * 是否记录用户点击事件
     */
    enableDomClick?: boolean;
    /**
     * 点击事件节流延迟时间, 默认 300 ms
     */
    clickThrottleTime?: number;
}
interface SLS_TraceMiniClientOptions extends SLS_ClientBaseOptions, MiniPlatformOptions, Pick<SLS_BrowserClientOptions, 'enableTrace' | 'enableTraceRequestConfig' | 'customTraceHeaders' | 'enableRequest' | 'ignoreRequestConfig' | 'enableRequestBodyConfig'> {
}
interface ClientRef<Client> {
    current?: Client;
}

export { BaseClientContext, BasePublicApi, ClientContext, ClientRef, ClocksState, Duration, IBasePlugin, IBaseSession, IEnableTrackRequestBody, IRequestExtra, ISession, IgnoreAllTypes, InternalPlugin, InternalPluginPriority, MatchCommonTypes, MatchFun, MatchRequestFun, MatchRequestTypes, MatchTraceRequestTypes, MiniPlatformOptions, NotifyData, OTHttpInfo, OTStatusCode, OTTrace, OmitedWebTrackerOptions, RelativeTime, SLS_BrowserClientOptions, SLS_CLIENT_NAME, SLS_ClientBaseOptions, SLS_MUTABLE_OPTION, SLS_TRACE_UID_KEY, SLS_TraceMiniClientOptions, ServerDuration, SubscribeCallback, SubscribeDep, TimeStamp, UnknownFunc, WebEventType, WebTrackerBrowserOptions, WebTrackerMiniOptions, WebTrackerOptions };
