'use strict';

const SLS_CLIENT_NAME = "SLS_CLIENT";

var WebEventType = /* @__PURE__ */ ((WebEventType2) => {
  WebEventType2["ERROR"] = "error";
  WebEventType2["LOG"] = "log";
  WebEventType2["LOCATION"] = "pv";
  WebEventType2["API"] = "api";
  WebEventType2["RESOURCE"] = "res";
  WebEventType2["RESOURCE_ERROR"] = "res_err";
  WebEventType2["PERF"] = "perf";
  WebEventType2["CONSOLE_LOG"] = "console";
  WebEventType2["DOM_CLICK"] = "dom_click";
  return WebEventType2;
})(WebEventType || {});
var InternalPlugin = /* @__PURE__ */ ((InternalPlugin2) => {
  InternalPlugin2["LOG_SEND"] = "LOG_SEND";
  InternalPlugin2["BROWSER_SEND"] = "BROWSER_SEND";
  InternalPlugin2["BASE_TRANSFORM"] = "BASE_TRANSFORM";
  InternalPlugin2["BROWSER_BASE_TRANSFORM"] = "BROWSER_BASE_TRANSFORM";
  InternalPlugin2["BROWSER_FETCH"] = "BROWSER_FETCH";
  InternalPlugin2["BROWSER_XHR"] = "BROWSER_XHR";
  InternalPlugin2["BROWSER_DOM"] = "BROWSER_DOM";
  InternalPlugin2["BROWSER_LOCATION"] = "BROWSER_LOCATION";
  InternalPlugin2["BROWSER_RUNTIME_ERROR"] = "BROWSER_RUNTIME_ERROR";
  InternalPlugin2["BROWSER_CUSTOM_ERROR"] = "BROWSER_CUSTOM_ERROR";
  InternalPlugin2["BROWSER_RESOURCE_ERROR"] = "BROWSER_RESOURCE_ERROR";
  InternalPlugin2["BROWSER_CONSOLE"] = "BROWSER_CONSOLE";
  InternalPlugin2["BROWSER_PERF"] = "BROWSER_PERF";
  InternalPlugin2["BROWSER_RESOURSE"] = "BROWSER_RESOURSE";
  InternalPlugin2["MINI_SEND"] = "MINI_SEND";
  InternalPlugin2["MINI_REQUEST"] = "MINI_REQUEST";
  InternalPlugin2["MINI_BASE_TRANSFORM"] = "MINI_BASE_TRANSFORM";
  InternalPlugin2["MINI_ROUTE"] = "MINI_ROUTE";
  return InternalPlugin2;
})(InternalPlugin || {});
const InternalPluginPriority = {
  ["BROWSER_SEND" /* BROWSER_SEND */]: -1,
  ["MINI_SEND" /* MINI_SEND */]: -2,
  // 基础
  ["BASE_TRANSFORM" /* BASE_TRANSFORM */]: 100,
  // 平台基础
  ["BROWSER_BASE_TRANSFORM" /* BROWSER_BASE_TRANSFORM */]: 100 * 2,
  ["MINI_BASE_TRANSFORM" /* MINI_BASE_TRANSFORM */]: 100 * 2 + 1,
  // 附加性能
  ["BROWSER_PERF" /* BROWSER_PERF */]: 100 * 3 + 1,
  // 附加请求
  ["BROWSER_FETCH" /* BROWSER_FETCH */]: 100 * 4,
  ["BROWSER_XHR" /* BROWSER_XHR */]: 100 * 4 + 1,
  ["MINI_REQUEST" /* MINI_REQUEST */]: 100 * 4 + 2,
  // 错误
  ["BROWSER_RUNTIME_ERROR" /* BROWSER_RUNTIME_ERROR */]: 100 * 5
};
const SLS_TRACE_UID_KEY = "sls-trace-uid";

var OTStatusCode = /* @__PURE__ */ ((OTStatusCode2) => {
  OTStatusCode2["OK"] = "OK";
  OTStatusCode2["ERROR"] = "ERROR";
  OTStatusCode2["UNSET"] = "UNSET";
  return OTStatusCode2;
})(OTStatusCode || {});

exports.InternalPlugin = InternalPlugin;
exports.InternalPluginPriority = InternalPluginPriority;
exports.OTStatusCode = OTStatusCode;
exports.SLS_CLIENT_NAME = SLS_CLIENT_NAME;
exports.SLS_TRACE_UID_KEY = SLS_TRACE_UID_KEY;
exports.WebEventType = WebEventType;
//# sourceMappingURL=web-types.js.map
