
import { _decorator, Component, Node, ISchedulable, director, find, Scheduler } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = TimerClock
 * DateTime = Mon Nov 15 2021 14:26:23 GMT+0800 (中国标准时间)
 * Author = 恩赐束缚
 * FileBasename = timerClock.ts
 * FileBasenameNoExtension = timerClock
 * URL = db://assets/ScriptLib/timerClock.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('TimerClock')
export class TimerClock implements ISchedulable {
    // 为了启动 update 没有逻辑意义
    id: ''
    uuid = ''

    public remainTime: number = 0; // 剩余时间
    public totleTime: number = 0; // 总时间
    private cb: Function = null;
    private cbTarget: any = null;
    private cbArg: any
    public get isWorking() {
        return this.remainTime > 0;
    }
    public runClock(totleTime: number, cb?: Function, cbTarget?: any, cbArg?: any) {
        this.remainTime = Math.max(totleTime, this.remainTime)
        this.totleTime = this.remainTime;
        this.cb = cb;
        this.cbTarget = cbTarget;
        this.cbArg = cbArg;
        Scheduler.enableForTarget(this)
        director.getScheduler().scheduleUpdate(this, 0, false)
    }
    public cancel() {
        this.remainTime = 0;
        this.cb = null;
        this.cbTarget = null;
        director.getScheduler().unscheduleUpdate(this)
    }
    private update(dt: number) {
        // console.log('noise ', dt);
        if (this.isWorking == false) return
        this.remainTime -= dt;
        if (this.remainTime <= 0) {
            if (this.cb && this.cbTarget) {
                this.cb.apply(this.cbTarget, [this.cbArg]);
                this.cancel()
            }
        }
    }
}

