const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Sprite)
    sprite: cc.Sprite = null;

    @property(cc.Node)
    btn1: cc.Node = null;
    @property(cc.Node)
    btn2: cc.Node = null;
    @property(cc.Node)
    btn3: cc.Node = null;

    start() {
        this.btn1.on(cc.Node.EventType.TOUCH_END, this.onTapH, this);
        this.btn2.on(cc.Node.EventType.TOUCH_END, this.onTapH, this);
        this.btn3.on(cc.Node.EventType.TOUCH_END, this.onTapH, this);
    }

    private onTapH(e): void {
        switch(e.currentTarget){
            case this.btn1:
                this.load("");
            break;
            case this.btn2:
                this.setSprite(null);
            break;
            case this.btn3:
                this.load("HelloWorld")
            break;
        }
    }

    private load(atlas, res?): void {
        cc.resources.load(atlas, res ? cc.SpriteAtlas : cc.SpriteFrame, function (err, atlas) {
            let frame = atlas;
            if (res) {
                frame = frame.getSpriteFrame(res);
            }
            this.setSprite(frame);
        }.bind(this));
    }

    private setSprite(frame): void {
        this.sprite.spriteFrame = frame;
    }
}
