#!/usr/bin/python 
# coding: UTF-8

# 使用apktools进行解包
import os
import sys


#签名
SIGN_STORPASS = "签名密钥"
SIGN_KEYPASS = "签名密钥"
SIGN_KEY_ALIAS = "签名别名"  #别名


PROJECT_PATH = os.getcwd().replace('\\','/')              # 获得当前工作目录 当前脚本位置  
APK_PATH = PROJECT_PATH + "/apk"                          # 原始apk包存放目录
UNPACK_PATH = PROJECT_PATH +"/output"                     # 解包输出目录
NEWAPK_PATH = PROJECT_PATH + "/newApk"                    # 新APK包存放目录
SIGN_PATH = PROJECT_PATH + "/xxxx.jks"                    # 签名文件
APKTOOLS_PATH = PROJECT_PATH + "/" + "apktool_2.6.0.jar"  # APKTOOLS文件路径


#解包
def unPack():
	print("开始解包")
	files= os.listdir(APK_PATH)		#得到文件夹下的所有文件名称
	for fileName in files:
		path = APK_PATH+ "/" +fileName
		print("当前解包:"+path)
		dirName = fileName.split(".")
		gm = "java -jar " + APKTOOLS_PATH + " d -f " + path +" -o " + UNPACK_PATH + "/" + dirName[0]
		print("执行解包命令",gm)
		os.system(gm)

#捆包
def bale():
	print("开始捆包")
	files= os.listdir(UNPACK_PATH)		#得到文件夹下的所有文件名称
	for fileName in files:
		path = UNPACK_PATH + "/" +fileName
		newPath = NEWAPK_PATH + "/" + fileName +".apk"
		print("当前捆包:"+path)
		gm = "java -jar " + APKTOOLS_PATH + " b -f " + path + " -o "+ newPath
		print("--------------执行捆绑命令---------------")
		print(gm)
		os.system(gm)

		sign_gm = "jarsigner -digestalg SHA1 -sigalg MD5withRSA -tsa http://sha256timestamp.ws.symantec.com/sha256/timestamp -keystore " +  SIGN_PATH + " -storepass "+ SIGN_STORPASS +" -keypass "+ SIGN_KEYPASS + " " + newPath + " " + SIGN_KEY_ALIAS
		print("--------------执行签名命令---------------")
		print(sign_gm)
		os.system(sign_gm)

		print("--------------获取签名信息---------------")
		get_sign_gm = "keytool -v -list -printcert -jarfile " + newPath
		print(get_sign_gm)
		os.system(get_sign_gm)


def main():
	print("项目地址",PROJECT_PATH)
	print("原始apk包存放目录",APK_PATH)
	print("解包输出目录",UNPACK_PATH)
	print("新APK包存放目录",NEWAPK_PATH)
	print("APKTOOLS文件路径",APKTOOLS_PATH)

	unPack()
	bale()

main()