#!/usr/bin/env python3
#-*- coding:utf-8 -*-


import os
import sys
import time
import getopt
import tarfile
from xml.dom import minidom
import codecs
import re
import json
import math
import shutil


#APP名称
APP_NAME = "testApp"
#默认包名
PACKAGE_NAME = "com.test.pack"
#ICON 名称
ICON_NAME = "ic_launcher.png"



#项目地址
PROJECT_PATH = os.getcwd().replace('\\','/') #获得当前工作目录
#xml文件地址 
ANDROIDMANIFEST_PATH = PROJECT_PATH + "/app/AndroidManifest.xml"
#临时xml文件
ANDROIDMANIFEST_TEMP_PATH = PROJECT_PATH + "/app/AndroidManifest_temp.xml"
#ICON地址
ICON_PATH = PROJECT_PATH + "/icon/"
#RES地址
RES_PATH = PROJECT_PATH + "/app/res"
#string地址
STRING_PATH = PROJECT_PATH + "/app/res/values/strings.xml"
#临时string地址
STRING_TEMP_PATH = PROJECT_PATH + "/app/res/values/strings_temp.xml"
#gradle文件路径
GRADLE_PATH = PROJECT_PATH + "/gradle.properties"
#临时gradle文件
GRADLE_TEMP_PATH = PROJECT_PATH + "/gradle_temp.properties"





#获取文件值
def getFileValue(file_path,data):
    if not os.path.exists(file_path):
        print("文件不存在",file_path)
        return
    if not bool(data):
        print(u"传入修改的string.xml参数为空")
        return
    result = {}
    f=open(file_path, 'r',encoding='utf-8')
    for line in f:
            # print(line)
            if re.search(data, line):
                print(line)
                # exit()
                result[data]=str(line).split("=")[1]
                print(str(line).split("=")[1])
                break
    f.close()
    print("获取的属性",result)
    return result


# 修改String.xml文件信息
def modifyStringXMLfile(file_path,file_temp_path,data):
    if not bool(data):
        print(u"传入修改的string.xml参数为空")
        return
    if not os.path.exists(file_path):
        print("文件不存在",file_path)
        return
    f=open(file_path, 'r',encoding='utf-8')
    f2=open(file_temp_path, 'w+',encoding='utf-8')    
    for line in f:
        for key,value in data.items():
            if key and key != "" and value and value != "" and re.search(key, line):
                if key == "app_name":
                    line = '    <string name="app_name">'+str(value)+'</string>\n'
                    print(u"修改String.xml中的游戏名 ",line)
        f2.write(line)
               
    f.close()
    f2.close()
    os.remove(file_path)  # 删除要修改的文件
    os.rename(file_temp_path, file_path)  # 把新建的文件重命名为修改的文件


# 修改AndroidManifest.xml文件信息
def modifyAndroidManifestXMLfile(file_path,file_temp_path,data):
    if not bool(data):
        print(u"传入修改的AndroidManifest.xml参数为空")
        return
    if not os.path.exists(file_path):
        print("文件不存在",file_path)
        return
    f=open(file_path, 'r',encoding='utf-8')
    f2=open(file_temp_path, 'w+',encoding='utf-8')    
    for line in f:
        for key,value in data.items():
            if key and key != "" and value and value != "" and re.search(key, line):
                if key == "package":
                    line='    package="'+value+'"\n'
                    print(u"修改AndroidManifest.xml中的包名 ",line)
        f2.write(line)
                           
    f.close()
    f2.close()
    os.remove(file_path)  # 删除要修改的文件
    os.rename(file_temp_path, file_path)  # 把新建的文件重命名为修改的文件


#修改gradle.build 信息
def modifyGradle(data):
    if not bool(data):
        print(u"gradle.build参数为空")
        return
    if not os.path.exists(GRADLE_PATH):
        print("文件不存在",GRADLE_PATH)
        return
    f=open(GRADLE_PATH, 'r',encoding='utf-8')
    f2=open(GRADLE_TEMP_PATH, 'w+',encoding='utf-8')    
    for line in f:
        for key,value in data.items():
            if key and key != "" and value and value != "" and re.search(key, line):
                if key == "APPLICATION_ID":
                    line='APPLICATION_ID=%s\n' %str(value)
                    print(u"修改gradle.build中的包名 ",line)
                elif key == "VERSION_CODE":
                    line="VERSION_CODE={}\n".format(str(value))
                    print(u"修改gradle.build中的版本 ",line)
                elif key == "VERSION_NAME":
                    line='VERSION_NAME=%s\n' % str(value)
                    print(u"修改gradle.build中的版本名 ",line)
        f2.write(line)
    f.close()
    f2.close()

    os.remove(GRADLE_PATH)  # 删除要修改的文件
    os.rename(GRADLE_TEMP_PATH, GRADLE_PATH)  # 把新建的文件重命名为修改的文件


#复制icon到指定路径
def copyIconToPath(reIcon):
    if not reIcon or reIcon == "" or reIcon == None: #使用默认icon
        reIcon = ICON_NAME

    list_dirs = os.walk(ICON_PATH)  #替换新的Icon
    for root, dirs, files in list_dirs: 
        for d in dirs: 
            print(os.path.join(root, d))      
        for f in files:
            rePath = os.path.join(root, f)
            dirName = os.path.basename(root)
            if dirName and dirName != "" and re.search("mipmap-", dirName):
                if reIcon == f:
                    outPath = '{0}/{1}/{2}'.format(RES_PATH,dirName,f)
                    defaultPath = '{0}/{1}/{2}'.format(RES_PATH,dirName,ICON_NAME)
                    if os.path.exists(defaultPath):
                        os.remove(defaultPath) #删除原先的icon文件
                    shutil.copyfile(rePath,outPath) #将新的icon拷贝过去
                    os.rename(outPath,defaultPath) #将新的文件重新命名





#根据versioncode获得versionName
def get_version_name(versionCode):
    a=1;b=0;c=0
    if versionCode<10:
        c = versionCode
    elif versionCode>=10 and versionCode <100:
        b = int(math.floor(versionCode/10))
        c = int(versionCode - (b*10))
    elif versionCode>=100:
        a = a + int(math.floor(versionCode/100))
        b = int(math.floor((versionCode - ((a-1)*100)) / 10))
        c = int(versionCode - ((a-1)*100) - (b*10))
    strNum = str(a) + '.'+str(b)+'.'+str(c)
    print("VersionName=",strNum,'*******',a,b,c)
    return strNum



def main():
    print(u"开始打包")
    #替换Icon
    copyIconToPath("icon名称")
    
    # build.gradle 要修改的属性
    gradleTable = {
        "APPLICATION_ID":"com.xxx.xxx",  #包名
        "VERSION_CODE": 1.0.0, #版本号 int
        "VERSION_NAME": 1.0.0, #版本名称 int 
    }
    modifyGradle(gradleTable)

    # androidmanifest.xml 要修改的属性
    androidmanifestTable = {
        "package":"com.xxx.xxx",            #包名
    } 
    modifyAndroidManifestXMLfile(ANDROIDMANIFEST_PATH,ANDROIDMANIFEST_TEMP_PATH,androidmanifestTable)

    # string.xml 要修改的属性
    stringTable = {
        "app_name": "游戏名称"   #app名称
    }  
    modifyStringXMLfile(STRING_PATH,STRING_TEMP_PATH,stringTable)
    


main()