import { _decorator, Component, Node, TiledMap, UIOpacity } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Controller')
export class Controller extends Component {
    @property({ type: TiledMap })
    public tileMap: TiledMap;

    start() {
        let mapLayer = this.tileMap.getLayer('ground');
        let layerSize = mapLayer.getLayerSize();
        // 可以设置TiledLayer节点active状态为true，从而显示地图
        mapLayer.node.active = true;

        for (let i = 0; i < layerSize.width; i++) {
            for (let j = 0; j < layerSize.height; j++) {
                let tile = mapLayer.getTiledTileAt(i, j, true);
                // 可以设置TiledLayer节点active状态false，但无法隐藏tiledTile的节点
                tile.node.active = false;
                // 设置TiledTile节点opacity，但tiledTile节点透明度没有变化
                let opacityComp = tile.node.addComponent(UIOpacity);
                opacityComp.opacity = 0;
                console.log(tile);
            }
        }
        console.log(mapLayer);
    }
}
