import { BuffTime, BuffType } from "./SkillConst";
import getBuffData, { BuffId } from "./BuffData";

const {ccclass, property} = cc._decorator;

@ccclass
export default class BuffComponent extends cc.Component {
    private _buffId: BuffId = BuffId.NULL;
    set buffId (id: BuffId) {
        if (this._buffId === id) return;
        this._buffId = id;
        let data = getBuffData(id);
        this.buffName = data.name;
        this.buffIcon = data.icon;
        this.buffTime = data.dotime;
        this.continued = data.continued;
        this.buffType = data.type;
        this.doFunc = data.func;
    }
    get buffId () {
        return this._buffId;
    }

    private _buffName: string;      // 名称
    private _buffIcon: string;      // TODO 图标展示
    private _buffTime: BuffTime;    // 触发时机
    private _continued: number;     // 持续回合
    private _buffType: BuffType;    // 类型
    private _doFunc: Function;      // 触发函数

    get buffName () {
        return this._buffName;
    }
    set buffName (value: string) {
        this._buffName = value;
    }
    get buffIcon () {
        return this._buffIcon;
    }
    set buffIcon (value: string) {
        this._buffIcon = value;
    }
    get buffTime () {
        return this._buffTime;
    }
    set buffTime (value: BuffTime) {
        this._buffTime = value;
    }
    get continued () {
        return this._continued;
    }
    set continued (value: number) {
        this._continued = value;
    }
    get buffType () {
        return this._buffType;
    }
    set buffType (value: number) {
        this._buffType = value;
    }
    get doFunc () {
        return this._doFunc;
    }
    set doFunc (value: Function) {
        this._doFunc = value;
    }

    initBuff (id: BuffId) {
        this.buffId = id;
    }
}
