import { BuffTime, BuffType } from "./SkillConst";
import Hero from "../prefab/Hero";

export const enum BuffId {
    NULL,
    KongCheng,
}

export default function getBuffData (id: BuffId): BuffData {
    return new BuffData(data[id]);
}

class BuffData {
    name: string;
    icon: string;
    dotime: BuffTime;
    continued: number;
    type: BuffType;
    func: Function;

    constructor (data) {
        this.name = data.name;
        this.icon = data.icon;
        this.dotime = data.dotime;
        this.continued = data.continued;
        this.type = data.type;
        this.func = data.func;
    }
}

const data = {
    [BuffId.KongCheng]: {
        name: '空城',
        icon: '',   // 图标暂无
        dotime: BuffTime.onAttack,
        type: BuffType.Reduce,
        continued: 0,   // 持续时长
        func: function (hero:Hero, data:any) :number {
            return 0;
        },
    }
}
